/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractProcessElementLayout;
import org.eclipse.epf.library.layout.elements.DescriptorDescriptionLayout;
import org.eclipse.epf.library.layout.elements.RoleLayout;
import org.eclipse.epf.library.layout.elements.TaskLayout;
import org.eclipse.epf.library.layout.elements.WorkProductLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.DescriptorDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DescriptorLayout
extends AbstractProcessElementLayout {
    public static final Collection<EStructuralFeature> extraFeaturesFromContentElement = Arrays.asList(UmaPackage.eINSTANCE.getContentElement_Assets(), UmaPackage.eINSTANCE.getContentElement_Checklists(), UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers(), UmaPackage.eINSTANCE.getContentElement_Examples(), UmaPackage.eINSTANCE.getContentElement_Guidelines(), UmaPackage.eINSTANCE.getContentElement_SupportingMaterials());
    MethodElement linkedElement = null;
    AbstractElementLayout elementLayout = null;

    @Override
    protected void __init(ElementLayoutManager layoutManager, MethodElement element) {
        super.__init(layoutManager, element);
        if (element instanceof TaskDescriptor) {
            this.linkedElement = ((TaskDescriptor)element).getTask();
            this.linkedElement = ConfigurationHelper.getCalculatedElement(this.linkedElement, layoutManager.getElementRealizer());
            if (this.linkedElement != null) {
                this.elementLayout = new TaskLayout();
            }
        } else if (element instanceof RoleDescriptor) {
            this.linkedElement = ((RoleDescriptor)element).getRole();
            this.linkedElement = ConfigurationHelper.getCalculatedElement(this.linkedElement, layoutManager.getElementRealizer());
            if (this.linkedElement != null) {
                this.elementLayout = new RoleLayout();
            }
        } else if (element instanceof WorkProductDescriptor) {
            this.linkedElement = ((WorkProductDescriptor)element).getWorkProduct();
            this.linkedElement = ConfigurationHelper.getCalculatedElement(this.linkedElement, layoutManager.getElementRealizer());
            if (this.linkedElement != null) {
                this.elementLayout = new WorkProductLayout();
            }
        }
        if (this.elementLayout != null) {
            this.elementLayout.init(layoutManager, this.linkedElement);
            this.elementLayout.setContentTarget(element);
        }
        if (this.linkedElement != null) {
            TreeIterator iter = this.linkedElement.eAllContents();
            while (iter.hasNext()) {
                iter.next();
            }
        }
    }

    @Override
    public Object getAttributeFeatureValue(EStructuralFeature feature) {
        Object value = super.getAttributeFeatureValue(feature);
        if (this.elementLayout == null || value != null && value.toString().length() > 0) {
            return value;
        }
        if (feature == UmaPackage.eINSTANCE.getMethodElement_BriefDescription()) {
            return this.elementLayout.getAttributeFeatureValue(feature);
        }
        return value;
    }

    @Override
    protected IElementLayout getChildLayout(MethodElement child) {
        if (this.layoutManager.getValidator().showExtraInfoForDescriptors() && child instanceof DescriptorDescription) {
            DescriptorDescriptionLayout l = new DescriptorDescriptionLayout(this.element);
            l.init(this.layoutManager, child);
            return l;
        }
        return this.layoutManager.getLayout(child, true);
    }

    protected Collection<EStructuralFeature> getExtraFeaturesFromContentElement() {
        return extraFeaturesFromContentElement;
    }

    @Override
    protected boolean acceptFeatureValue(EStructuralFeature feature, Object value) {
        Suppression sup = super.getSuppression(this.owningProcess);
        if (sup != null) {
            if (value instanceof List) {
                List items = (List)value;
                int i = 0;
                while (i < items.size()) {
                    Object v = items.get(i);
                    if (this.isSuppressed(sup, feature, v)) {
                        items.remove(i);
                        continue;
                    }
                    ++i;
                }
                if (items.size() == 0) {
                    return false;
                }
            } else if (this.isSuppressed(sup, feature, value)) {
                return false;
            }
        }
        return super.acceptFeatureValue(feature, value);
    }

    protected boolean isSuppressed(Suppression sup, EStructuralFeature feature, Object element) {
        if (element instanceof Descriptor) {
            return sup.isSuppressed(element);
        }
        return false;
    }

    protected boolean isTaskOppositeFeature(OppositeFeature feature) {
        return feature == AssociationHelper.RoleDescriptor_PrimaryTaskDescriptors || feature == AssociationHelper.RoleDescriptor_AdditionalTaskDescriptors || feature == AssociationHelper.RoleDescriptor_AssistsIn_TaskDescriptors || feature == AssociationHelper.WorkProductDescriptor_ExternalInputTo_TaskDescriptors || feature == AssociationHelper.WorkProductDescriptor_MandatoryInputTo_TaskDescriptors || feature == AssociationHelper.WorkProductDescriptor_OptionalInputTo_TaskDescriptors || feature == AssociationHelper.WorkProductDescriptor_OutputFrom_TaskDescriptors;
    }

    @Override
    public XmlElement getXmlElement(boolean includeReferences) {
        XmlElement elementXml = super.getXmlElement(includeReferences);
        if (this.linkedElement != null) {
            String cType = this.linkedElement.getType().getName();
            elementXml.setAttribute("ConcreteType", cType);
        }
        return elementXml;
    }
}

