/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.configuration.PracticeItemProvider;
import org.eclipse.epf.library.edit.util.CategorySortHelper;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PracticeLayout
extends AbstractElementLayout {
    @Override
    public void init(ElementLayoutManager layoutManager, MethodElement element) {
        super.__init(layoutManager, element);
    }

    @Override
    public XmlElement getXmlElement(boolean includeReferences) {
        XmlElement elementXml = super.getXmlElement(includeReferences);
        if (includeReferences) {
            EReference feature = UmaPackage.Literals.PRACTICE__CONTENT_REFERENCES;
            List children = this.calc0nFeatureValue(this.element, null, (EStructuralFeature)feature, this.layoutManager.getElementRealizer());
            List<WorkProduct> wpSlotInputs = this.getInputWpSlots(children);
            EReference feature1 = UmaPackage.Literals.PRACTICE__ACTIVITY_REFERENCES;
            List children1 = this.calc0nFeatureValue(this.element, null, (EStructuralFeature)feature1, this.layoutManager.getElementRealizer());
            EReference feature2 = UmaPackage.Literals.PRACTICE__SUB_PRACTICES;
            List children2 = this.calc0nFeatureValue(this.element, null, (EStructuralFeature)feature2, this.layoutManager.getElementRealizer());
            children.addAll(children1);
            children.addAll(children2);
            ArrayList ret = new ArrayList();
            PracticeItemProvider.GroupingHelper groupingHelper = new PracticeItemProvider.GroupingHelper(this){

                protected void grouping(Object parentObject, List ret, Collection children, PracticeItemProvider.GroupingHelper groupingHelper) {
                    if (this.getGrouper() instanceof PracticeLayout) {
                        ((PracticeLayout)this.getGrouper()).grouping(parentObject, ret, children, groupingHelper);
                    }
                }
            };
            this.grouping(this, ret, children, groupingHelper);
            this.addReferences(feature, elementXml, "Practice guidance tree", ret);
            if (wpSlotInputs != null) {
                this.addReferences(feature, elementXml, "Input work product slots", wpSlotInputs);
            }
        }
        return elementXml;
    }

    private List<WorkProduct> getInputWpSlots(List<MethodElement> elements) {
        HashSet<WorkProduct> slots = new HashSet<WorkProduct>();
        for (MethodElement elem : elements) {
            if (!(elem instanceof Task)) continue;
            Task task = (Task)elem;
            for (WorkProduct wp : task.getMandatoryInput()) {
                if (!wp.getIsAbstract().booleanValue()) continue;
                slots.add(wp);
            }
            for (WorkProduct wp : task.getOptionalInput()) {
                if (!wp.getIsAbstract().booleanValue()) continue;
                slots.add(wp);
            }
        }
        if (slots.isEmpty()) {
            return null;
        }
        ArrayList<WorkProduct> wpSlotInputs = new ArrayList<WorkProduct>();
        wpSlotInputs.addAll(slots);
        if (wpSlotInputs.size() > 1) {
            Comparator comparator = PresentationContext.INSTANCE.getPresNameComparator();
            Collections.sort(wpSlotInputs, comparator);
        }
        return wpSlotInputs;
    }

    @Override
    protected boolean acceptFeatureValue(EStructuralFeature feature, Object value) {
        feature.isMany();
        return super.acceptFeatureValue(feature, value);
    }

    private void grouping(Object parentObject, List ret, Collection children, PracticeItemProvider.GroupingHelper groupingHelper) {
        MethodElement elem;
        Map map = PracticeItemProvider.getSubGroupMap((Collection)children, (PracticeItemProvider.GroupingHelper)groupingHelper);
        boolean toSort = true;
        if (parentObject instanceof PracticeLayout && (elem = ((PracticeLayout)parentObject).element) != null) {
            toSort = !CategorySortHelper.isManualCategorySort((MethodElement)elem);
        }
        String[] keys = groupingHelper.getKeysInOrder();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            List subgroupChildren = (List)map.get(key);
            if (subgroupChildren != null && !subgroupChildren.isEmpty()) {
                if (groupingHelper.toGroup(key, subgroupChildren)) {
                    subgroupChildren = groupingHelper.nestedGrouping(parentObject, key, subgroupChildren);
                    SubGroupValue subGroupValue = new SubGroupValue(key, subgroupChildren);
                    ret.add(subGroupValue);
                } else {
                    if (toSort) {
                        PracticeItemProvider.sort((List)subgroupChildren);
                    }
                    ret.addAll(subgroupChildren);
                }
            }
            ++i;
        }
    }

    @Override
    protected void processNonMethodElementInProcessChild(Object nonMethodElementChild, Object feature, XmlElement parent, boolean includeReferences) {
        if (nonMethodElementChild instanceof SubGroupValue) {
            SubGroupValue subGroupValue = (SubGroupValue)nonMethodElementChild;
            String key = subGroupValue.key;
            List listValue = subGroupValue.listValue;
            this.addReferences(feature, parent, key, listValue);
        }
    }

    @Override
    protected boolean acceptFeatureValue(OppositeFeature feature, Object value) {
        return super.acceptFeatureValue(feature, value);
    }

    static class SubGroupValue {
        public String key;
        public List listValue;

        public SubGroupValue(String key, List listValue) {
            this.key = key;
            this.listValue = listValue;
        }
    }
}

