/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.AssociationHelper;

public class WhitepaperLayout
extends AbstractElementLayout {
    public void init(ElementLayoutManager layoutManager, MethodElement element) {
        super.__init(layoutManager, element);
    }

    public XmlElement getXmlElement(boolean includeReferences) {
        XmlElement elementXml = super.getXmlElement(includeReferences);
        if (includeReferences) {
            List contentElements = ConfigurationHelper.calc0nFeatureValue(this.element, AssociationHelper.Concept_ContentElements, this.layoutManager.getElementRealizer());
            List activities = ConfigurationHelper.calc0nFeatureValue(this.element, AssociationHelper.Concept_BreakdownElements, this.layoutManager.getElementRealizer());
            contentElements.addAll(activities);
            this.addReferences(AssociationHelper.Concept_ContentElements, elementXml, "contentElements", contentElements);
            Guidance guidance = (Guidance)this.element;
            ContentDescription content = guidance.getPresentation();
            if (content != null) {
                EAttribute feature = UmaPackage.eINSTANCE.getGuidanceDescription_Attachments();
                String attachmentString = (String)ConfigurationHelper.calcAttributeFeatureValue((MethodElement)content, this.element, (EStructuralFeature)feature, this.layoutManager.getConfiguration());
                if (attachmentString != null && attachmentString.indexOf("<p/>") > 0) {
                    attachmentString = attachmentString.replaceAll("<p/>", "|");
                }
                List attachmentList = TngUtil.convertGuidanceAttachmentsToList((String)attachmentString);
                for (String attachmentFile : attachmentList) {
                    String fileName;
                    if (attachmentFile == null) continue;
                    Matcher m = ResourceHelper.p_template_attachment_url.matcher(attachmentFile);
                    if (!m.find()) {
                        fileName = FileUtil.getFileName((String)attachmentFile);
                        elementXml.newChild("attribute").setAttribute("name", "attachedFile").setAttribute("url", "file://" + attachmentFile).setAttribute("fileName", fileName);
                        continue;
                    }
                    fileName = m.group(2);
                    elementXml.newChild("attribute").setAttribute("name", "attachedFile").setAttribute("url", m.group(1)).setAttribute("fileName", fileName);
                }
            }
        }
        return elementXml;
    }
}

