/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.uma.FulfillableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkProductLayout
extends AbstractElementLayout {
    @Override
    public void init(ElementLayoutManager layoutManager, MethodElement element) {
        super.__init(layoutManager, element);
    }

    @Override
    public XmlElement getXmlElement(boolean includeReferences) {
        XmlElement elementXml = super.getXmlElement(includeReferences);
        boolean isSlot = false;
        if (this.getElement() instanceof WorkProduct) {
            WorkProduct wp = (WorkProduct)this.getElement();
            isSlot = wp.getIsAbstract();
        }
        if (isSlot) {
            elementXml.setAttribute("Type", "WorkProductSlot");
            elementXml.setAttribute("TypeName", LibraryResources.WorkProductSlot_text);
        }
        if (includeReferences) {
            List responsibleRoles = ConfigurationHelper.calc0nFeatureValue(this.element, AssociationHelper.WorkProduct_ResponsibleRoles, this.layoutManager.getElementRealizer());
            this.addReferences(AssociationHelper.WorkProduct_ResponsibleRoles, elementXml, "responsibleRoles", responsibleRoles);
            List modifyRoles = ConfigurationHelper.calcModifyRoles((WorkProduct)this.element, this.layoutManager.getElementRealizer());
            this.addReferences(null, elementXml, "modifyRoles", modifyRoles);
            List domains = ConfigurationHelper.calc0nFeatureValue(this.element, AssociationHelper.WorkProduct_Domains, this.layoutManager.getElementRealizer());
            this.addReferences(AssociationHelper.WorkProduct_Domains, elementXml, "domains", domains);
            List workProductTypes = ConfigurationHelper.calc0nFeatureValue(this.element, AssociationHelper.WorkProduct_WorkProductTypes, this.layoutManager.getElementRealizer());
            this.addReferences(AssociationHelper.WorkProduct_WorkProductTypes, elementXml, "workProductTypes", workProductTypes);
            List mandatoryInputToTasks = ConfigurationHelper.calc0nFeatureValue(this.element, AssociationHelper.WorkProduct_MandatoryInputTo_Tasks, this.layoutManager.getElementRealizer());
            this.addReferences(AssociationHelper.WorkProduct_MandatoryInputTo_Tasks, elementXml, "mandatoryInputToTasks", mandatoryInputToTasks);
            List optionalInputToTasks = ConfigurationHelper.calc0nFeatureValue(this.element, AssociationHelper.WorkProduct_OptionalInputTo_Tasks, this.layoutManager.getElementRealizer());
            this.addReferences(AssociationHelper.WorkProduct_OptionalInputTo_Tasks, elementXml, "optionalInputToTasks", optionalInputToTasks);
            List outputFromTasks = ConfigurationHelper.calc0nFeatureValue(this.element, AssociationHelper.WorkProduct_OutputFrom_Tasks, this.layoutManager.getElementRealizer());
            this.addReferences(AssociationHelper.WorkProduct_OutputFrom_Tasks, elementXml, "outputFromTasks", outputFromTasks);
            this.includeSlotReferences(elementXml);
            super.processDescriptors(elementXml);
        }
        elementXml.setAttribute("ShowFullMethodContent", this.layoutManager.getValidator().showExtraInfoForDescriptors() ? "true" : "false");
        return elementXml;
    }

    private void includeSlotReferences(XmlElement elementXml) {
        ElementRealizer realizer = this.layoutManager.getElementRealizer();
        FulfillableElement fElement = (FulfillableElement)this.getElement();
        if (fElement.getIsAbstract().booleanValue()) {
            return;
        }
        List<FulfillableElement> slots = ConfigurationHelper.calcFulfillableElement_Fulfills(fElement, realizer.getConfiguration());
        this.addSlotReferences(elementXml, AssociationHelper.WorkProduct_MandatoryInputTo_Tasks, "mandatoryInputToTasks_fromSlots", slots, realizer);
        this.addSlotReferences(elementXml, AssociationHelper.WorkProduct_OptionalInputTo_Tasks, "optionalInputToTasks_fromSlots", slots, realizer);
        this.addSlotReferences(elementXml, AssociationHelper.WorkProduct_OutputFrom_Tasks, "outputFromTasks_fromSlots", slots, realizer);
    }

    private void addSlotReferences(XmlElement elementXml, OppositeFeature ofeature, String referenceName, List<FulfillableElement> slots, ElementRealizer realizer) {
        ArrayList<MethodElement> references = new ArrayList<MethodElement>();
        for (FulfillableElement fElement : slots) {
            List<MethodElement> list = ConfigurationHelper.calc0nFeatureValue((MethodElement)fElement, ofeature, realizer);
            list = this.getTagQualifiedList(realizer.getConfiguration(), list);
            references.addAll(list);
        }
        this.addReferences(ofeature, elementXml, referenceName, references);
    }

    @Override
    protected List calc0nFeatureValue(MethodElement element, MethodElement ownerElement, EStructuralFeature feature, ElementRealizer realizer) {
        if (feature == UmaPackage.eINSTANCE.getFulfillableElement_Fulfills()) {
            return ConfigurationHelper.calcFulfillableElement_Fulfills((FulfillableElement)element, realizer.getConfiguration());
        }
        return super.calc0nFeatureValue(element, ownerElement, feature, this.layoutManager.getElementRealizer());
    }

    @Override
    protected List calc0nFeatureValue(MethodElement element, OppositeFeature feature, ElementRealizer realizer) {
        if (feature == AssociationHelper.FulFills_FullFillableElements) {
            return ConfigurationHelper.calcFulfills_FulfillableElement((FulfillableElement)element, realizer.getConfiguration());
        }
        return super.calc0nFeatureValue(element, feature, this.layoutManager.getElementRealizer());
    }
}

