/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.project;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.project.MethodLibraryProjectNature;
import org.eclipse.epf.uma.MethodLibrary;

public class MethodLibraryProject {
    public static IProject createProject(String path, String projectName, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = MethodLibraryProject.findProject(path);
        if (project != null) {
            project.delete(9, monitor);
        }
        if (projectName == null) {
            File libraryPath = new File(path);
            projectName = libraryPath.getName();
            if (!Workspace.caseSensitive) {
                IProject[] projects;
                IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject prj = iProjectArray[n2];
                    if (MethodLibraryProject.isMethodLibraryProject(prj) && prj.getName().equalsIgnoreCase(projectName)) {
                        project = prj;
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (project == null) {
            project = workspace.getRoot().getProject(projectName);
        }
        if (project.exists()) {
            project.delete(9, monitor);
        }
        IProjectDescription description = workspace.newProjectDescription(projectName);
        description.setNatureIds(MethodLibraryProjectNature.NATURE_IDS);
        Path projectPath = new Path(path);
        if (!Platform.getLocation().isPrefixOf((IPath)projectPath)) {
            description.setLocation((IPath)projectPath);
        }
        project.create(description, monitor);
        return project;
    }

    public static IProject createProject(String path, IProgressMonitor monitor) throws CoreException {
        return MethodLibraryProject.createProject(path, null, monitor);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMethodLibraryProject(IProject project) {
        boolean closeProjectOnExit;
        block13: {
            String[] natureIds;
            IProjectDescription description;
            if (project == null) return false;
            closeProjectOnExit = false;
            if (!project.isOpen()) {
                project.open(128, (IProgressMonitor)new NullProgressMonitor());
                closeProjectOnExit = true;
            }
            if ((description = project.getDescription()) == null || !Arrays.asList(natureIds = description.getNatureIds()).contains(MethodLibraryProjectNature.NATURE_ID)) break block13;
            if (!closeProjectOnExit) return true;
            try {
                project.close((IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            catch (CoreException coreException) {}
            return true;
            catch (CoreException coreException) {
                try {
                    if (!closeProjectOnExit) return false;
                }
                catch (Throwable throwable) {
                    if (!closeProjectOnExit) throw throwable;
                    try {
                        project.close((IProgressMonitor)new NullProgressMonitor());
                        throw throwable;
                    }
                    catch (CoreException coreException2) {}
                    throw throwable;
                }
                try {
                    project.close((IProgressMonitor)new NullProgressMonitor());
                    return false;
                }
                catch (CoreException coreException3) {}
                return false;
            }
        }
        if (!closeProjectOnExit) return false;
        try {
            project.close((IProgressMonitor)new NullProgressMonitor());
            return false;
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static IProject findProject(String path) {
        if (path == null) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        try {
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                if (new File(path).compareTo(project.getLocation().toFile()) == 0 && MethodLibraryProject.isMethodLibraryProject(project)) {
                    return project;
                }
                if (new File(path).compareTo(project.getLocation().toFile()) == 0) {
                    return project;
                }
                ++i;
            }
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return null;
    }

    public static IProject findProject(MethodLibrary library) {
        return MethodLibraryProject.findProject(MethodLibraryProject.getLibraryPath(library));
    }

    public static IProject openProject(String path, IProgressMonitor monitor) throws CoreException, IOException {
        return MethodLibraryProject.openProject(path, null, monitor);
    }

    public static IProject openProject(String path, String projectName, IProgressMonitor monitor) throws CoreException, IOException {
        String[] natureIds;
        IProjectDescription description;
        Path projectPath = new Path(String.valueOf(path) + File.separator + ".project");
        try {
            description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)projectPath);
        }
        catch (CoreException coreException) {
            description = null;
        }
        IProject project = null;
        if (description == null) {
            project = MethodLibraryProject.createProject(path, projectName, monitor);
        } else {
            if (projectName != null) {
                description.setName(projectName);
            }
            if (!(project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName())).exists()) {
                project = MethodLibraryProject.createProject(path, project.getName(), monitor);
            } else {
                File libLoc = new File(path);
                File prjLoc = project.getLocation().toFile();
                if (libLoc.compareTo(prjLoc) != 0) {
                    project = MethodLibraryProject.createProject(path, monitor);
                } else if (!libLoc.getCanonicalPath().equals(prjLoc.getAbsolutePath())) {
                    project.delete(9, monitor);
                    project = MethodLibraryProject.createProject(path, monitor);
                }
            }
        }
        if (!project.isOpen()) {
            project.open(128, monitor);
        }
        if (description == null) {
            description = project.getDescription();
        }
        if (!Arrays.asList(natureIds = description.getNatureIds()).contains(MethodLibraryProjectNature.NATURE_ID)) {
            description.setNatureIds(MethodLibraryProjectNature.NATURE_IDS);
            project.setDescription(description, 3, monitor);
        }
        return project;
    }

    public static void closeProject(String path, IProgressMonitor monitor) throws CoreException {
        IProject project = MethodLibraryProject.findProject(path);
        if (project != null && !project.getWorkspace().isTreeLocked() && project.isOpen()) {
            project.close(monitor);
        }
    }

    public static void closeProject(MethodLibrary library, IProgressMonitor monitor) throws CoreException {
        MethodLibraryProject.closeProject(MethodLibraryProject.getLibraryPath(library), monitor);
    }

    public static boolean deleteProject(String path, IProgressMonitor monitor) {
        IProject project = MethodLibraryProject.findProject(path);
        if (project != null) {
            try {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                project.delete(9, monitor);
            }
            catch (CoreException e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static boolean deleteProject(MethodLibrary library, IProgressMonitor monitor) {
        return MethodLibraryProject.deleteProject(MethodLibraryProject.getLibraryPath(library), monitor);
    }

    private static String getLibraryPath(MethodLibrary library) {
        return new File(library.eResource().getURI().toFileString()).getParent();
    }
}

