/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.TransientGroupItemProvider;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.MethodElementPropertyHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.PersistenceService;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.MethodUnit;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryUtil {
    public static boolean PUBLISH_MODE = false;
    private static Comparator<EClass> typeComparator = new Comparator<EClass>(){

        @Override
        public int compare(EClass o1, EClass o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static List<EClass> includedElementTypes;
    private static final Collection<EClass> excludedTypes;

    static {
        excludedTypes = Arrays.asList(UmaPackage.eINSTANCE.getBreakdownElement(), UmaPackage.eINSTANCE.getCompositeRole(), UmaPackage.eINSTANCE.getDescribableElement(), UmaPackage.eINSTANCE.getDescriptor(), UmaPackage.eINSTANCE.getFulfillableElement(), UmaPackage.eINSTANCE.getKind(), UmaPackage.eINSTANCE.getProcessComponentDescriptor(), UmaPackage.eINSTANCE.getProcessComponentInterface(), UmaPackage.eINSTANCE.getProcessElement(), UmaPackage.eINSTANCE.getProcessPlanningTemplate(), UmaPackage.eINSTANCE.getRoleDescriptor(), UmaPackage.eINSTANCE.getTaskDescriptor(), UmaPackage.eINSTANCE.getTeamProfile(), UmaPackage.eINSTANCE.getWorkBreakdownElement(), UmaPackage.eINSTANCE.getWorkOrder(), UmaPackage.eINSTANCE.getWorkProductDescriptor());
    }

    public static String checkPluginName(MethodPlugin plugin, String newName) {
        MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        return IValidatorFactory.INSTANCE.createValidator((EObject)lib, UmaPackage.Literals.METHOD_LIBRARY__METHOD_PLUGINS, null, null, (EStructuralFeature)UmaPackage.Literals.NAMED_ELEMENT__NAME).isValid(newName);
    }

    public static boolean selectable(EObject element) {
        return element instanceof MethodLibrary || element instanceof MethodPlugin || element instanceof MethodPackage;
    }

    public static EObject getSelectable(EObject element) {
        if (element instanceof BreakdownElement) {
            EObject pkg = element.eContainer();
            while (pkg != null && !(pkg instanceof ProcessComponent)) {
                pkg = pkg.eContainer();
            }
            return pkg;
        }
        EObject parent = element;
        while (parent != null && !LibraryUtil.selectable(parent)) {
            parent = parent.eContainer();
        }
        return parent;
    }

    public static MethodPlugin getMethodPlugin(EObject element) {
        return UmaUtil.getMethodPlugin((EObject)element);
    }

    public static String getName(Object element) {
        if (element == null) {
            return LibraryResources.unknown_text;
        }
        if (element instanceof MethodElement) {
            return LibraryUtil.getFullName((MethodElement)element);
        }
        return element.toString();
    }

    public static String getFullName(MethodElement element) {
        if (LibraryUtil.selectable((EObject)element)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[").append(element.getName()).append("]");
            MethodElement parent = element;
            while ((parent = (MethodElement)parent.eContainer()) != null) {
                if (parent instanceof MethodLibrary) break;
                buffer.insert(0, "[" + parent.getName() + "].");
            }
            return buffer.toString();
        }
        return element.getName();
    }

    public static String getLocalizeTypeName(MethodElement element) {
        if (element == null) {
            return "";
        }
        if (element instanceof DescribableElement) {
            String nameStr = String.valueOf(TngUtil.getTypeText((EObject)element)) + LibraryResources.colon_with_space;
            nameStr = ((DescribableElement)element).getPresentationName() != null ? String.valueOf(nameStr) + "(" + ((DescribableElement)element).getPresentationName() + ") " + ((DescribableElement)element).getName() : String.valueOf(nameStr) + element.getName();
            return nameStr;
        }
        return LibraryUtil.getTypeName(element);
    }

    public static String getTypeName(MethodElement element) {
        return element == null ? "" : String.valueOf(element.getType().getName()) + ":" + element.getName();
    }

    public static String getTypePath(MethodElement element) {
        return element == null ? "" : String.valueOf(element.getType().getName()) + ":" + TngUtil.getLabelWithPath((Object)element);
    }

    public static List<MethodPlugin> getMethodPlugins(MethodLibrary library) {
        return new ArrayList<MethodPlugin>(library.getMethodPlugins());
    }

    public static List getMethodPluginGuids(MethodLibrary library) {
        ArrayList<String> items = new ArrayList<String>();
        List elements = library.getMethodPlugins();
        if (elements != null) {
            for (MethodPlugin element : elements) {
                items.add(element.getGuid());
            }
        }
        return items;
    }

    public static MethodPlugin getMethodPlugin(MethodLibrary library, String pluginGuid) {
        if (pluginGuid == null) {
            return null;
        }
        List elements = library.getMethodPlugins();
        if (elements != null) {
            for (MethodPlugin element : elements) {
                if (!pluginGuid.equals(element.getGuid())) continue;
                return element;
            }
        }
        return null;
    }

    public static MethodPlugin getMethodPluginByName(MethodLibrary library, String name) {
        if (name == null) {
            return null;
        }
        List elements = library.getMethodPlugins();
        if (elements != null) {
            for (MethodPlugin element : elements) {
                if (!name.equals(element.getName())) continue;
                return element;
            }
        }
        return null;
    }

    public static List getMethodPackages(MethodElement element) {
        ArrayList<EObject> items = new ArrayList<EObject>();
        TreeIterator it = element.eAllContents();
        while (it.hasNext()) {
            EObject e = (EObject)it.next();
            if (!(e instanceof MethodPackage)) continue;
            items.add(e);
        }
        return items;
    }

    public static Object unwrap(Object obj) {
        return TngUtil.unwrap((Object)obj);
    }

    public static Command unwrap(Command cmd) {
        return TngUtil.unwrap((Command)cmd);
    }

    public static void detachFromResource(MethodLibrary importLibraty) {
        ResourceSet resSet = null;
        Resource res = importLibraty.eResource();
        if (res != null) {
            resSet = res.getResourceSet();
        }
        if (resSet != null) {
            TreeIterator it = resSet.getAllContents();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof MultiResourceEObject)) continue;
                ((MultiResourceEObject)obj).eSetResource(null);
            }
        }
        LibraryUtil.clearProxies((EObject)importLibraty);
    }

    public static void clearProxies(EObject element) {
        if (element.eIsProxy()) {
            LibraryUtil.setProxyURI(element, null);
        } else {
            TreeIterator it = element.eAllContents();
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                if (!o.eIsProxy()) continue;
                LibraryUtil.setProxyURI(o, null);
            }
        }
    }

    public static void setProxyURI(EObject obj, URI uri) {
        ((InternalEObject)obj).eSetProxyURI(uri);
    }

    public static Collection<Resource> getLoadedResources(MethodLibrary lib, Collection<Resource> excludes) {
        HashSet<Resource> loadedres = new HashSet<Resource>();
        for (Resource res : lib.eResource().getResourceSet().getResources()) {
            if (!res.isLoaded() || excludes != null && excludes.contains(res)) continue;
            loadedres.add(res);
        }
        return loadedres;
    }

    public static Collection<Resource> loadAll(MethodLibrary lib) {
        Collection<Resource> loadedres = LibraryUtil.getLoadedResources(lib, null);
        LibraryUtil.loadAllContained((MethodElement)lib);
        return LibraryUtil.getLoadedResources(lib, loadedres);
    }

    public static void loadAllContained(MethodElement me) {
        TreeIterator iter = me.eAllContents();
        while (iter.hasNext()) {
            try {
                EObject element = (EObject)iter.next();
                Iterator iterator = element.eCrossReferences().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    public static void loadAllPlugins(MethodConfiguration config) {
        List pluigns = config.getMethodPluginSelection();
        for (MethodPlugin plugin : pluigns) {
            LibraryUtil.loadAllContained((MethodElement)plugin);
        }
    }

    public static void loadAllProcesses(MethodLibrary lib) {
        Iterator iter = lib.getMethodPlugins().iterator();
        while (iter.hasNext()) {
            try {
                MethodPlugin plugin = (MethodPlugin)iter.next();
                TngUtil.getAllProcesses((MethodPlugin)plugin);
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().log(e);
            }
        }
    }

    public static void saveAll(MethodLibrary lib) throws Exception {
        LibraryUtil.saveLibrary(lib, true, false);
    }

    public static void saveLibrary(MethodLibrary lib, boolean saveAll, boolean refresh) throws Exception {
        ILibraryResourceSet libResourceSet = (ILibraryResourceSet)lib.eResource().getResourceSet();
        if (libResourceSet instanceof MultiFileResourceSetImpl) {
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)libResourceSet;
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            HashMap<String, String> saveOptions = manager != null ? manager.getSaveOptions() : new HashMap<String, String>();
            Object old = saveOptions.get("REFRESH_NEW_RESOURCE");
            Object oldCheckModify = saveOptions.get("CHECK_MODIFY");
            try {
                saveOptions.put("REFRESH_NEW_RESOURCE", refresh ? "true" : "false");
                saveOptions.put("CHECK_MODIFY", "false");
                resourceSet.save(saveOptions, saveAll);
            }
            finally {
                saveOptions.put("REFRESH_NEW_RESOURCE", (String)old);
                saveOptions.put("CHECK_MODIFY", (String)oldCheckModify);
            }
        } else {
            libResourceSet.save(Collections.EMPTY_MAP);
        }
    }

    public static MethodLibrary loadLibrary(String libraryPath) throws Exception {
        ILibraryResourceSet resourceSet = PersistenceService.INSTANCE.createResourceSet("xmi");
        resourceSet.loadMethodLibraries(URI.createFileURI((String)libraryPath), Collections.EMPTY_MAP);
        return resourceSet.getFirstMethodLibrary();
    }

    public static File getLibraryRootPath(MethodLibrary lib) {
        Resource res = lib.eResource();
        if (res == null) {
            return null;
        }
        URI uri = res.getURI();
        String path = uri.toFileString();
        File f = new File(path);
        return f.getParentFile();
    }

    public static List getAllPackages(MethodPlugin plugin) {
        ArrayList allPkgs = new ArrayList();
        List pkgs = plugin.getMethodPackages();
        allPkgs.addAll(pkgs);
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            LibraryUtil.getAllChildPackages((MethodPackage)it.next(), allPkgs);
        }
        return allPkgs;
    }

    public static void getAllChildPackages(MethodPackage pkg, List result) {
        List pkgs = pkg.getChildPackages();
        result.addAll(pkgs);
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            LibraryUtil.getAllChildPackages((MethodPackage)it.next(), result);
        }
    }

    public static List<MethodConfiguration> getAssociatedConfigurations(MethodPlugin plugin) {
        ArrayList<MethodConfiguration> allConfigs = new ArrayList<MethodConfiguration>();
        List procs = TngUtil.getAllProcesses((MethodPlugin)plugin);
        for (Process p : procs) {
            MethodConfiguration c = p.getDefaultContext();
            if (c != null && !allConfigs.contains(c)) {
                allConfigs.add(c);
            }
            LibraryUtil.addUniqueItems(p.getValidContext(), allConfigs);
        }
        return allConfigs;
    }

    private static void addUniqueItems(List from, List to) {
        if (from == null || to == null || from.size() == 0) {
            return;
        }
        for (Object o : from) {
            if (to.contains(o)) continue;
            to.add(o);
        }
    }

    public static void validateMethodConfiguration(IActionManager actionMgr, MethodConfiguration config) {
        TngUtil.validateMethodConfiguration((IActionManager)actionMgr, (MethodConfiguration)config);
    }

    public static void validateMethodConfiguration(MethodConfiguration config) {
        LibraryUtil.validateMethodConfiguration(null, config);
    }

    public static SupportingMaterial getCopyright(MethodElement element) {
        MethodPlugin p;
        SupportingMaterial sm = null;
        if (element instanceof MethodUnit) {
            sm = ((MethodUnit)element).getCopyrightStatement();
        } else if (element instanceof DescribableElement) {
            sm = ((DescribableElement)element).getPresentation().getCopyrightStatement();
        }
        if (sm == null && (p = LibraryUtil.getMethodPlugin((EObject)element)) != null) {
            sm = p.getCopyrightStatement();
        }
        return sm;
    }

    public static Collection getContainedElements(Object container, Collection elements) {
        if (container instanceof TransientGroupItemProvider) {
            container = ((TransientGroupItemProvider)container).getTarget();
        }
        ArrayList contained = new ArrayList();
        for (Object element : elements) {
            if (!(element instanceof EObject) || !UmaUtil.isContainedBy((EObject)((EObject)element), (Object)container)) continue;
            contained.add(element);
        }
        return contained;
    }

    public static boolean isIdentical(MethodElement oldObj, MethodElement newObj) {
        if (oldObj == null && newObj == null) {
            return true;
        }
        if (oldObj == null || newObj == null) {
            return false;
        }
        List features = LibraryUtil.getStructuralFeatures(oldObj);
        if (features != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                Object oldValue = oldObj.eGet(feature);
                Object newValue = newObj.eGet(feature);
                if (oldValue != null || newValue != null) {
                    if (oldValue == null || newValue == null) {
                        return false;
                    }
                    if (oldValue instanceof MethodElement) {
                        MethodElement olde = (MethodElement)oldValue;
                        if (olde.eContainer() == oldObj ? !LibraryUtil.isIdentical(olde, (MethodElement)newValue) : oldValue != newValue) {
                            return false;
                        }
                    } else if (oldValue instanceof List) {
                        List oldl = (List)oldValue;
                        List newl = (List)newValue;
                        if (oldl.size() != newl.size()) {
                            return false;
                        }
                        int x = 0;
                        while (x < oldl.size()) {
                            MethodElement olde;
                            Object o = oldl.get(x);
                            Object n = newl.get(x);
                            if (o instanceof MethodElement ? ((olde = (MethodElement)o).eContainer() == oldObj ? !LibraryUtil.isIdentical(olde, (MethodElement)n) : oldValue != newValue) : !o.equals(n)) {
                                return false;
                            }
                            ++x;
                        }
                    } else if (!oldValue.equals(newValue)) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean isProcess(EObject e) {
        return e instanceof Process && e.eContainer() instanceof ProcessComponent;
    }

    public static List getValidViews(MethodConfiguration config) {
        ArrayList<ContentCategory> views = new ArrayList<ContentCategory>();
        for (ContentCategory view : config.getProcessViews()) {
            if (ConfigurationHelper.isContributor((VariabilityElement)view) || (view = (ContentCategory)ConfigurationHelper.getCalculatedElement((MethodElement)view, config)) == null || views.contains(view)) continue;
            views.add(view);
        }
        return views;
    }

    public static List getStructuralFeatures(MethodElement element) {
        List properties = element.getInstanceProperties();
        if (properties != null) {
            ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
            int i = 0;
            while (i < properties.size()) {
                EProperty property = (EProperty)properties.get(i);
                if (property != null) {
                    EStructuralFeature feature = property.getEStructuralFeature();
                    features.add(feature);
                }
                ++i;
            }
            return features;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<EClass> getIncludedElementTypes() {
        if (includedElementTypes != null) return includedElementTypes;
        Class<LibraryUtil> clazz = LibraryUtil.class;
        synchronized (LibraryUtil.class) {
            if (includedElementTypes != null) return includedElementTypes;
            includedElementTypes = new ArrayList<EClass>();
            for (EClassifier cls : UmaPackage.eINSTANCE.getEClassifiers()) {
                if (!(cls instanceof EClass) || !UmaPackage.eINSTANCE.getDescribableElement().isSuperTypeOf((EClass)cls)) continue;
                includedElementTypes.add((EClass)cls);
            }
            includedElementTypes.removeAll(excludedTypes);
            Collections.sort(includedElementTypes, typeComparator);
            includedElementTypes = Collections.unmodifiableList(includedElementTypes);
            // ** MonitorExit[var0] (shouldn't be in output)
            return includedElementTypes;
        }
    }

    public static List<DescribableElement> getIncludedElements(CustomCategory category, MethodConfiguration config) {
        EClassifier cls;
        ArrayList<DescribableElement> includedElements = new ArrayList<DescribableElement>();
        if (config == null) {
            return includedElements;
        }
        MethodElementProperty prop = MethodElementPropertyHelper.getProperty((MethodElement)category, (String)"include");
        EClassifier eClassifier = cls = prop == null ? null : UmaPackage.eINSTANCE.getEClassifier(prop.getValue());
        if (cls instanceof EClass) {
            EClass eClass = (EClass)cls;
            if (UmaPackage.eINSTANCE.getDescribableElement().isSuperTypeOf(eClass)) {
                MethodLibrary lib = (MethodLibrary)config.eContainer();
                TreeIterator iter = lib.eAllContents();
                while (iter.hasNext()) {
                    EObject eObject = (EObject)iter.next();
                    if (!eClass.isInstance((Object)eObject)) continue;
                    includedElements.add((DescribableElement)eObject);
                }
            }
        }
        return includedElements;
    }
}

