/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.LibraryResourceException;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.IURIProvider;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.resourcemanager.ResourcemanagerFactory;
import org.eclipse.epf.uma.BreakdownElementDescription;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.MethodUnit;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiFileSaveUtil {
    public static final String DEFAULT_MODEL_FILENAME = "model.xmi";
    public static final String DEFAULT_CONTENT_FILENAME = "content.xmi";
    public static final String DEFAULT_LIBRARY_MODEL_FILENAME = "library.xmi";
    public static final String DEFAULT_PLUGIN_EXPORT_FILENAME = "export.xmi";
    public static final String DEFAULT_PLUGIN_MODEL_FILENAME = "plugin.xmi";
    public static final String DEFAULT_FILE_EXTENSION = ".xmi";
    public static final String LIBRARY_FILE_EXTENSION = "uma";
    public static final String CAPABILITY_PATTERN_PATH = "capabilitypatterns";
    public static final String DELIVERY_PROCESS_PATH = "deliveryprocesses";
    public static final String PROCESS_CONTRIBUTION_PATH = "processcontributions";
    public static final String METHOD_CONFIGURATION_FOLDER_NAME = "configurations";
    public static final boolean DEBUG = PersistencePlugin.getDefault().isDebugging();
    static final boolean PROFILE = false;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyMMddHHmmss.S");

    public static boolean isValidFileName(String name) {
        if (name == null) {
            return false;
        }
        return name.indexOf(47) == -1 && name.indexOf(92) == -1 && name.indexOf(58) == -1 && name.indexOf(42) == -1 && name.indexOf(63) == -1 && name.indexOf(34) == -1 && name.indexOf(60) == -1 && name.indexOf(62) == -1 && name.indexOf(124) == -1;
    }

    public static String getPath(MethodElement e) {
        StringBuffer strBuff = new StringBuffer(String.valueOf(e.getName()));
        e = (MethodElement)e.eContainer();
        while (e != null) {
            strBuff.insert(0, String.valueOf(String.valueOf(e.getName())) + " > ");
            e = (MethodElement)e.eContainer();
        }
        return strBuff.toString();
    }

    public static String createDirName(MethodElement obj) {
        String name = obj.getName();
        if (MultiFileSaveUtil.isValidFileName(name)) {
            return name;
        }
        throw new MultiFileIOException(NLS.bind((String)PersistenceResources.invalidNameError_msg, (Object)name), obj);
    }

    public static EObject resolve(EObject proxy) {
        if (!(proxy instanceof InternalEObject)) {
            return proxy;
        }
        InternalEObject obj = (InternalEObject)proxy;
        if (obj.eProxyURI() == null) {
            return proxy;
        }
        XMIResourceImpl res = new XMIResourceImpl(obj.eProxyURI());
        try {
            res.load(null);
            return PersistenceUtil.getMethodElement((Resource)res);
        }
        catch (IOException e) {
            e.printStackTrace();
            return proxy;
        }
    }

    static Resource save(EObject o, URI uri, Map options) {
        String str;
        ResourceSet resourceSet = o.eResource().getResourceSet();
        MultiFileXMIResourceImpl resource = MultiFileSaveUtil.save(resourceSet, o, uri, options);
        if (options == null) {
            options = ((MultiFileResourceSetImpl)resourceSet).getDefaultSaveOptions();
        }
        if ((str = (String)options.get("REFRESH_NEW_RESOURCE")) != null && Boolean.valueOf(str).booleanValue()) {
            RefreshJob.getInstance().resourceSaved(resource);
            FileManager.getInstance().refresh(resource);
        }
        return resource;
    }

    public static boolean canSaveTogether(Map options, Object obj) {
        Set saveTogetherClasses = (Set)options.get("SAVE_TOGETHER_CLASS_SET");
        if (saveTogetherClasses == null) {
            return false;
        }
        for (EClass eCls : saveTogetherClasses) {
            if (!eCls.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    private static void addTo(Resource resource, MultiResourceEObject o) {
        BasicEList contents = (BasicEList)resource.getContents();
        if (contents.isEmpty()) {
            contents.clear();
            contents.setData(1, new Object[]{o});
        } else {
            Object[] data = contents.toArray();
            Object[] newData = new Object[data.length + 1];
            System.arraycopy(data, 0, newData, 0, data.length);
            newData[data.length] = o;
            contents.setData(newData.length, newData);
        }
        o.eSetResource((Resource.Internal)resource);
    }

    private static MultiFileXMIResourceImpl save(ResourceSet resourceSet, EObject o, URI uri, Map options) {
        return MultiFileSaveUtil.save(resourceSet, o, uri, options, true);
    }

    /*
     * Unable to fully structure code
     */
    static MultiFileXMIResourceImpl save(ResourceSet resourceSet, EObject o, URI uri, Map options, boolean registerWithResourceManager) {
        block24: {
            mrEObj = (MultiResourceEObject)o;
            currentResource = (MultiFileXMIResourceImpl)o.eResource();
            if (currentResource != null) {
                currentResource.detached(o);
            }
            newResourceDescriptors = null;
            modifiedResources = (Set)options.get("MODIFIED_RESOURCE_SET");
            res = null;
            if (MultiFileSaveUtil.canSaveTogether(options, o)) {
                mfResourceSet = (MultiFileResourceSetImpl)resourceSet;
                tempURI = (URI)mfResourceSet.getURIToTempURIMap().get(uri);
                if (tempURI != null) {
                    uri = tempURI;
                }
                if ((res = (MultiFileXMIResourceImpl)mfResourceSet.getResource(uri)) != null) {
                    if (!res.getContents().contains((Object)o)) {
                        if (res.getFinalURI() == res.getURI() && MultiFileXMISaveImpl.checkModifyRequired(options)) {
                            MultiFileSaveUtil.checkModify(res);
                        }
                        MultiFileSaveUtil.addTo(res, mrEObj);
                        desc = null;
                        try {
                            if (registerWithResourceManager && (desc = MultiFileSaveUtil.registerWithResourceManager(resMgr = MultiFileSaveUtil.getResourceManagerFor(o, modifiedResources), o, res.getFinalURI())) != null && modifiedResources != null) {
                                modifiedResources.add(resMgr.eResource());
                            }
                            res.setModified(true);
                            mfResourceSet.save(res, options, false);
                            res.attachedAll(o);
                        }
                        catch (Exception e) {
                            res.getContents().remove((Object)mrEObj);
                            mrEObj.eSetResource(null);
                            if (desc != null) {
                                EcoreUtil.remove((EObject)desc);
                            }
                            if (currentResource != null) {
                                currentResource.attached(o);
                            }
                            throw new MultiFileIOException(e.getMessage());
                        }
                    }
                    return res;
                }
            }
            res = (MultiFileXMIResourceImpl)resourceSet.createResource(uri);
            MultiFileSaveUtil.addTo(res, mrEObj);
            if (mrEObj instanceof MethodPlugin) {
                MultiFileSaveUtil.addResourceManager(res);
            }
            objToContainerMap = null;
            try {
                block25: {
                    try {
                        if (registerWithResourceManager) {
                            newResourceDescriptors = MultiFileSaveUtil.registerWithResourceManager(res, modifiedResources);
                        }
                        objToContainerMap = MultiFileSaveUtil.removeContainers(res);
                        res.save(options);
                        res.attachedAll(o);
                        break block24;
                    }
                    catch (Exception e) {
                        CommonPlugin.INSTANCE.log((Object)e);
                        resourceSet.getResources().remove((Object)res);
                        mrEObj.eSetResource(null);
                        if (newResourceDescriptors == null || newResourceDescriptors.isEmpty()) break block25;
                        iter = newResourceDescriptors.iterator();
                        ** while (iter.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        EcoreUtil.remove((EObject)((EObject)iter.next()));
                        continue;
                    }
                }
                if (currentResource != null) {
                    currentResource.attached(o);
                }
                throw new MultiFileIOException(e.getMessage());
            }
            catch (Throwable var13_17) {
                MultiFileSaveUtil.restoreContainers(res, objToContainerMap);
                throw var13_17;
            }
        }
        MultiFileSaveUtil.restoreContainers(res, objToContainerMap);
        if (registerWithResourceManager) {
            resMgr = MultiFileSaveUtil.addNewResourceManager(res);
            if (resMgr == null) {
                if (o instanceof MethodPlugin) {
                    resMgr = MultiFileSaveUtil.getResourceManagerFor(o, modifiedResources);
                }
            } else if (modifiedResources != null) {
                modifiedResources.add(resMgr.eContainer().eResource());
            }
        }
        res.updateTimeStamps();
        return res;
    }

    private static Map removeContainers(Resource resource) {
        int size = resource.getContents().size();
        HashMap<MultiResourceEObject, InternalEObject> objToContainerMap = new HashMap<MultiResourceEObject, InternalEObject>();
        int i = 0;
        while (i < size) {
            MultiResourceEObject multiResEObj = (MultiResourceEObject)resource.getContents().get(i);
            InternalEObject container = (InternalEObject)multiResEObj.eContainer();
            if (container != null) {
                objToContainerMap.put(multiResEObj, container);
                multiResEObj.eBasicSetContainer(null, multiResEObj.eContainerFeatureID());
            }
            ++i;
        }
        return objToContainerMap;
    }

    static Map getContainers(Resource resource) {
        int size = resource.getContents().size();
        HashMap<MultiResourceEObject, InternalEObject> objToContainerMap = new HashMap<MultiResourceEObject, InternalEObject>();
        int i = 0;
        while (i < size) {
            MultiResourceEObject multiResEObj = (MultiResourceEObject)resource.getContents().get(i);
            InternalEObject container = (InternalEObject)multiResEObj.eContainer();
            if (container != null) {
                objToContainerMap.put(multiResEObj, container);
            }
            ++i;
        }
        return objToContainerMap;
    }

    private static void restoreContainers(Resource resource, Map objToContainerMap) {
        int size = resource.getContents().size();
        int i = 0;
        while (i < size) {
            MultiResourceEObject multiResEObj = (MultiResourceEObject)resource.getContents().get(i);
            InternalEObject container = (InternalEObject)objToContainerMap.get(multiResEObj);
            if (container != null) {
                multiResEObj.eBasicSetContainer(container, multiResEObj.eContainerFeatureID());
            }
            ++i;
        }
    }

    public static void checkModify(Resource resource) {
        MultiFileSaveUtil.checkModify((Collection<Resource>)Collections.singleton(resource));
    }

    static void doCheckModify(Collection<Resource> resources) {
        ArrayList<String> pathList = new ArrayList<String>();
        for (Resource resource : resources) {
            if (resource instanceof MultiFileXMIResourceImpl && ((MultiFileXMIResourceImpl)resource).hasTempURI()) continue;
            pathList.add(FileManager.toFileString(resource.getURI()));
        }
        if (!pathList.isEmpty()) {
            String[] paths = new String[pathList.size()];
            pathList.toArray(paths);
            IStatus status = FileManager.getInstance().checkModify(paths, PersistencePlugin.getDefault().getContext());
            if (!status.isOK()) {
                String msg = UmaUtil.getMessage((IStatus)status);
                if (msg == null) {
                    msg = NLS.bind((String)PersistenceResources.modifyFileError_msg, Arrays.asList(paths));
                }
                throw new MultiFileIOException(msg);
            }
        }
    }

    public static void checkModify(Collection<Resource> resources) {
        Object resourceSet;
        HashMap<ILibraryResourceSet, ArrayList<Resource>> libResourceSetToResourcesMap = new HashMap<ILibraryResourceSet, ArrayList<Resource>>();
        ArrayList<Resource> otherResources = new ArrayList<Resource>();
        for (Resource resource : resources) {
            resourceSet = resource.getResourceSet();
            if (resourceSet instanceof ILibraryResourceSet) {
                ArrayList<Resource> collection = (ArrayList<Resource>)libResourceSetToResourcesMap.get(resourceSet);
                if (collection == null) {
                    collection = new ArrayList<Resource>();
                    libResourceSetToResourcesMap.put((ILibraryResourceSet)resourceSet, collection);
                }
                collection.add(resource);
                continue;
            }
            otherResources.add(resource);
        }
        if (!libResourceSetToResourcesMap.isEmpty()) {
            for (Map.Entry entry : libResourceSetToResourcesMap.entrySet()) {
                resourceSet = (ILibraryResourceSet)entry.getKey();
                Resource[] resourceArray = new Resource[((Collection)entry.getValue()).size()];
                ((Collection)entry.getValue()).toArray(resourceArray);
                try {
                    resourceSet.checkModify(resourceArray, PersistencePlugin.getDefault().getContext());
                }
                catch (LibraryResourceException e) {
                    throw new MultiFileIOException(e.getMessage());
                }
            }
        }
        if (!otherResources.isEmpty()) {
            MultiFileSaveUtil.doCheckModify(otherResources);
        }
    }

    public static void checkOutOfSynch(Collection<Resource> resources, Map saveOptions) {
        Collection<Resource> resourcesToCheckOutOfSynch;
        Collection overwritableResources = (Collection)saveOptions.get("OVERWRITABLE_RESOURCES");
        if (overwritableResources != null && !overwritableResources.isEmpty()) {
            resourcesToCheckOutOfSynch = new ArrayList<Resource>(resources);
            resourcesToCheckOutOfSynch.removeAll(overwritableResources);
        } else {
            resourcesToCheckOutOfSynch = resources;
        }
        if (!resourcesToCheckOutOfSynch.isEmpty()) {
            MultiFileSaveUtil.checkOutOfSynch(resourcesToCheckOutOfSynch);
        }
    }

    private static void checkOutOfSynch(Collection resources) {
        for (MultiFileXMIResourceImpl res : resources) {
            File file;
            if (!res.isLoaded() || res.hasTempURI() || !(file = new File(res.getURI().toFileString())).exists() || res.isSynchronized()) continue;
            String msg = NLS.bind((String)PersistenceResources.resourceOutOfSynch_msg, (Object)res.getURI().toFileString());
            throw new MultiFileIOException(msg);
        }
    }

    public static boolean save(Resource resource, Map options) {
        if (resource.getContents().isEmpty()) {
            return false;
        }
        Set modifiedResources = (Set)options.get("MODIFIED_RESOURCE_SET");
        Map objToContainerMap = MultiFileSaveUtil.removeContainers(resource);
        try {
            try {
                resource.save(options);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new MultiFileIOException(e.getMessage());
            }
        }
        finally {
            MultiFileSaveUtil.restoreContainers(resource, objToContainerMap);
        }
        ResourceManager resMgr = MultiFileSaveUtil.addNewResourceManager(resource);
        if (resMgr != null && modifiedResources != null) {
            modifiedResources.add(resMgr.eContainer().eResource());
        }
        return true;
    }

    private static ResourceManager addNewResourceManager(Resource resource) {
        ResourceManager parentResMgr;
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManager(resource);
        MethodElement e = PersistenceUtil.getMethodElement(resource);
        EObject container = e.eContainer();
        if (resMgr != null && container != null && resMgr.eContainer() == null && !(parentResMgr = MultiFileSaveUtil.getResourceManager(container.eResource())).getSubManagers().contains(resMgr)) {
            parentResMgr.getSubManagers().add(resMgr);
            MultiFileSaveUtil.registerWithResourceManager(parentResMgr, e, MultiFileSaveUtil.getFinalURI(resource));
            return resMgr;
        }
        return null;
    }

    private static String toFileString(EObject eObj) {
        return eObj.eResource().getResourceSet().getURIConverter().normalize(eObj.eResource().getURI()).toFileString();
    }

    static boolean hasOwnFolder(Object e) {
        return e instanceof MethodPlugin || e instanceof ProcessComponent;
    }

    static boolean hasOwnResource(Object obj, Collection saveSeparatelyClassSet) {
        if (obj instanceof MethodUnit) {
            return true;
        }
        if (saveSeparatelyClassSet == null) {
            return false;
        }
        for (EClass eCls : saveSeparatelyClassSet) {
            if (!eCls.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    static URI createFileURI(MethodElement e) {
        if (e.eContainer() == null) {
            return ((MultiFileXMIResourceImpl)e.eResource()).getFinalURI();
        }
        if (e instanceof ProcessComponent) {
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
            if (plugin == null) {
                return null;
            }
            Resource resource = plugin.eResource();
            String pluginDir = null;
            if (resource != null) {
                pluginDir = new File(MultiFileSaveUtil.getFinalURI(resource).toFileString()).getParent();
            } else {
                MethodLibrary lib = (MethodLibrary)plugin.eContainer();
                if (lib != null) {
                    String libDir = new File(((MultiFileXMIResourceImpl)lib.eResource()).getFinalURI().toFileString()).getParent();
                    pluginDir = String.valueOf(libDir) + File.separator + plugin.getName();
                }
            }
            if (pluginDir == null) {
                return null;
            }
            Process proc = ((ProcessComponent)e).getProcess();
            String relativeDir = proc instanceof CapabilityPattern ? CAPABILITY_PATTERN_PATH : (proc instanceof DeliveryProcess ? DELIVERY_PROCESS_PATH : "");
            String path = String.valueOf(pluginDir) + File.separator + relativeDir + File.separator + e.getName() + File.separator + DEFAULT_MODEL_FILENAME;
            return URI.createFileURI((String)path);
        }
        if (e instanceof BreakdownElementDescription) {
            String dir = null;
            dir = new File(((MultiFileXMIResourceImpl)UmaUtil.getProcessComponent((MethodElement)e).eResource()).getFinalURI().toFileString()).getParent();
            return URI.createFileURI((String)(String.valueOf(dir) + File.separator + DEFAULT_CONTENT_FILENAME));
        }
        if (e instanceof ContentDescription) {
            ContentDescription content = (ContentDescription)e;
            String path = MethodLibraryPersister.getCorrectPath(content);
            if (path == null) {
                String dir = String.valueOf(((MultiFileXMIResourceImpl)e.eResource()).getFinalURI().trimSegments(1).toFileString()) + File.separator;
                path = MethodLibraryPersister.getNextAvailableFileName(dir, content);
            }
            URI uri = URI.createFileURI((String)path);
            return uri;
        }
        if (e instanceof MethodConfiguration) {
            String dir = new StringBuffer(((MultiFileXMIResourceImpl)e.eContainer().eResource()).getFinalURI().trimSegments(1).toFileString()).append(File.separator).append(METHOD_CONFIGURATION_FOLDER_NAME).append(File.separator).toString();
            String path = MethodLibraryPersister.getNextAvailableFileName(dir, StrUtil.makeValidFileName((String)e.getName()), (MultiResourceEObject)e);
            return URI.createFileURI((String)path);
        }
        StringBuffer path = new StringBuffer();
        MethodElement lastContainer = null;
        MethodElement obj = (MethodElement)e.eContainer();
        while (obj != null) {
            lastContainer = obj;
            if (obj instanceof MethodLibrary) {
                path.insert(0, new File(((MultiFileXMIResourceImpl)obj.eResource()).getFinalURI().toFileString()).getParentFile().getAbsolutePath());
                break;
            }
            path.insert(0, obj.getName()).insert(0, File.separatorChar);
            obj = (MethodElement)obj.eContainer();
        }
        if (lastContainer == null) {
            return e.eResource() != null ? ((MultiFileXMIResourceImpl)e.eResource()).getFinalURI() : null;
        }
        if (!(lastContainer instanceof MethodLibrary)) {
            path.insert(0, new File(MultiFileSaveUtil.toFileString((EObject)lastContainer)).getParentFile().getParentFile().getAbsolutePath());
        }
        String modelFileName = e instanceof MethodPlugin ? DEFAULT_PLUGIN_MODEL_FILENAME : DEFAULT_MODEL_FILENAME;
        URI uri = URI.createFileURI((String)(String.valueOf(path.toString()) + File.separator + MultiFileSaveUtil.createDirName(e) + File.separator + modelFileName));
        return uri;
    }

    public static void delete(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                MultiFileSaveUtil.delete(files[i]);
                ++i;
            }
        }
        file.delete();
    }

    static void setURIMapping(EObject e, URI uri, Set modifiedResources) {
        MultiFileURIConverter uriConverter = (MultiFileURIConverter)e.eResource().getResourceSet().getURIConverter();
        uriConverter.setURIMapping(e, uri, modifiedResources);
    }

    static void updateURIMappings(MultiFileXMIResourceImpl resource, Set modifiedResources) {
        MultiFileSaveUtil.updateURIMappings(resource, modifiedResources, true);
    }

    static boolean hasLoadedResource(ResourceSet resourceSet, URI uri) {
        for (Resource resource : resourceSet.getResources()) {
            if (!resource.isLoaded() || !resource.getURI().equals((Object)uri)) continue;
            return true;
        }
        return false;
    }

    static void updateURIMappings(MultiFileXMIResourceImpl resource, Set modifiedResources, boolean afterMove) {
        MultiFileSaveUtil.updateURIMappings(resource, resource.getFinalURI(), modifiedResources, afterMove);
    }

    static void updateURIMappings(MultiFileXMIResourceImpl resource, URI uri, Set modifiedResources, boolean afterMove) {
        ResourceDescriptor desc;
        HashMap<URI, ResourceDescriptor> oldURIToResourceDescriptorMap = null;
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManager(resource);
        if (resMgr != null) {
            oldURIToResourceDescriptorMap = new HashMap<URI, ResourceDescriptor>();
            TreeIterator iter = resMgr.eAllContents();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof ResourceDescriptor)) continue;
                desc = (ResourceDescriptor)obj;
                oldURIToResourceDescriptorMap.put(desc.getResolvedURI(), desc);
                if (!afterMove) continue;
                desc.clearResolvedURI();
            }
        }
        if (!resource.getContents().isEmpty()) {
            MethodElement element = PersistenceUtil.getMethodElement(resource);
            MultiFileURIConverter uriConverter = (MultiFileURIConverter)resource.getResourceSet().getURIConverter();
            uriConverter.setURIMapping((EObject)element, uri, modifiedResources, afterMove);
        }
        if (oldURIToResourceDescriptorMap != null) {
            for (Resource res : resource.getResourceSet().getResources()) {
                desc = (ResourceDescriptor)oldURIToResourceDescriptorMap.get(res.getURI());
                if (desc == null) continue;
                if (afterMove) {
                    res.setURI(desc.getResolvedURI());
                    continue;
                }
                if (!res.isLoaded()) continue;
                desc.clearResolvedURI();
                res.setURI(desc.getResolvedURI());
            }
        }
    }

    static ResourceManager getResourceManagerFor(EObject eObj, Set modifiedResources) {
        Resource resource = eObj.eContainer() != null ? eObj.eContainer().eResource() : eObj.eResource();
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManager(resource);
        if (resMgr == null) {
            ResourceManager parentResMgr;
            InternalEObject container;
            resMgr = ResourcemanagerFactory.eINSTANCE.createResourceManager();
            resource.getContents().add(0, (Object)resMgr);
            if (modifiedResources != null) {
                modifiedResources.add(resource);
            }
            if ((container = MultiFileSaveUtil.getContainerWithDirectResource((InternalEObject)eObj)) != null && container.eResource() != resource && (parentResMgr = MultiFileSaveUtil.getResourceManagerFor((EObject)container, modifiedResources)) != null) {
                parentResMgr.getSubManagers().add(resMgr);
                if (modifiedResources != null) {
                    modifiedResources.add(parentResMgr.eResource());
                }
            }
        }
        return resMgr;
    }

    static List registerWithResourceManager(MultiFileXMIResourceImpl resource, Set modifiedResources) {
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManagerFor((EObject)PersistenceUtil.getMethodElement(resource), modifiedResources);
        ArrayList<ResourceDescriptor> resourceDescriptors = new ArrayList<ResourceDescriptor>();
        for (Object element : resource.getContents()) {
            ResourceDescriptor resDesc;
            if (!(element instanceof MethodElement) || (resDesc = MultiFileSaveUtil.registerWithResourceManager(resMgr, element, resource.getFinalURI())) == null) continue;
            resourceDescriptors.add(resDesc);
        }
        if (!resourceDescriptors.isEmpty() && modifiedResources != null) {
            modifiedResources.add(resMgr.eResource());
        }
        return resourceDescriptors;
    }

    public static ResourceDescriptor registerWithResourceManager(ResourceManager resMgr, Object element, URI uri) {
        String guid = MultiFileSaveUtil.getGuid(element);
        if (resMgr.getResourceDescriptor(guid) == null) {
            return MultiFileSaveUtil.createResourceDescriptor(resMgr, guid, uri);
        }
        return null;
    }

    private static ResourceDescriptor createResourceDescriptor(ResourceManager resMgr, String id, URI resolvedURI) {
        ResourceDescriptor resDesc = ResourcemanagerFactory.eINSTANCE.createResourceDescriptor();
        resDesc.setId(id);
        resMgr.getResourceDescriptors().add(resDesc);
        resDesc.setResolvedURI(resolvedURI);
        return resDesc;
    }

    public static void setGuid(MethodElement e) {
        if (e.getGuid() == null || e.getGuid().trim().length() == 0) {
            e.setGuid(EcoreUtil.generateUUID());
        }
    }

    public static void save(MethodElement e, Map options) throws LibraryResourceException {
        boolean createResource;
        MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)e.eResource();
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
        if (options == null) {
            options = resourceSet.getDefaultSaveOptions();
        }
        EObject container = e.eContainer();
        HashSet modifiedResources = new HashSet();
        options.put("MODIFIED_RESOURCE_SET", modifiedResources);
        URI uri = MultiFileSaveUtil.createURI(e, (ResourceSet)resourceSet);
        boolean bl = createResource = resource == null || container != null && resource == container.eResource();
        if (createResource) {
            MultiFileSaveUtil.save((EObject)e, uri, options);
        } else {
            URI oldUri = resource.getURI();
            if (!oldUri.equals((Object)uri) && FileManager.getInstance().move(oldUri.toFileString(), uri.toFileString())) {
                resource.setURI(uri);
                MultiFileSaveUtil.updateURIMappings(resource, modifiedResources);
            }
            if (resource.isModified()) {
                MultiFileSaveUtil.save(resource, options);
            }
        }
        resourceSet.saveModifiedResources(options);
    }

    public static URI createURI(MethodElement e, ResourceSet resourceSet) {
        IURIProvider uriProvider;
        URI uri = null;
        if (resourceSet instanceof MultiFileResourceSetImpl && (uriProvider = ((MultiFileResourceSetImpl)resourceSet).getURIProvider()) != null) {
            uri = uriProvider.getURI((EObject)e);
        }
        if (uri == null) {
            uri = MultiFileSaveUtil.createFileURI(e);
        }
        return uri;
    }

    public static void save(ResourceSet resourceSet, MethodElement e, Map options) {
        URI uri = MultiFileSaveUtil.createURI(e, resourceSet);
        MultiFileSaveUtil.save(resourceSet, (EObject)e, uri, options);
    }

    static void adjustLocation(Resource resource, Set modifiedResources) {
        MethodElement e = PersistenceUtil.getMethodElement(resource);
        if (e == null) {
            return;
        }
        URI newFile = MultiFileSaveUtil.createURI(e, resource.getResourceSet());
        if (newFile != null && MultiFileSaveUtil.adjustLocation(resource, newFile)) {
            resource.setURI(newFile);
            MultiFileSaveUtil.updateURIMappings((MultiFileXMIResourceImpl)resource, modifiedResources);
        }
    }

    static URI getNewURI(MultiFileXMIResourceImpl resource) {
        MethodElement e = PersistenceUtil.getMethodElement(resource);
        if (e == null) {
            return null;
        }
        URI newFile = MultiFileSaveUtil.createURI(e, resource.getResourceSet());
        if (newFile != null && MultiFileSaveUtil.adjustLocationRequired(resource, newFile)) {
            return newFile;
        }
        return null;
    }

    static boolean prepareAdjustLocation(MultiFileXMIResourceImpl resource, Set modifiedResources) {
        URI newFile = MultiFileSaveUtil.getNewURI(resource);
        if (newFile != null) {
            resource.backUpURI();
            resource.setFinalURI(newFile);
            MultiFileSaveUtil.updateURIMappings(resource, modifiedResources, false);
            return true;
        }
        return false;
    }

    public static String getGuid(Object e) {
        String guid;
        URI uri;
        InternalEObject o;
        if (e instanceof InternalEObject && (o = (InternalEObject)e).eIsProxy() && (uri = o.eProxyURI()) != null && LIBRARY_FILE_EXTENSION.equals(uri.scheme()) && (guid = uri.fragment()) != null) {
            return guid;
        }
        if (e instanceof MethodElement) {
            return ((MethodElement)e).getGuid();
        }
        if (e instanceof ResourceManager) {
            return ((ResourceManager)e).getGuid();
        }
        return null;
    }

    static boolean adjustLocationRequired(MultiFileXMIResourceImpl resource, URI newURI) {
        File newFile;
        File oldFile = new File(resource.getFinalURI().toFileString());
        return !oldFile.equals(newFile = new File(newURI.toFileString()));
    }

    static boolean adjustLocation(Resource resource, URI newUri) {
        File newFile;
        File oldFile = new File(resource.getURI().toFileString());
        if (oldFile.equals(newFile = new File(newUri.toFileString()))) {
            return false;
        }
        return MultiFileSaveUtil.move(resource, oldFile, newFile);
    }

    static boolean move(Resource resource, File oldFile, File newFile) {
        boolean ret = true;
        if (oldFile.equals(newFile)) {
            return false;
        }
        MethodElement obj = PersistenceUtil.getMethodElement(resource);
        if (MultiFileSaveUtil.hasOwnFolder(obj)) {
            String oldDir = oldFile.getParentFile().toString();
            if (!oldFile.getParentFile().equals(newFile.getParentFile())) {
                if (FileManager.getInstance().rename(oldFile.getParentFile(), newFile.getParentFile())) {
                    if (DEBUG) {
                        System.out.println("Directory '" + oldDir + "' is successfully moved to '" + newFile.getParentFile() + "'");
                    }
                } else {
                    ret = false;
                    if (DEBUG) {
                        System.out.println("Could not move directory '" + oldDir + "' to '" + newFile.getParentFile() + "'");
                    }
                }
            }
            if (!oldFile.getName().equals(newFile.getName())) {
                oldFile = new File(newFile.getParentFile(), oldFile.getName());
                if (FileManager.getInstance().rename(oldFile, newFile)) {
                    if (DEBUG) {
                        System.out.println("File '" + oldFile + "' is successfully moved to '" + newFile + "'");
                    }
                } else {
                    ret = false;
                    if (DEBUG) {
                        System.out.println("Could not move file '" + oldFile + "' to '" + newFile + "'");
                    }
                }
            }
            return ret;
        }
        if (oldFile.exists()) {
            String oldFileStr = oldFile.toString();
            if (FileManager.getInstance().rename(oldFile, newFile)) {
                if (DEBUG) {
                    System.out.println("File '" + oldFileStr + "' is successfully moved to '" + newFile + "'");
                }
                return true;
            }
            if (DEBUG) {
                System.out.println("Could not move file '" + oldFileStr + "' to '" + newFile + "'");
            }
        }
        return false;
    }

    public static ResourceDescriptor findResourceDescriptor(ResourceManager resMgr, String guid, Collection excludedResManagers, boolean resolveProxy) {
        ResourceDescriptor desc = resMgr.getResourceDescriptor(guid);
        if (desc != null) {
            return desc;
        }
        Iterator<ResourceManager> iter = resolveProxy ? new ArrayList<ResourceManager>(resMgr.getSubManagers()).iterator() : ((InternalEList)resMgr.getSubManagers()).basicIterator();
        while (iter.hasNext()) {
            ResourceManager mgr = iter.next();
            if (mgr == null || mgr.eIsProxy() || excludedResManagers != null && excludedResManagers.contains(mgr) || (desc = MultiFileSaveUtil.findResourceDescriptor(mgr, guid, excludedResManagers, resolveProxy)) == null) continue;
            return desc;
        }
        return null;
    }

    public static int getCountResourceDescriptors(ResourceManager resMgr) {
        int count = resMgr.getResourceDescriptors().size();
        for (ResourceManager mgr : resMgr.getSubManagers()) {
            count += MultiFileSaveUtil.getCountResourceDescriptors(mgr);
        }
        return count;
    }

    public static ResourceDescriptor getResourceDescriptor(Resource resource) {
        ResourceManager containerResMgr = null;
        MethodElement me = null;
        for (Object element : resource.getContents()) {
            InternalEObject container;
            ResourceManager resMgr;
            if (element instanceof MethodLibrary && (resMgr = MultiFileSaveUtil.getResourceManager(resource)) != null) {
                ResourceDescriptor desc = resMgr.getResourceDescriptor(((MethodElement)element).getGuid());
                if (desc == null) {
                    desc = MultiFileSaveUtil.registerWithResourceManager(resMgr, element, ((MultiFileXMIResourceImpl)resource).getFinalURI());
                }
                return desc;
            }
            if (me == null && element instanceof MethodElement) {
                me = (MethodElement)element;
            }
            if (containerResMgr == null && element instanceof InternalEObject && (container = MultiFileSaveUtil.getContainerWithDirectResource((InternalEObject)element)) != null) {
                containerResMgr = MultiFileSaveUtil.getResourceManager(container.eResource());
            }
            if (me != null && containerResMgr != null) break;
        }
        if (me != null) {
            ResourceSet resourceSet;
            if (containerResMgr != null) {
                return containerResMgr.getResourceDescriptor(me.getGuid());
            }
            if (me.eContainer() == null && (resourceSet = resource.getResourceSet()) instanceof MultiFileResourceSetImpl) {
                ResourceManager rootResMgr = ((MultiFileResourceSetImpl)resourceSet).getRootResourceManager();
                AbstractTreeIterator iter = new AbstractTreeIterator(rootResMgr){
                    private static final long serialVersionUID = 1L;

                    protected Iterator getChildren(Object object) {
                        if (object instanceof ResourceManager) {
                            ArrayList<Object> children = new ArrayList<Object>();
                            ResourceManager resMgr = (ResourceManager)object;
                            children.addAll(resMgr.getResourceDescriptors());
                            children.addAll(resMgr.getSubManagers());
                            return children.iterator();
                        }
                        return Collections.EMPTY_LIST.iterator();
                    }
                };
                URI uri = MultiFileSaveUtil.getFinalURI(resource);
                while (iter.hasNext()) {
                    ResourceDescriptor resDesc;
                    Object o = iter.next();
                    if (!(o instanceof ResourceDescriptor) || !uri.equals((Object)(resDesc = (ResourceDescriptor)o).getResolvedURI())) continue;
                    return resDesc;
                }
            }
        }
        return null;
    }

    public static ResourceManager getResourceManager(Resource resource) {
        ResourceManager resMgr = null;
        for (Object element : resource.getContents()) {
            if (!(element instanceof ResourceManager)) continue;
            resMgr = (ResourceManager)element;
            break;
        }
        return resMgr;
    }

    static InternalEObject getContainerWithDirectResource(InternalEObject obj) {
        if (obj.eContainer() == null) {
            return null;
        }
        InternalEObject container = (InternalEObject)obj.eContainer();
        if (container.eDirectResource() != null) {
            return container;
        }
        return MultiFileSaveUtil.getContainerWithDirectResource(container);
    }

    static String getHREF(Resource resource, Object obj) {
        MethodElement owner = PersistenceUtil.getMethodElement(resource);
        return MultiFileURIConverter.createURI(owner.getGuid()).appendFragment(MultiFileSaveUtil.getGuid(obj)).toString();
    }

    public static String getBackupFileSuffix() {
        return "_" + dateFormatter.format(Calendar.getInstance().getTime());
    }

    public static void resolveProxies(Collection GUIDs, EObject parent) {
        Iterator iterator = parent.eClass().getEAllContainments().iterator();
        while (!GUIDs.isEmpty() && iterator.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)iterator.next();
            if (feature.isMany()) {
                InternalEList list = (InternalEList)parent.eGet(feature);
                int index = 0;
                Iterator iter1 = list.basicIterator();
                while (!GUIDs.isEmpty() && iter1.hasNext()) {
                    InternalEObject child = (InternalEObject)iter1.next();
                    if (child.eIsProxy()) {
                        String guid = child.eProxyURI().fragment();
                        if (GUIDs.contains(guid)) {
                            list.get(index);
                            GUIDs.remove(guid);
                        }
                    } else {
                        MultiFileSaveUtil.resolveProxies(GUIDs, (EObject)child);
                    }
                    ++index;
                }
                continue;
            }
            InternalEObject child = (InternalEObject)parent.eGet(feature, false);
            if (child == null) continue;
            if (child.eIsProxy()) {
                String guid = child.eProxyURI().fragment();
                if (!GUIDs.contains(guid)) continue;
                parent.eGet(feature);
                GUIDs.remove(guid);
                continue;
            }
            MultiFileSaveUtil.resolveProxies(GUIDs, (EObject)child);
        }
    }

    public static URI getFinalURI(Resource resource) {
        return resource instanceof MultiFileXMIResourceImpl ? ((MultiFileXMIResourceImpl)resource).getFinalURI() : resource.getURI();
    }

    static boolean adjustLocationRequired(MultiFileXMIResourceImpl resource) {
        URI newURI;
        MethodElement e = PersistenceUtil.getMethodElement(resource);
        return e != null && MultiFileSaveUtil.hasOwnFolder(e) && MultiFileSaveUtil.adjustLocationRequired(resource, newURI = MultiFileSaveUtil.createURI(e, resource.getResourceSet())) && !new File(newURI.toFileString()).exists();
    }

    public static int checkSynchronized(Resource resource) {
        if (resource instanceof MultiFileXMIResourceImpl) {
            return ((MultiFileXMIResourceImpl)resource).checkSynchronized();
        }
        return -1;
    }

    public static boolean same(long currentTimeStamp, long lastTimeStamp) {
        return currentTimeStamp < lastTimeStamp && (currentTimeStamp & 7L) == 0L && lastTimeStamp - currentTimeStamp < 1000L;
    }

    static ResourceManager addResourceManager(Resource resource) {
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManager(resource);
        if (resMgr == null) {
            resMgr = ResourcemanagerFactory.eINSTANCE.createResourceManager();
            resource.getContents().add(0, (Object)resMgr);
            return resMgr;
        }
        return null;
    }

    static void checkFilePathLength(Collection resources) {
        ArrayList<String> pathList = new ArrayList<String>();
        for (Resource resource : resources) {
            if (resource instanceof MultiFileXMIResourceImpl && ((MultiFileXMIResourceImpl)resource).hasTempURI()) continue;
            pathList.add(resource.getURI().toFileString());
        }
        if (!pathList.isEmpty()) {
            String[] paths = new String[pathList.size()];
            pathList.toArray(paths);
            int i = 0;
            while (i < paths.length) {
                String cfr_ignored_0 = paths[i];
                if (paths[i].length() > 255) {
                    String msg = NLS.bind((String)PersistenceResources.filePathNameTooLong_msg, Arrays.asList(paths));
                    throw new MultiFileIOException(msg);
                }
                ++i;
            }
        }
    }

    public static Iterator listConfigFiles(File configDir) {
        return MultiFileSaveUtil.listLibraryFiles(configDir);
    }

    public static Iterator<File> listLibraryFiles(File dir) {
        return new AbstractTreeIterator<File>((Object)dir, false){
            private static final long serialVersionUID = 2758436193000640907L;
            FileFilter filter = new FileFilter(){

                public boolean accept(File pathname) {
                    return !FileManager.getInstance().isTeamPrivate(pathname.getAbsolutePath()) && (pathname.isDirectory() || pathname.getName().endsWith(MultiFileSaveUtil.DEFAULT_FILE_EXTENSION));
                }
            };

            protected Iterator<File> getChildren(Object object) {
                File[] files = ((File)object).listFiles(this.filter);
                if (files != null && files.length > 0) {
                    return Arrays.asList(files).iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
    }
}

