/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class MarkerAnnotation
extends SimpleMarkerAnnotation {
    public static final int PROBLEM_LAYER = 5;
    private static Map fgImageRegistry;
    private Image fImage;
    private String fImageName;
    private int fPresentationLayer = -1;
    static /* synthetic */ Class class$0;

    protected static Image getImage(Display display, ImageDescriptor descriptor) {
        Map map = MarkerAnnotation.getImageRegistry(display);
        Image image = (Image)map.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            map.put(descriptor, image);
        }
        return image;
    }

    protected static Map getImageRegistry(Display display) {
        if (fgImageRegistry == null) {
            fgImageRegistry = new HashMap();
            display.disposeExec(new Runnable(){

                public void run() {
                    if (fgImageRegistry != null) {
                        Map map = fgImageRegistry;
                        fgImageRegistry = null;
                        Iterator e = map.values().iterator();
                        while (e.hasNext()) {
                            Image image = (Image)e.next();
                            if (image.isDisposed()) continue;
                            image.dispose();
                        }
                    }
                }
            });
        }
        return fgImageRegistry;
    }

    public MarkerAnnotation(IMarker marker) {
        super(marker);
    }

    public MarkerAnnotation(String annotationType, IMarker marker) {
        super(annotationType, marker);
        this.initialize();
    }

    protected void setImage(Image image) {
        this.fImage = image;
    }

    protected void initialize() {
        IMarker marker = this.getMarker();
        String name = this.getUnknownImageName(marker);
        if (MarkerUtilities.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            name = "IMG_OBJS_TASK_TSK";
        } else if (MarkerUtilities.isMarkerType(marker, "org.eclipse.core.resources.bookmark")) {
            name = "IMG_OBJS_BKMRK_TSK";
        } else if (MarkerUtilities.isMarkerType(marker, "org.eclipse.core.resources.problemmarker")) {
            switch (MarkerUtilities.getSeverity(marker)) {
                case 0: {
                    name = "IMG_OBJS_INFO_TSK";
                    break;
                }
                case 1: {
                    name = "IMG_OBJS_WARN_TSK";
                    break;
                }
                case 2: {
                    name = "IMG_OBJS_ERROR_TSK";
                }
            }
        }
        this.fImage = null;
        this.fImageName = name;
    }

    public int getLayer() {
        if (this.fPresentationLayer != -1) {
            return this.fPresentationLayer;
        }
        AnnotationPreference preference = EditorsPlugin.getDefault().getAnnotationPreferenceLookup().getAnnotationPreference(this);
        if (preference != null) {
            return preference.getPresentationLayer();
        }
        return 0;
    }

    protected void setLayer(int layer) {
        this.fPresentationLayer = layer;
    }

    public void paint(GC gc, Canvas canvas, Rectangle r) {
        Image image = this.getImage(canvas.getDisplay());
        if (image != null) {
            ImageUtilities.drawImage((Image)image, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
        }
    }

    public void update() {
        super.update();
        this.initialize();
    }

    protected String getUnknownImageName(IMarker marker) {
        return null;
    }

    protected Image getImage(String name) {
        if (name != null) {
            return PlatformUI.getWorkbench().getSharedImages().getImage(name);
        }
        return null;
    }

    protected Image getImage(Display display) {
        if (this.fImage == null) {
            IMarker marker = this.getMarker();
            if (marker.exists()) {
                ImageDescriptor descriptor;
                IWorkbenchAdapter adapter;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (IWorkbenchAdapter)marker.getAdapter((Class)clazz)) != null && (descriptor = adapter.getImageDescriptor((Object)marker)) != null) {
                    this.fImage = MarkerAnnotation.getImage(display, descriptor);
                }
            }
            if (this.fImage == null) {
                this.fImage = this.getImage(this.fImageName);
            }
        }
        return this.fImage;
    }
}

