/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui;

import java.net.URL;
import org.eclipse.epf.publishing.services.AbstractPublishManager;
import org.eclipse.epf.publishing.ui.wizards.AbstractPublishWizard;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class PublisherElement {
    Bundle bundle;
    private String id;
    private String label;
    private String icon;
    private String wizardClass;
    private String managerClass;

    public PublisherElement(Bundle bundle, String id, String label, String icon, String wizardClass, String managerClass) {
        this.bundle = bundle;
        this.id = id;
        this.label = label;
        this.icon = icon;
        this.wizardClass = wizardClass;
        this.managerClass = managerClass;
    }

    public AbstractPublishWizard getPublishWizard() throws Exception {
        Class clazz = this.bundle.loadClass(this.wizardClass);
        return (AbstractPublishWizard)((Object)clazz.newInstance());
    }

    public AbstractPublishManager getPublishManager() throws Exception {
        Class clazz = this.bundle.loadClass(this.managerClass);
        return (AbstractPublishManager)clazz.newInstance();
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.icon == null || this.icon.length() == 0) {
            return null;
        }
        try {
            URL installURL = this.bundle.getEntry("/");
            URL iconURL = new URL(installURL, this.icon);
            return ImageDescriptor.createFromURL((URL)iconURL);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

