/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.common.utils.IMarkerAttributeContributer;
import org.eclipse.epf.common.utils.IObjectFactory;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionHelper {
    private static Map IDToExtensionMap = new HashMap();

    public static Object createExtension(String namespace, String extensionPointName) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(namespace, extensionPointName);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            Object ext = null;
            int i = 0;
            block2: while (i < extensions.length) {
                IExtension extension = extensions[i];
                String pluginId = extension.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)pluginId);
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        String className = configElement.getAttribute("class");
                        if (className != null) {
                            ext = bundle.loadClass(className).newInstance();
                            break block2;
                        }
                    }
                    catch (Exception e) {
                        CommonPlugin.getDefault().getLogger().logError(e);
                    }
                    ++j;
                }
                ++i;
            }
            return ext;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getExtension(String namespace, String extensionPointName) {
        String ID = String.valueOf(namespace) + '.' + extensionPointName;
        Object ext = IDToExtensionMap.get(ID);
        if (ext == null) {
            Map map = IDToExtensionMap;
            synchronized (map) {
                ext = IDToExtensionMap.get(ID);
                if (ext == null && (ext = ExtensionHelper.createExtension(namespace, extensionPointName)) != null) {
                    IDToExtensionMap.put(ID, ext);
                }
            }
        }
        return ext;
    }

    public static IMarkerAttributeContributer getMarkerAttributeContributer() {
        IMarkerAttributeContributer ret = (IMarkerAttributeContributer)ExtensionHelper.getExtension(CommonPlugin.getDefault().getId(), "markerAttributeContributer");
        return ret;
    }

    public static Object create(Class type, Object context) {
        IObjectFactory ret = (IObjectFactory)ExtensionHelper.getExtension(CommonPlugin.getDefault().getId(), "objectFactory");
        if (ret == null) {
            return null;
        }
        return ret.create(type, context);
    }

    public static <T> List<T> getExtensions(String namespace, String extensionPointName, Class<T> type) {
        ArrayList list;
        block8: {
            list = new ArrayList();
            try {
                IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(namespace, extensionPointName);
                if (extensionPoint == null) break block8;
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    String pluginId = extension.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)pluginId);
                    IConfigurationElement[] configElements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        IConfigurationElement configElement = configElements[j];
                        try {
                            Object ext;
                            String className = configElement.getAttribute("class");
                            if (className != null && type.isInstance(ext = bundle.loadClass(className).newInstance())) {
                                list.add(ext);
                            }
                        }
                        catch (Exception e) {
                            CommonPlugin.getDefault().getLogger().logError(e);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                CommonPlugin.getDefault().getLogger().logError(e);
            }
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }
}

