/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma.edit.domain;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.epf.uma.MethodElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceableAdapterFactoryEditingDomain
extends AdapterFactoryEditingDomain {
    private HashMap<Object, Object> copyToOriginalMap = null;
    private Map<Object, Object> originalToClipboardMap = null;
    private Map<EObject, EObject> clipboardToOriginalMap;

    public TraceableAdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack) {
        super(adapterFactory, commandStack);
    }

    public TraceableAdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack, Map resourceToReadOnlyMap) {
        super(adapterFactory, commandStack, resourceToReadOnlyMap);
    }

    public TraceableAdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack, ResourceSet resourceSet) {
        super(adapterFactory, commandStack, resourceSet);
    }

    public Map<?, ?> getCopyToOriginalMap() {
        if (this.copyToOriginalMap == null) {
            this.copyToOriginalMap = new HashMap();
        }
        return this.copyToOriginalMap;
    }

    public Map getOriginalToClipboardMap() {
        if (this.originalToClipboardMap == null) {
            this.originalToClipboardMap = new HashMap<Object, Object>();
        }
        return this.originalToClipboardMap;
    }

    public void addCopyInfo(Collection c, CopyCommand.Helper copyHelper) {
        if (this.isNewCopy(c, copyHelper)) {
            this.addNewCopy(c, copyHelper);
            return;
        }
        this.chainCopy(c, copyHelper);
    }

    private void addNewCopy(Collection c, CopyCommand.Helper copyHelper) {
        if (this.originalToClipboardMap == null) {
            this.originalToClipboardMap = new HashMap<Object, Object>();
        }
        if (this.clipboardToOriginalMap == null) {
            this.clipboardToOriginalMap = new HashMap<EObject, EObject>();
        }
        for (EObject key : copyHelper.keySet()) {
            EObject value = (EObject)copyHelper.get((Object)key);
            this.originalToClipboardMap.put(key, value);
            this.clipboardToOriginalMap.put(value, key);
        }
    }

    private void chainCopy(Collection c, CopyCommand.Helper copyHelper) {
        if (this.originalToClipboardMap != null) {
            if (this.copyToOriginalMap == null) {
                this.copyToOriginalMap = new HashMap();
            }
            for (Object o2CKey : this.originalToClipboardMap.keySet()) {
                Object o2CValue = this.originalToClipboardMap.get(o2CKey);
                Object copyValue = copyHelper.get(o2CValue);
                if (copyValue == null || !(o2CKey instanceof MethodElement)) continue;
                this.copyToOriginalMap.put(copyValue, o2CKey);
            }
        }
    }

    private boolean isNewCopy(Collection c, CopyCommand.Helper copyHelper) {
        if (this.originalToClipboardMap == null) {
            return true;
        }
        for (Object clipKey : copyHelper.keySet()) {
            if (this.originalToClipboardMap.containsValue(clipKey)) continue;
            return true;
        }
        return false;
    }

    public void resetCopyMaps() {
        if (this.originalToClipboardMap != null) {
            this.originalToClipboardMap.clear();
            this.originalToClipboardMap = null;
        }
        if (this.clipboardToOriginalMap != null) {
            this.clipboardToOriginalMap.clear();
            this.clipboardToOriginalMap = null;
        }
        if (this.copyToOriginalMap != null) {
            this.copyToOriginalMap.clear();
            this.copyToOriginalMap = null;
        }
    }

    public Map<EObject, EObject> getClipboardToOriginalMap() {
        return this.clipboardToOriginalMap;
    }
}

