/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;

public class SetOppositeFeatureCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private MethodElement element;
    private OppositeFeature oppositeFeature;
    private EObject value;
    private EObject oldValue;
    private Collection modifiedResources;

    public SetOppositeFeatureCommand(MethodElement e, OppositeFeature oppositeFeature, EObject value) {
        this.element = e;
        this.oppositeFeature = oppositeFeature;
        this.value = value;
    }

    public Collection getModifiedResources() {
        if (this.modifiedResources == null) {
            return Collections.EMPTY_LIST;
        }
        return this.modifiedResources;
    }

    protected boolean prepare() {
        if (this.value instanceof MethodElement) {
            return UserInteractionHelper.checkModifyOpposite((MethodElement)this.value, this.oppositeFeature.getTargetFeature(), this.element);
        }
        return true;
    }

    public void execute() {
        this.oldValue = (EObject)((MultiResourceEObject)this.element).getOppositeFeatureValue(this.oppositeFeature);
        this.modifiedResources = new HashSet();
        this.redo();
    }

    public void redo() {
        if (this.oldValue != null && this.value == null) {
            if (this.oppositeFeature.getTargetFeature().isMany()) {
                ((Collection)this.oldValue.eGet(this.oppositeFeature.getTargetFeature())).remove(this.element);
            } else {
                this.oldValue.eSet(this.oppositeFeature.getTargetFeature(), null);
            }
            if (this.oldValue.eResource() != null) {
                this.modifiedResources.add(this.oldValue.eResource());
            }
        }
        if (this.value != null) {
            if (this.oppositeFeature.getTargetFeature().isMany()) {
                ((Collection)this.value.eGet(this.oppositeFeature.getTargetFeature())).add(this.element);
            } else {
                this.value.eSet(this.oppositeFeature.getTargetFeature(), (Object)this.element);
            }
            if (this.value.eResource() != null) {
                this.modifiedResources.add(this.value.eResource());
            }
        }
    }

    public void undo() {
        if (this.value != null) {
            if (this.oppositeFeature.getTargetFeature().isMany()) {
                ((Collection)this.value.eGet(this.oppositeFeature.getTargetFeature())).remove(this.element);
            } else {
                this.value.eSet(this.oppositeFeature.getTargetFeature(), null);
            }
        }
        if (this.oldValue != null) {
            if (this.oppositeFeature.getTargetFeature().isMany()) {
                ((Collection)this.oldValue.eGet(this.oppositeFeature.getTargetFeature())).add(this.element);
            } else {
                this.oldValue.eSet(this.oppositeFeature.getTargetFeature(), (Object)this.element);
            }
        }
    }
}

