/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.process.command.ProcessElementAddCommand;
import org.eclipse.epf.library.edit.util.Messenger;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;

public class ActivityAddCommand
extends ProcessElementAddCommand {
    private List procPackages;

    public ActivityAddCommand(Command command) {
        super(command);
    }

    private Map getCopyToOriginalMap() {
        EditingDomain ed = this.addCommand.getDomain();
        if (ed instanceof TraceableAdapterFactoryEditingDomain) {
            return ((TraceableAdapterFactoryEditingDomain)ed).getCopyToOriginalMap();
        }
        return null;
    }

    private void copyProcessPackages() {
        if (this.procPackages == null && this.hasCopyToOriginalMap()) {
            boolean showWarning = false;
            this.procPackages = new ArrayList();
            ArrayList<Activity> copiedActivities = new ArrayList<Activity>();
            if (this.addCommand.getCollection() != null && this.addCommand.getCollection().size() > 0 && this.getOriginal(this.addCommand.getCollection().toArray()[0]) != null) {
                for (Object element : this.addCommand.getCollection()) {
                    if (!(element instanceof Activity)) continue;
                    Activity orig = (Activity)this.getOriginal(element);
                    if (orig != null) {
                        if (orig.eContainer() == null) continue;
                        this.procPackages.add(orig.eContainer());
                        copiedActivities.add((Activity)element);
                        continue;
                    }
                    showWarning = true;
                }
            }
            if (showWarning) {
                Messenger.INSTANCE.showWarning(this.getLabel(), LibraryEditResources.ActivityAddCommand_originalNotFoundWarning_msg);
            }
            if (!this.procPackages.isEmpty()) {
                Command command = CopyCommand.create((EditingDomain)this.addCommand.getDomain(), (Collection)this.procPackages);
                try {
                    command.execute();
                    ArrayList collection = new ArrayList(this.addCommand.getCollection());
                    Collection elements = this.addCommand.getCollection();
                    elements.clear();
                    Collection col = command.getResult();
                    ArrayList procPkgCopies = new ArrayList(col);
                    for (Object element : collection) {
                        int index = copiedActivities.indexOf(element);
                        if (index != -1) {
                            ProcessPackage copy = (ProcessPackage)procPkgCopies.get(index);
                            element = this.getActivityCopy(copy);
                        }
                        if (element == null) continue;
                        elements.add(element);
                    }
                }
                finally {
                    if (command != null) {
                        command.dispose();
                    }
                }
            }
        }
    }

    private Activity getActivityCopy(ProcessPackage copy) {
        if (copy instanceof ProcessComponent) {
            Process actCopy = ((ProcessComponent)copy).getProcess();
            ProcessPackage pkgCopy = UmaFactory.eINSTANCE.createProcessPackage();
            pkgCopy.setName(actCopy.getName());
            pkgCopy.getProcessElements().add(actCopy);
            pkgCopy.getProcessElements().addAll(copy.getProcessElements());
            pkgCopy.getDiagrams().addAll(copy.getDiagrams());
            pkgCopy.getChildPackages().addAll(copy.getChildPackages());
            return actCopy;
        }
        for (Object element : copy.getProcessElements()) {
            if (!(element instanceof Activity)) continue;
            return (Activity)element;
        }
        return null;
    }

    public void execute() {
        this.prepareAddList();
        this.copyProcessPackages();
        super.execute();
    }

    private static boolean isChildOf(Object parent, Object e) {
        if (parent instanceof Activity) {
            Activity act = (Activity)parent;
            for (Object child : act.getBreakdownElements()) {
                if (e == child) {
                    return true;
                }
                if (!ActivityAddCommand.isChildOf(child, e)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isChildOf(Collection elements, Object e) {
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (!ActivityAddCommand.isChildOf(iter.next(), e)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCopyToOriginalMap() {
        EditingDomain ed = this.addCommand.getDomain();
        if (ed instanceof TraceableAdapterFactoryEditingDomain) {
            TraceableAdapterFactoryEditingDomain editingDomain = (TraceableAdapterFactoryEditingDomain)ed;
            return editingDomain.getCopyToOriginalMap() != null && !editingDomain.getCopyToOriginalMap().isEmpty() || editingDomain.getClipboardToOriginalMap() != null && !editingDomain.getClipboardToOriginalMap().isEmpty();
        }
        return false;
    }

    private Object getOriginal(Object copy) {
        TraceableAdapterFactoryEditingDomain ed = (TraceableAdapterFactoryEditingDomain)this.addCommand.getDomain();
        Object original = ed.getCopyToOriginalMap().get(copy);
        if (original == null && ed.getClipboardToOriginalMap() != null) {
            original = ed.getClipboardToOriginalMap().get(copy);
        }
        return original;
    }

    private void prepareAddList() {
        if (this.hasCopyToOriginalMap()) {
            ArrayList<Object> originals = new ArrayList<Object>();
            HashMap originalToCopyMap = new HashMap();
            for (Object element : this.addCommand.getCollection()) {
                Object object = this.getOriginal(element);
                if (object == null) continue;
                originals.add(object);
                originalToCopyMap.put(object, element);
            }
            ArrayList removeList = new ArrayList();
            for (Object e : originals) {
                if (!ActivityAddCommand.isChildOf(originals, e)) continue;
                removeList.add(originalToCopyMap.get(e));
            }
            this.addCommand.getCollection().removeAll(removeList);
        }
    }
}

