/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;

public class ActivityVariabilityCommand
extends AddMethodElementCommand {
    private Activity activity;
    private VariabilityElement ve;
    private VariabilityType type;
    private List elements;
    private IConfigurator configurator;
    private Collection modifiedResources;

    public ActivityVariabilityCommand(Activity activity, VariabilityElement ve, VariabilityType type, IConfigurator configurator) {
        super(TngUtil.getOwningProcess((BreakdownElement)activity));
        this.activity = activity;
        this.ve = ve;
        this.type = type;
        this.configurator = configurator;
        this.elements = Arrays.asList(ve);
        this.modifiedResources = new HashSet();
    }

    public void execute() {
        if (!super.addToDefaultConfiguration(this.elements, this.configurator)) {
            return;
        }
        this.redo();
    }

    public void redo() {
        this.activity.setVariabilityType(this.type);
        this.activity.setVariabilityBasedOnElement(this.ve);
    }

    public void undo() {
        if (!this.elements.isEmpty()) {
            super.undo();
            this.activity.setVariabilityType(VariabilityType.NA);
            this.activity.setVariabilityBasedOnElement(null);
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (this.activity.eResource() != null) {
            this.modifiedResources.add(this.activity.eResource());
        }
        return this.modifiedResources;
    }

    public Collection getAffectedObjects() {
        return super.getAffectedObjects();
    }
}

