/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.Concept;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.Roadmap;
import org.eclipse.epf.uma.SupportingMaterial;

public class AddGuidanceToActivityCommand
extends AddMethodElementCommand {
    private List guidances;
    private Activity activity;
    private Collection modifiedResources;

    public AddGuidanceToActivityCommand(Activity activity, List guidances) {
        super(TngUtil.getOwningProcess((BreakdownElement)activity));
        this.guidances = guidances;
        this.activity = activity;
        this.modifiedResources = new HashSet();
    }

    public void execute() {
        if (!super.addToDefaultConfiguration(this.guidances)) {
            return;
        }
        this.redo();
    }

    public void redo() {
        if (!this.guidances.isEmpty()) {
            for (Object obj : this.guidances) {
                if (!(obj instanceof Guidance)) continue;
                Guidance item = (Guidance)obj;
                if (item instanceof Checklist) {
                    this.activity.getChecklists().add((Checklist)item);
                    continue;
                }
                if (item instanceof Concept) {
                    this.activity.getConcepts().add((Concept)item);
                    continue;
                }
                if (item instanceof Example) {
                    this.activity.getExamples().add((Example)item);
                    continue;
                }
                if (item instanceof SupportingMaterial) {
                    this.activity.getSupportingMaterials().add((SupportingMaterial)item);
                    continue;
                }
                if (item instanceof Guideline) {
                    this.activity.getGuidelines().add((Guideline)item);
                    continue;
                }
                if (item instanceof ReusableAsset) {
                    this.activity.getReusableAssets().add((ReusableAsset)item);
                    continue;
                }
                if (item instanceof Roadmap) {
                    this.activity.getRoadmaps().add((Roadmap)item);
                    continue;
                }
                LibraryEditPlugin.getDefault().getLogger().logError("Cant set guidance " + item.getType().getName() + ":" + item.getName());
            }
        }
    }

    public void undo() {
        if (!this.guidances.isEmpty()) {
            super.undo();
            for (Object obj : this.guidances) {
                if (!(obj instanceof Guidance)) continue;
                Guidance item = (Guidance)obj;
                if (item instanceof Checklist) {
                    this.activity.getChecklists().remove(item);
                    continue;
                }
                if (item instanceof Concept) {
                    this.activity.getConcepts().remove(item);
                    continue;
                }
                if (item instanceof Example) {
                    this.activity.getExamples().remove(item);
                    continue;
                }
                if (item instanceof SupportingMaterial) {
                    this.activity.getSupportingMaterials().remove(item);
                    continue;
                }
                if (item instanceof Guideline) {
                    this.activity.getGuidelines().remove(item);
                    continue;
                }
                if (item instanceof ReusableAsset) {
                    this.activity.getReusableAssets().remove(item);
                    continue;
                }
                if (item instanceof Roadmap) {
                    this.activity.getRoadmaps().remove(item);
                    continue;
                }
                LibraryEditPlugin.getDefault().getLogger().logError("Cant set guidance " + item.getType().getName() + ":" + item.getName());
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (!this.guidances.isEmpty() && this.activity.eResource() != null) {
            this.modifiedResources.add(this.activity.eResource());
        }
        return this.modifiedResources;
    }

    public Collection getAffectedObjects() {
        if (this.activity != null) {
            return Arrays.asList(this.activity);
        }
        return super.getAffectedObjects();
    }
}

