/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class AssignWPToDeliverable
extends AddMethodElementCommand {
    private List workProducts;
    private Activity activity;
    private WorkProductDescriptor wpDesc;
    private Collection modifiedResources;
    private Collection affectedObjects;
    private HashMap map = new HashMap();
    List existingWPDescList = new ArrayList();
    List newWPDescList = new ArrayList();

    public AssignWPToDeliverable(WorkProductDescriptor wpDesc, List workProducts) {
        super(TngUtil.getOwningProcess((BreakdownElement)wpDesc));
        this.workProducts = workProducts;
        this.wpDesc = wpDesc;
        Object parent = this.getParentActivity((BreakdownElement)wpDesc);
        if (parent instanceof Activity) {
            this.activity = (Activity)parent;
        }
        this.modifiedResources = new HashSet();
        this.affectedObjects = new HashSet();
    }

    private Object getParentActivity(BreakdownElement brElement) {
        ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        ItemProviderAdapter adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)brElement, ITreeItemContentProvider.class);
        Object parent = adapter.getParent((Object)brElement);
        while (!(parent instanceof Activity)) {
            brElement = (BreakdownElement)parent;
            adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)brElement, ITreeItemContentProvider.class);
            parent = adapter.getParent((Object)brElement);
        }
        return parent;
    }

    public void execute() {
        List breakdownElements = this.activity.getBreakdownElements();
        if (!super.addToDefaultConfiguration(this.workProducts)) {
            return;
        }
        Iterator it = this.workProducts.iterator();
        while (it.hasNext()) {
            WorkProductDescriptor deliverable;
            boolean descExists = false;
            WorkProduct wp = (WorkProduct)it.next();
            WorkProductDescriptor newWpDesc = null;
            int i = 0;
            while (i < breakdownElements.size()) {
                WorkProduct elementWP;
                BreakdownElement element = (BreakdownElement)breakdownElements.get(i);
                if (element instanceof WorkProductDescriptor && wp.equals(elementWP = (newWpDesc = (WorkProductDescriptor)element).getWorkProduct())) {
                    descExists = true;
                    this.existingWPDescList.add(element);
                    break;
                }
                ++i;
            }
            if (!descExists) {
                this.newWPDescList.add(ProcessUtil.createWorkProductDescriptor(wp));
            }
            if ((deliverable = UserInteractionHelper.getDeliverable(this.activity, wp)) == null) continue;
            this.map.put(newWpDesc, deliverable);
        }
        this.redo();
    }

    public void redo() {
        this.wpDesc.getDeliverableParts().addAll(this.existingWPDescList);
        this.wpDesc.getDeliverableParts().addAll(this.newWPDescList);
    }

    public void undo() {
        super.undo();
        this.wpDesc.getDeliverableParts().removeAll(this.existingWPDescList);
        this.wpDesc.getDeliverableParts().removeAll(this.newWPDescList);
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (this.workProducts != null && !this.workProducts.isEmpty()) {
            if (this.activity.eResource() != null) {
                this.modifiedResources.add(this.activity.eResource());
            }
            if (this.wpDesc.eResource() != null) {
                this.modifiedResources.add(this.wpDesc.eResource());
            }
        }
        return this.modifiedResources;
    }

    public Collection getAffectedObjects() {
        if (this.workProducts != null && !this.workProducts.isEmpty()) {
            this.affectedObjects.add(this.activity);
            this.affectedObjects.add(this.wpDesc);
            return this.affectedObjects;
        }
        return super.getAffectedObjects();
    }
}

