/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.command.UserInput;
import org.eclipse.epf.library.edit.navigator.ProcessPackageItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.AdapterFactoryItemLabelProvider;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.ItemLabelProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Element;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessFamily;
import org.eclipse.epf.uma.ProcessPlanningTemplate;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateProcessComponentCommand
extends CreateChildCommand {
    private static final Collection<EClass> ECLASSES = new HashSet<EClass>();
    private Process process;
    private IStatus status;

    static {
        ECLASSES.add(UmaPackage.eINSTANCE.getMethodPackage());
    }

    public CreateProcessComponentCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object child, int index, Collection<?> selection, CreateChildCommand.Helper helper) {
        super(domain, owner, feature, child, index, selection, helper);
    }

    public boolean canUndo() {
        return false;
    }

    public void execute() {
        MethodLibrary lib = UmaUtil.getMethodLibrary((EObject)this.owner);
        Object shell = LibraryEditPlugin.getDefault().getContext();
        this.status = UserInteractionHelper.checkModify(this.owner, shell);
        if (!this.status.isOK()) {
            return;
        }
        List configs = lib.getPredefinedConfigurations();
        ArrayList methodConfigs = new ArrayList();
        for (Object element : configs) {
            if (element instanceof ProcessFamily) continue;
            methodConfigs.add(element);
        }
        if (methodConfigs.isEmpty()) {
            this.status = new Status(4, LibraryEditPlugin.getDefault().getId(), 0, LibraryEditResources.noConfigError_msg, null);
            return;
        }
        ProcessPackageItemProvider adapter = (ProcessPackageItemProvider)this.helper;
        ArrayList<Class> procClasses = new ArrayList<Class>();
        if (adapter.getProcessType() == UmaPackage.eINSTANCE.getProcessPlanningTemplate()) {
            procClasses.add(DeliveryProcess.class);
            procClasses.add(CapabilityPattern.class);
        }
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)((Element)this.owner));
        List baseProcList = TngUtil.getAvailableBaseProcesses(plugin, procClasses);
        Collections.sort(methodConfigs, new CompareByName());
        MethodConfiguration[] procCtxs = new MethodConfiguration[methodConfigs.size()];
        methodConfigs.toArray(procCtxs);
        Process[] baseProcesses = new Process[baseProcList.size()];
        baseProcList.toArray(baseProcesses);
        final ProcessComponent procComp = (ProcessComponent)this.child;
        EClass procType = adapter.getProcessType();
        procComp.setProcess((Process)UmaFactory.eINSTANCE.create(procType));
        IUserInteractionHandler uiHandler = ExtensionManager.getDefaultUserInteractionHandler();
        ArrayList<UserInput> userInputs = new ArrayList<UserInput>();
        IValidator nameValidator = IValidatorFactory.INSTANCE.createNameValidator((Object)this.owner, (NamedElement)procComp);
        UserInput nameInput = new UserInput(LibraryEditResources.nameLabel_text, 0, false, null, null, nameValidator, null);
        userInputs.add(nameInput);
        UserInput defaultConfigInput = new UserInput(LibraryEditResources.defaultConfigLabel_text, 1, false, methodConfigs, new ItemLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MethodElement) {
                    if (PresentationContext.INSTANCE.isShowPresentationNames()) {
                        return TngUtil.getPresentationName(element);
                    }
                    return ((MethodElement)element).getName();
                }
                return element.toString();
            }
        }, new ConfigValidator(), null);
        userInputs.add(defaultConfigInput);
        UserInput baseProcInput = null;
        if (procComp.getProcess() instanceof ProcessPlanningTemplate) {
            baseProcInput = new UserInput(LibraryEditResources.basedOnProcessesLabel_text, 1, true, baseProcList, new AdapterFactoryItemLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()), null);
            userInputs.add(baseProcInput);
        }
        boolean canExecute = false;
        String msg = NLS.bind((String)LibraryEditResources.CreateProcessComponentCommand_Message, (Object)TngUtil.getTypeText(procType.getName()).toLowerCase());
        if (uiHandler.requestInput(LibraryEditResources.newProcessComponentDialog_title, msg, userInputs)) {
            List list;
            String name = (String)nameInput.getInput();
            procComp.setName(name);
            this.process = procComp.getProcess();
            this.process.setName(name);
            this.process.setPresentationName(name);
            this.process.setDefaultContext((MethodConfiguration)defaultConfigInput.getInput());
            if (baseProcInput != null && !(list = (List)baseProcInput.getInput()).isEmpty()) {
                ((ProcessPlanningTemplate)procComp).getBasedOnProcesses().addAll(list);
            }
            canExecute = true;
        }
        if (canExecute) {
            IStatus status;
            this.status = UserInteractionHelper.checkModify((EObject)procComp.getProcess().getDefaultContext(), shell);
            if (!this.status.isOK()) {
                return;
            }
            super.execute();
            Command cmd = this.getCommand();
            if (cmd instanceof MethodElementAddCommand && (status = ((MethodElementAddCommand)cmd).getStatus()) != null && !status.isOK()) {
                this.status = status;
                return;
            }
            final MethodConfiguration procCtx = this.process.getDefaultContext();
            List pkgs = procCtx.getMethodPackageSelection();
            ProcessComponent obj = procComp;
            while (obj != null) {
                if (obj instanceof MethodPackage) {
                    pkgs.add(obj);
                }
                obj = obj.eContainer();
            }
            procCtx.getMethodPluginSelection().add(plugin);
            this.process.getValidContext().add(procCtx);
            this.process.setPresentation(ContentDescriptionFactory.createContentDescription((DescribableElement)this.process));
            Runnable runnable = new Runnable(){

                public void run() {
                    Resource resource = CreateProcessComponentCommand.this.owner.eResource();
                    if (resource != null) {
                        ILibraryPersister.FailSafeMethodLibraryPersister persister = Services.getDefaultLibraryPersister().getFailSafePersister();
                        try {
                            persister.save(procComp.eResource());
                            persister.save(resource);
                            persister.save(procCtx.eResource());
                            persister.commit();
                        }
                        catch (Exception e) {
                            try {
                                persister.rollback();
                            }
                            catch (Exception ex) {
                                LibraryEditPlugin.INSTANCE.log(ex);
                                LibraryEditPlugin.INSTANCE.log(e);
                            }
                            CreateProcessComponentCommand.this.status = Status.CANCEL_STATUS;
                            throw new MessageException(NLS.bind((String)LibraryEditResources.saveProcessError_reason, (Object)procComp.getName()), e);
                        }
                    }
                }
            };
            UserInteractionHelper.runWithProgress(runnable, MessageFormat.format(LibraryEditResources.creatingProcessComponentTask_name, procComp.getName()));
        }
    }

    public void redo() {
        super.redo();
        ProcessComponent procComp = (ProcessComponent)this.child;
        MethodConfiguration procCtx = this.process.getDefaultContext();
        if (procCtx instanceof MethodConfiguration) {
            procCtx.getMethodPackageSelection().add(procComp);
        }
    }

    public void undo() {
        MethodConfiguration procCtx = this.process.getDefaultContext();
        if (procCtx instanceof MethodConfiguration) {
            procCtx.getMethodPackageSelection().remove(this.child);
        }
        super.undo();
    }

    public IStatus getStatus() {
        return this.status;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompareByName
    implements Comparator<MethodElement> {
        @Override
        public int compare(MethodElement obj1, MethodElement obj2) {
            String name2;
            String name1;
            if (PresentationContext.INSTANCE.isShowPresentationNames()) {
                name1 = TngUtil.getPresentationName(obj1);
                name2 = TngUtil.getPresentationName(obj2);
            } else {
                name1 = obj1.getName();
                name2 = obj2.getName();
            }
            return name1.compareToIgnoreCase(name2);
        }
    }

    public class ConfigValidator
    implements IValidator {
        public IStatus isValid(Object obj) {
            if (obj == null) {
                String msg = LibraryEditResources.noDefaultConfigError_msg;
                return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, msg, null);
            }
            return Status.OK_STATUS;
        }

        public String isValid(String name) {
            return null;
        }
    }
}

