/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.ReplaceActivityCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ActivityHandler;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;

public class LocallyReplaceAndDeepCopyCommand
extends ReplaceActivityCommand {
    public LocallyReplaceAndDeepCopyCommand(BreakdownElementWrapperItemProvider wrapper) {
        super(wrapper);
        this.setLabel(LibraryEditResources.localReplacementAndDeepCopy_text);
    }

    protected void doVary() {
        Activity activity = (Activity)TngUtil.unwrap(this.wrapper);
        if (!UserInteractionHelper.confirmDeepCopy(Collections.singletonList(activity))) {
            return;
        }
        Process targetProcess = (Process)this.wrapper.getTopItem();
        MethodConfiguration deepCopyConfig = null;
        try {
            deepCopyConfig = UserInteractionHelper.chooseDeepCopyConfiguration(targetProcess, this.wrapper.getAdapterFactory());
        }
        catch (OperationCanceledException operationCanceledException) {
            return;
        }
        ActivityHandler activityHandler = new ActivityHandler();
        activityHandler.setDeepCopyConfig(deepCopyConfig);
        activityHandler.setTargetProcess(targetProcess);
        activityHandler.deepCopy(activity);
        Activity copy = activityHandler.getActivities().get(0);
        super.doVary();
        int pos = this.createdActivities.size() - 1;
        Activity localReplacement = (Activity)this.createdActivities.get(pos);
        for (OppositeFeature oppositeFeature : localReplacement.getOppositeFeatures()) {
            Object value = localReplacement.getOppositeFeatureValue(oppositeFeature);
            if (value == null) continue;
            EStructuralFeature feature = oppositeFeature.getTargetFeature();
            if (oppositeFeature.isMany()) {
                for (EObject o : new ArrayList((Collection)value)) {
                    if (feature.isMany()) {
                        List list = (List)o.eGet(feature);
                        list.remove(localReplacement);
                        list.add(copy);
                        continue;
                    }
                    o.eSet(feature, (Object)copy);
                }
                continue;
            }
            EObject o = (EObject)value;
            if (feature.isMany()) {
                List list = (List)o.eGet(feature);
                list.remove(localReplacement);
                list.add(copy);
                continue;
            }
            o.eSet(feature, (Object)copy);
        }
        this.createdActivities.set(pos, copy);
        copy.setVariabilityBasedOnElement(localReplacement.getVariabilityBasedOnElement());
        copy.setVariabilityType(localReplacement.getVariabilityType());
        copy.setPresentedAfter(localReplacement.getPresentedAfter());
        copy.setPresentedBefore(localReplacement.getPresentedBefore());
        Activity superAct = localReplacement.getSuperActivities();
        int id = superAct.getBreakdownElements().indexOf(localReplacement);
        superAct.getBreakdownElements().set(id, copy);
        ((ProcessPackage)superAct.eContainer()).getChildPackages().add((MethodPackage)copy.eContainer());
    }
}

