/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.PBSDropCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.UniqueNamePNameHandler;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class OBSDropCommand
extends BSDropCommand {
    private ArrayList wpDescList;
    private ArrayList roleDescList;
    private Map<RoleDescriptor, TeamProfile> roleDescTeamProfileMap;
    private Map wpDescToDeliverableParts;
    private HashMap<WorkProductDescriptor, WorkProductDescriptor> wpdToDeliverableDescriptorMap;
    private HashMap wpdToTaskFeaturesMap;
    private IConfigurator configrator;
    private boolean newDuplicatesRemoved;

    public OBSDropCommand(Activity act, List roles) {
        super(act, roles);
        Iterator iter = this.dropElements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof Role) continue;
            iter.remove();
        }
    }

    public OBSDropCommand(Activity activity, List dropElements, MethodConfiguration config, Set synchFeatures, IConfigurator configurator) {
        super(activity, dropElements, config, synchFeatures);
        this.configrator = configurator;
    }

    protected boolean preExecute() {
        Role role;
        if (!super.preExecute()) {
            return false;
        }
        this.roleDescList = new ArrayList();
        this.taskDescList = new ArrayList();
        this.wpDescList = new ArrayList();
        this.wpDescToDeliverableParts = new HashMap();
        this.wpdToDeliverableDescriptorMap = new HashMap();
        MethodConfiguration config = this.getMethodConfiguration();
        Set descriptorsToRefresh = this.synchronize ? this.batchCommand.getDescriptorsToRefresh() : null;
        List bes = this.activity.getBreakdownElements();
        UniqueNamePNameHandler uniqueNamesHandler = new UniqueNamePNameHandler(bes);
        int size = this.dropElements.size();
        int i = 0;
        while (i < size) {
            role = (Role)this.dropElements.get(i);
            if (TngUtil.isContributor((VariabilityElement)role)) {
                role = (Role)TngUtil.getBase((VariabilityElement)role);
            }
            RoleDescriptor roleDesc = null;
            if (this.synchronize) {
                roleDesc = (RoleDescriptor)ProcessCommandUtil.getBestDescriptor(role, this.activity, config);
            }
            if (roleDesc == null) {
                roleDesc = ProcessUtil.createRoleDescriptor(role);
                uniqueNamesHandler.ensureUnique((DescribableElement)roleDesc);
                this.roleDescList.add(roleDesc);
            } else if (this.synchronize && roleDesc.getIsSynchronizedWithSource().booleanValue()) {
                this.batchCommand.getDescriptorsToRefresh().add(roleDesc);
            }
            ++i;
        }
        if (!this.synchronize) {
            i = 0;
            while (i < size) {
                role = (Role)this.dropElements.get(i);
                List workProducts = ProcessUtil.getWorkProductsForRole(role, config);
                if (workProducts != null && !workProducts.isEmpty()) {
                    HashMap<WorkProduct, WorkProductDescriptor> wpToExistingDescriptorMap = new HashMap<WorkProduct, WorkProductDescriptor>();
                    ArrayList elements = new ArrayList(this.activity.getBreakdownElements());
                    elements.addAll(this.wpDescList);
                    for (WorkProduct wp : workProducts) {
                        Object wpd = ProcessUtil.getWorkProductDescriptor(this.wpDescList, wp);
                        if (wpd == null) {
                            wpd = ProcessCommandUtil.getDescriptor((Object)wp, this.activity, config);
                        }
                        if (wpd == null) continue;
                        wpToExistingDescriptorMap.put(wp, (WorkProductDescriptor)wpd);
                    }
                    ArrayList selectedWorkProducts = new ArrayList(wpToExistingDescriptorMap.keySet());
                    workProducts.removeAll(selectedWorkProducts);
                    final ArrayList finalSelectedWps = new ArrayList();
                    if (!workProducts.isEmpty()) {
                        final ArrayList finalWps = new ArrayList();
                        finalWps.addAll(workProducts);
                        final Role finalRole = role;
                        UserInteractionHelper.getUIHelper().runSafely(new Runnable(){

                            public void run() {
                                List selected = UserInteractionHelper.selectWorkProducts(finalWps, finalRole);
                                if (selected != null) {
                                    finalSelectedWps.addAll(selected);
                                }
                            }
                        }, true);
                    }
                    selectedWorkProducts.addAll(finalSelectedWps);
                    if (!selectedWorkProducts.isEmpty()) {
                        HashSet allSelectedTasks = new HashSet();
                        int j = 0;
                        while (j < selectedWorkProducts.size()) {
                            List tasks;
                            WorkProductDescriptor wpDesc;
                            WorkProduct wp = (WorkProduct)selectedWorkProducts.get(j);
                            if (TngUtil.isContributor((VariabilityElement)wp)) {
                                wp = (WorkProduct)TngUtil.getBase((VariabilityElement)wp);
                            }
                            if ((wpDesc = (WorkProductDescriptor)wpToExistingDescriptorMap.get(wp)) == null) {
                                wpDesc = (WorkProductDescriptor)ProcessCommandUtil.getDescriptor((Object)wp, this.activity, config);
                            }
                            if (wpDesc == null) {
                                wpDesc = ProcessCommandUtil.createWorkProductDescriptor(wp, config, this.wpDescToDeliverableParts);
                                this.wpDescList.add(wpDesc);
                                WorkProductDescriptor descriptor = UserInteractionHelper.getDeliverable(this.activity, wp);
                                if (descriptor != null) {
                                    this.wpdToDeliverableDescriptorMap.put(wpDesc, descriptor);
                                }
                            } else {
                                if (descriptorsToRefresh != null && wpDesc.getIsSynchronizedWithSource().booleanValue()) {
                                    descriptorsToRefresh.add(wpDesc);
                                }
                                if (wp instanceof Deliverable && this.synchFeatures.contains(UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts())) {
                                    ProcessCommandUtil.createDeliverableParts(wpDesc, (Deliverable)wp, config, this.wpDescToDeliverableParts, descriptorsToRefresh);
                                }
                            }
                            if ((tasks = ProcessUtil.getTasksForWorkProduct(wp, config)) != null && tasks.size() > 0) {
                                tasks.removeAll(allSelectedTasks);
                                Iterator iter = tasks.iterator();
                                while (iter.hasNext()) {
                                    Task task = (Task)iter.next();
                                    Object td = ProcessUtil.getTaskDescriptor(this.taskDescList, task);
                                    if (td == null) {
                                        td = ProcessCommandUtil.getDescriptor((Object)task, this.activity, config);
                                    }
                                    if (td == null) continue;
                                    iter.remove();
                                }
                                if (!tasks.isEmpty()) {
                                    final List finalTasks = tasks;
                                    final WorkProduct finalWp = wp;
                                    final ArrayList finalSelected = new ArrayList();
                                    ArrayList selectedTasks = new ArrayList();
                                    UserInteractionHelper.getUIHelper().runSafely(new Runnable(){

                                        public void run() {
                                            List selected = UserInteractionHelper.selectTasks(finalTasks, finalWp);
                                            finalSelected.addAll(selected);
                                        }
                                    }, true);
                                    selectedTasks.addAll(finalSelected);
                                    if (selectedTasks != null && !selectedTasks.isEmpty()) {
                                        allSelectedTasks.addAll(selectedTasks);
                                    } else {
                                        ProcessCommandUtil.addResponsibleRoleDescriptors(wpDesc, this.activity, this.roleDescList, null, config);
                                    }
                                }
                            } else {
                                ProcessCommandUtil.addResponsibleRoleDescriptors(wpDesc, this.activity, this.roleDescList, null, config);
                            }
                            ++j;
                        }
                        if (allSelectedTasks != null && !allSelectedTasks.isEmpty()) {
                            for (Task task : allSelectedTasks) {
                                PBSDropCommand.addToDescriptorLists(task, this.activity, this.taskDescList, this.roleDescList, this.wpDescList, this.wpDescToDeliverableParts, descriptorsToRefresh, this.batchCommand.getObjectToNewFeatureValuesMap(), config, this.synchronize, this.synchFeatures);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.wpDescList.size()) {
            WorkProductDescriptor wpDesc = (WorkProductDescriptor)this.wpDescList.get(i);
            if (wpDesc != null) {
                uniqueNamesHandler.ensureUnique((DescribableElement)wpDesc);
            }
            ++i;
        }
        return !this.roleDescList.isEmpty() || !this.taskDescList.isEmpty() || !this.wpDescList.isEmpty() || this.wpDescToDeliverableParts != null && !this.wpDescToDeliverableParts.isEmpty() || !this.wpdToDeliverableDescriptorMap.isEmpty() || descriptorsToRefresh != null && !descriptorsToRefresh.isEmpty() || this.batchCommand.canExecute();
    }

    protected void doExecute() {
        ProcessPackage processPackage;
        this.removeNewDuplicates();
        this.activity.getBreakdownElements().addAll(this.roleDescList);
        if (this.roleDescTeamProfileMap == null) {
            this.roleDescTeamProfileMap = new HashMap<RoleDescriptor, TeamProfile>();
            for (RoleDescriptor roleDescriptor : this.roleDescList) {
                TeamProfile teamProfile = UserInteractionHelper.getTeam(this.activity, roleDescriptor.getRole());
                if (teamProfile == null) continue;
                this.roleDescTeamProfileMap.put(roleDescriptor, teamProfile);
            }
        }
        for (Map.Entry<RoleDescriptor, TeamProfile> entry : this.roleDescTeamProfileMap.entrySet()) {
            TeamProfile team = entry.getValue();
            team.getTeamRoles().add(entry.getKey());
        }
        if (!this.wpdToDeliverableDescriptorMap.isEmpty()) {
            for (Map.Entry<WorkProductDescriptor, WorkProductDescriptor> entry : this.wpdToDeliverableDescriptorMap.entrySet()) {
                WorkProductDescriptor deliverable = entry.getValue();
                deliverable.getDeliverableParts().add(entry.getKey());
            }
        }
        this.activity.getBreakdownElements().addAll(this.wpDescList);
        this.activity.getBreakdownElements().addAll(this.taskDescList);
        if (!this.wpDescToDeliverableParts.isEmpty()) {
            for (Map.Entry entry : this.wpDescToDeliverableParts.entrySet()) {
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)entry.getKey();
                wpDesc.getDeliverableParts().addAll((Collection)entry.getValue());
            }
        }
        if ((processPackage = (ProcessPackage)this.activity.eContainer()) != null) {
            processPackage.getProcessElements().addAll(this.taskDescList);
            processPackage.getProcessElements().addAll(this.roleDescList);
            processPackage.getProcessElements().addAll(this.wpDescList);
            Iterator iterator = this.wpDescToDeliverableParts.values().iterator();
            while (iterator.hasNext()) {
                processPackage.getProcessElements().addAll((Collection)iterator.next());
            }
        }
    }

    private void removeNewDuplicates() {
        if (this.synchronize && !this.newDuplicatesRemoved) {
            Iterator iter = this.wpDescList.iterator();
            while (iter.hasNext()) {
                WorkProductDescriptor wpd = (WorkProductDescriptor)iter.next();
                Object desc = ProcessCommandUtil.getDescriptor((Object)wpd.getWorkProduct(), this.activity, this.getMethodConfiguration());
                if (desc == null) continue;
                iter.remove();
                if (this.wpDescToDeliverableParts != null) {
                    this.wpDescToDeliverableParts.remove(wpd);
                }
                if (this.wpdToTaskFeaturesMap != null) {
                    this.wpdToTaskFeaturesMap.remove(wpd);
                }
                if (this.wpdToDeliverableDescriptorMap == null) continue;
                this.wpdToDeliverableDescriptorMap.remove(wpd);
            }
            this.newDuplicatesRemoved = true;
        }
    }

    protected void doUndo() {
        ProcessPackage pkg;
        this.activity.getBreakdownElements().removeAll(this.roleDescList);
        for (Map.Entry<RoleDescriptor, TeamProfile> entry : this.roleDescTeamProfileMap.entrySet()) {
            TeamProfile team = entry.getValue();
            team.getTeamRoles().remove(entry.getKey());
        }
        this.activity.getBreakdownElements().removeAll(this.wpDescList);
        this.activity.getBreakdownElements().removeAll(this.taskDescList);
        if (!this.wpDescToDeliverableParts.isEmpty()) {
            for (Map.Entry<Object, Object> entry : this.wpDescToDeliverableParts.entrySet()) {
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)entry.getKey();
                wpDesc.getDeliverableParts().removeAll((Collection)entry.getValue());
            }
        }
        if (!this.wpdToDeliverableDescriptorMap.isEmpty()) {
            for (Map.Entry<Object, Object> entry : this.wpdToDeliverableDescriptorMap.entrySet()) {
                WorkProductDescriptor deliverable = (WorkProductDescriptor)entry.getValue();
                deliverable.getDeliverableParts().remove(entry.getKey());
            }
        }
        if ((pkg = (ProcessPackage)this.activity.eContainer()) != null) {
            pkg.getProcessElements().removeAll(this.taskDescList);
            pkg.getProcessElements().removeAll(this.roleDescList);
            pkg.getProcessElements().removeAll(this.wpDescList);
            Iterator iterator = this.wpDescToDeliverableParts.values().iterator();
            while (iterator.hasNext()) {
                pkg.getProcessElements().removeAll((Collection)iterator.next());
            }
        }
    }

    public Collection getAffectedObjects() {
        if (this.roleDescList != null) {
            return this.roleDescList;
        }
        return super.getAffectedObjects();
    }

    public void dispose() {
        if (this.roleDescList != null) {
            this.roleDescList.clear();
        }
        if (this.roleDescTeamProfileMap != null) {
            this.roleDescTeamProfileMap.clear();
        }
        if (this.wpDescList != null) {
            this.wpDescList.clear();
        }
        if (this.wpDescToDeliverableParts != null) {
            this.wpDescToDeliverableParts.clear();
        }
        if (this.wpdToDeliverableDescriptorMap != null) {
            this.wpdToDeliverableDescriptorMap.clear();
        }
        if (this.wpdToTaskFeaturesMap != null) {
            this.wpdToTaskFeaturesMap.clear();
        }
        super.dispose();
    }
}

