/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.ui;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.command.UserInput;
import org.eclipse.epf.library.edit.ui.IUIHelper;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.IRunnableWithProgress;
import org.eclipse.epf.library.edit.util.Messenger;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.AbstractStringValidator;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.services.IAccessController;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

public final class UserInteractionHelper {
    private static final boolean canInteract = true;
    private static final IUIHelper uiHelper = (IUIHelper)ExtensionManager.getExtension(LibraryEditPlugin.getDefault().getId(), "uiHelper");

    private UserInteractionHelper() {
    }

    public static boolean canInteract() {
        return true;
    }

    public static int checkAgainstDefaultConfiguration(Process proc, Object object) {
        return UserInteractionHelper.checkAgainstDefaultConfiguration(proc, object, null);
    }

    public static int checkAgainstDefaultConfiguration(Process proc, Object object, IConfigurator configurator) {
        Object e = TngUtil.unwrap(object);
        if (!(e instanceof MethodElement)) {
            return 0;
        }
        if (configurator == null) {
            configurator = Providers.getConfiguratorFactory().createConfigurator(proc.getDefaultContext());
        }
        if (e instanceof VariabilityElement) {
            boolean allIn = true;
            VariabilityElement c = (VariabilityElement)object;
            while (c != null) {
                if (!configurator.accept(c)) {
                    allIn = false;
                    break;
                }
                c = c.getVariabilityBasedOnElement();
            }
            if (allIn) {
                return 1;
            }
        }
        if (configurator.accept(e)) {
            return 1;
        }
        String msg = NLS.bind((String)LibraryEditResources.ui_UserInteractionHelper_defaultconfigcheck, (Object)((MethodElement)e).getName());
        IUserInteractionHandler uiHandler = ExtensionManager.getDefaultUserInteractionHandler();
        if (uiHandler != null) {
            int ret = uiHandler.selectOne(new int[]{4, 5, 1}, LibraryEditResources.add_to_default_config_dlg_title, msg, null);
            if (TngUtil.DEBUG) {
                System.out.println("UserInteractionHelper.checkAgainstDefaultConfiguration(): element=" + e + ", path=" + TngUtil.getLabelWithPath(e));
            }
            switch (ret) {
                case 4: {
                    IStatus status = TngUtil.checkEdit((EObject)proc.getDefaultContext(), null);
                    if (!status.isOK()) {
                        return 0;
                    }
                    return 2;
                }
                case 5: {
                    return 0;
                }
                case 1: {
                    return -1;
                }
            }
        }
        return 0;
    }

    public static List selectTasks(List taskList, WorkProduct wp) {
        return uiHelper.selectTasks(taskList, wp);
    }

    public static List selectWorkProducts(List wpList, Role role) {
        return uiHelper.selectWorkProducts(wpList, role);
    }

    public static String requestName(Object child, EStructuralFeature nameFeature, String title, final IValidator validator) {
        IUserInteractionHandler uiHandler;
        EObject e;
        String str;
        AbstractStringValidator inputValidator = new AbstractStringValidator(){

            public String isValid(String newText) {
                if (validator != null) {
                    return UserInteractionHelper.getSimpleErrorMessage(validator.isValid(newText));
                }
                return null;
            }
        };
        String name = "";
        if (child instanceof EObject && (str = (String)(e = (EObject)child).eGet(nameFeature)) != null) {
            name = str;
        }
        if ((uiHandler = ExtensionManager.getDefaultUserInteractionHandler()) == null) {
            return null;
        }
        UserInput input = new UserInput("", 0, false, null, null, inputValidator, null);
        input.setInput(name);
        boolean ret = uiHandler.requestInput(title, LibraryEditResources.UserInteractionHelper_ProcessPackage_Name, Collections.singletonList(input));
        if (ret) {
            return input.getInput().toString().trim();
        }
        return null;
    }

    public static String getSimpleErrorMessage(String msg) {
        if (msg == null) {
            return null;
        }
        int s = msg.indexOf(58);
        String prefix = "";
        if (s >= 0) {
            prefix = msg.substring(0, s);
            String emptyElementNameErrorMsg = LibraryEditResources.emptyElementNameError_msg;
            String dupContentFileErrorMsg = LibraryEditResources.duplicateContentFileError_msg;
            String dupElementNameErrorMsg = LibraryEditResources.duplicateElementNameError_msg;
            if (emptyElementNameErrorMsg != null && emptyElementNameErrorMsg.startsWith(prefix)) {
                return LibraryEditResources.emptyElementNameError_simple_msg;
            }
            if (dupContentFileErrorMsg != null && dupContentFileErrorMsg.startsWith(prefix)) {
                return LibraryEditResources.duplicateContentFileError_simple_msg;
            }
            if (dupElementNameErrorMsg != null && dupElementNameErrorMsg.startsWith(prefix)) {
                return LibraryEditResources.duplicateElementNameError_simple_msg;
            }
        }
        s = s < 0 ? 0 : ++s;
        int t = msg.indexOf(10);
        if (t < 0) {
            t = msg.length();
        }
        return msg.substring(s, t).trim();
    }

    public static TeamProfile getTeam(Activity activity, Role role) {
        return UserInteractionHelper.getTeam(activity, role, null);
    }

    public static TeamProfile getTeam(Activity activity, Role role, Object UIContext) {
        return uiHelper.getTeam(activity, role, UIContext);
    }

    public static final boolean runWithProgress(final Runnable runnable, String msg) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                runnable.run();
            }
        };
        return UserInteractionHelper.runWithProgress(operation, msg);
    }

    public static final boolean runWithProgress(IRunnableWithProgress runnable, String msg) {
        return UserInteractionHelper.runWithProgress(runnable, false, msg);
    }

    public static final boolean runWithProgress(IRunnableWithProgress runnable, boolean canCancel, String msg) {
        return uiHelper.runWithProgress(runnable, canCancel, msg);
    }

    public static final IStatus runAsJob(IRunnableWithProgress runnable, String taskName) {
        Object shell = LibraryEditPlugin.getDefault().getContext();
        if (shell == null) {
            try {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                return new Status(4, LibraryEditPlugin.getPlugin().getId(), 0, e.toString(), (Throwable)e);
            }
        }
        return UserInteractionHelper.runAsJob(runnable, taskName, shell);
    }

    public static final IStatus runAsJob(IRunnableWithProgress runnable, String taskName, Object shell) {
        return uiHelper.runAsJob(runnable, taskName, shell);
    }

    public static final boolean runInUI(Runnable runnable, String taskName) {
        return UserInteractionHelper.runInUI(runnable, taskName, null);
    }

    public static final boolean runInUI(final Runnable runnable, final String taskName, ISchedulingRule rule) {
        Object shell = LibraryEditPlugin.getDefault().getContext();
        if (shell == null) {
            runnable.run();
            return true;
        }
        IRunnableWithProgress runner = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask(taskName, 2);
                    monitor.worked(1);
                    runnable.run();
                }
                finally {
                    monitor.done();
                }
            }
        };
        return UserInteractionHelper.runInUI(runner, rule, shell);
    }

    public static final boolean runInUI(IRunnableWithProgress runnable, Object shell) {
        return UserInteractionHelper.runInUI(runnable, null, shell);
    }

    public static final boolean runInUI(IRunnableWithProgress runnable, ISchedulingRule rule, Object shell) {
        return uiHelper.runInUI(runnable, rule, shell);
    }

    public static WorkProductDescriptor getDeliverable(Activity activity, WorkProduct wp) {
        return null;
    }

    private static void getDeliverablesInScope(AdapterFactory adapterFactory, BreakdownElement e, WorkProduct wp, List deliverableList) {
        ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)e, ITreeItemContentProvider.class);
        Collection children = itemProvider.getChildren((Object)e);
        for (Object obj : children) {
            WorkProductDescriptor wpDesc;
            List parts;
            if (!(obj instanceof WorkProductDescriptor) || !(ProcessUtil.getAssociatedElement((Descriptor)((WorkProductDescriptor)obj)) instanceof Deliverable) || !(parts = ProcessUtil.getAssociatedElementList((wpDesc = (WorkProductDescriptor)obj).getDeliverableParts())).contains(wp)) continue;
            deliverableList.add(obj);
        }
        Object currentParent = itemProvider.getParent((Object)e);
        if (currentParent != null) {
            UserInteractionHelper.getDeliverablesInScope(adapterFactory, (BreakdownElement)currentParent, wp, deliverableList);
        }
    }

    public static IStatus checkModify(EObject element, Object shell) {
        if (TngUtil.isLocked(element)) {
            String msg = MessageFormat.format(LibraryEditResources.UserInteractionHelper_lockedPlugin, UmaUtil.getMethodPlugin((EObject)element).getName());
            return new Status(4, LibraryEditPlugin.INSTANCE.getId(), 0, msg, null);
        }
        return TngUtil.checkEdit(element, shell);
    }

    public static IStatus checkModify(Collection modifiedResources, Object context) {
        IAccessController ac = Services.getAccessController();
        if (ac == null) {
            return Status.OK_STATUS;
        }
        Resource[] resources = new Resource[modifiedResources.size()];
        modifiedResources.toArray(resources);
        return ac.checkModify(resources, context);
    }

    public static IResource getWorkspaceResource(Resource resource) {
        if (!resource.getURI().isFile()) {
            return null;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(resource.getURI().toFileString());
        return workspaceRoot.getFileForLocation((IPath)path);
    }

    public static boolean checkOutOfSynch(Collection resources) {
        ArrayList<IResource> outOfSynchResources = new ArrayList<IResource>();
        for (Resource resource : resources) {
            IResource wsResource = UserInteractionHelper.getWorkspaceResource(resource);
            if (wsResource == null || wsResource.isSynchronized(0)) continue;
            outOfSynchResources.add(wsResource);
        }
        if (outOfSynchResources.isEmpty()) {
            return true;
        }
        MultiStatus multiStatus = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, "", null);
        for (IResource wsResource : outOfSynchResources) {
            Status status = new Status(1, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, wsResource.getLocation().toOSString(), null);
            multiStatus.add((IStatus)status);
        }
        String title = LibraryEditResources.update_outofsynch_title;
        String msg = LibraryEditResources.update_outofsynch_msg;
        IUserInteractionHandler uiHandler = ExtensionManager.getDefaultUserInteractionHandler();
        int[] nArray = new int[2];
        nArray[1] = 1;
        return uiHandler.selectOne(nArray, title, msg, (IStatus)multiStatus) != 1;
    }

    public static boolean checkModifyOpposite(MethodElement featureOwner, EStructuralFeature feature, MethodElement element) {
        NamedElement oldOppositeFeatureValue;
        OppositeFeature oppositeFeature = OppositeFeature.getOppositeFeature((EStructuralFeature)feature);
        MultiResourceEObject mrEObj = (MultiResourceEObject)element;
        if (oppositeFeature != null && !oppositeFeature.isMany() && (oldOppositeFeatureValue = (NamedElement)mrEObj.getOppositeFeatureMap().get(oppositeFeature)) != null && (oldOppositeFeatureValue instanceof MethodLibrary || oldOppositeFeatureValue.eContainer() != null) && oldOppositeFeatureValue.eResource() != null) {
            String msg = MessageFormat.format(LibraryEditResources.UserInteractionHelper_errRelationshipExists, element.getName(), TngUtil.getLabelWithPath(oldOppositeFeatureValue), featureOwner.getName());
            Messenger.INSTANCE.showWarning(LibraryEditResources.errorDialog_title, msg);
            return false;
        }
        return true;
    }

    public static IStatus checkConfigurationsToUpdate(AddCommand addCommand, Object shell) {
        EObject parent = addCommand.getOwner();
        if (!(parent instanceof MethodPackage)) {
            return Status.OK_STATUS;
        }
        EStructuralFeature feature = addCommand.getFeature();
        if (!(feature instanceof EReference) || !((EReference)feature).isContainment()) {
            return Status.OK_STATUS;
        }
        ArrayList configsToUpdate = new ArrayList();
        MethodPackage parentPkg = (MethodPackage)parent;
        for (Object element : addCommand.getCollection()) {
            if (!(element instanceof MethodPackage)) continue;
            TngUtil.getConfigurationsToUpdate(parentPkg, (MethodPackage)element, configsToUpdate);
        }
        if (!configsToUpdate.isEmpty()) {
            HashSet<Resource> resourcesToCheck = new HashSet<Resource>();
            for (EObject config : configsToUpdate) {
                Resource resource = config.eResource();
                if (resource == null) continue;
                resourcesToCheck.add(resource);
            }
            return UserInteractionHelper.checkModify(resourcesToCheck, shell);
        }
        return Status.OK_STATUS;
    }

    public static boolean confirmDeepCopy(Collection activities) {
        if (UserInteractionHelper.canInteract()) {
            boolean promptNeeded = false;
            for (Object e : activities) {
                if (!(e instanceof Activity) || !ProcessUtil.hasInherited((Activity)e)) continue;
                promptNeeded = true;
                break;
            }
            if (promptNeeded) {
                String title = LibraryEditResources.deepCopy_title;
                String msg = LibraryEditResources.deepCopy_promptMsg;
                int ret = ExtensionManager.getDefaultUserInteractionHandler().selectOne(new int[]{4, 5}, title, msg, null);
                if (ret == 5) {
                    return false;
                }
            }
        }
        return true;
    }

    public static MethodConfiguration chooseDeepCopyConfiguration(Process targetProcess, AdapterFactory adapterFactory) {
        MethodConfiguration currentConfig;
        IFilter filter = ProcessUtil.getFilter(adapterFactory);
        MethodConfiguration deepCopyConfig = null;
        if (filter instanceof IConfigurator && (currentConfig = ((IConfigurator)filter).getMethodConfiguration()) != null && currentConfig != targetProcess.getDefaultContext() && UserInteractionHelper.canInteract()) {
            String msg = LibraryEditResources.ActivityDropCommand_deepCopy_promptConfigurationMsg;
            IUserInteractionHandler uiHandler = ExtensionManager.getDefaultUserInteractionHandler();
            if (uiHandler != null) {
                int ret = uiHandler.selectOne(new int[]{4, 5, 1}, LibraryEditResources.deepCopy_title, msg, null);
                switch (ret) {
                    case 4: {
                        break;
                    }
                    case 5: {
                        deepCopyConfig = currentConfig;
                        break;
                    }
                    case 1: {
                        throw new OperationCanceledException();
                    }
                }
            }
        }
        return deepCopyConfig;
    }

    public static boolean copyExternalVariationsAllowed(Process targetProcess, AdapterFactory adapterFactory) {
        MethodConfiguration currentConfig;
        IFilter filter = ProcessUtil.getFilter(adapterFactory);
        if (filter instanceof IConfigurator && (currentConfig = ((IConfigurator)filter).getMethodConfiguration()) != null && currentConfig != targetProcess.getDefaultContext()) {
            String msg = LibraryEditResources.activity_deep_copy_variability_prompt;
            IUserInteractionHandler uiHandler = ExtensionManager.getDefaultUserInteractionHandler();
            if (uiHandler != null) {
                int ret = uiHandler.selectOne(new int[]{4, 5, 1}, LibraryEditResources.deepCopy_title, msg, null);
                switch (ret) {
                    case 4: {
                        return true;
                    }
                    case 5: {
                        return false;
                    }
                    case 1: {
                        throw new OperationCanceledException();
                    }
                }
            }
        }
        return true;
    }

    public static IUIHelper getUIHelper() {
        return uiHelper;
    }
}

