/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.io.PrintStream;
import java.util.Collection;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DebugUtil {
    private static PrintStream output;
    private static String prompt;

    static {
        prompt = "LD> ";
    }

    public static void setOutput(PrintStream op) {
        output = op;
    }

    public static void setPrompt(String pt) {
        prompt = pt;
    }

    private static PrintStream out() {
        if (output != null) {
            return output;
        }
        return System.out;
    }

    public static void print(String beginTitle, String endTitle, Collection<? extends MethodElement> elements, int ix) {
        if (beginTitle != null) {
            String str = "";
            if (elements == null) {
                str = "null";
            } else if (elements.isEmpty()) {
                str = elements.toString();
            }
            DebugUtil.out().println(String.valueOf(prompt) + beginTitle + str);
        }
        if (elements == null) {
            return;
        }
        for (MethodElement methodElement : elements) {
            DebugUtil.out().println(String.valueOf(prompt) + DebugUtil.toString(methodElement, ix));
        }
        if (endTitle != null) {
            DebugUtil.out().println(String.valueOf(prompt) + endTitle);
        }
        DebugUtil.out().println("");
    }

    public static String toString(MethodElement element, int ix) {
        if (ix == 1) {
            return TngUtil.getLabelWithPath(element);
        }
        if (ix == 2) {
            return String.valueOf(element.eClass().getName()) + ", " + element.getGuid() + ", " + TngUtil.getLabelWithPath(element);
        }
        return element.toString();
    }
}

