/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.epf.export.msp.ExportMSPOptions;
import org.eclipse.epf.export.msp.ExportMSPService;
import org.eclipse.epf.export.msp.ExportMSPServiceException;
import org.eclipse.epf.export.msp.IExportMSPService;
import org.eclipse.epf.export.msp.ui.ExportMSPUIPlugin;
import org.eclipse.epf.export.msp.ui.ExportMSPUIResources;
import org.eclipse.epf.export.msp.ui.wizards.SelectExportDirectoryPage;
import org.eclipse.epf.export.msp.ui.wizards.SelectExportOptionsPage;
import org.eclipse.epf.export.msp.ui.wizards.SelectPublishingOptionsPage;
import org.eclipse.epf.library.ui.wizards.SelectProcessPage;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.util.PublishingUtil;
import org.eclipse.epf.ui.wizards.BaseWizard;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportMSPWizard
extends BaseWizard
implements IExportWizard {
    public static final String WIZARD_ID = ExportMSPWizard.class.getName();
    public static final String WIZARD_EXTENSION_POINT_ID = "org.eclipse.epf.export.msp.ui.exportMSPWizard";
    protected SelectProcessPage selectProcessPage;
    protected SelectExportOptionsPage selectExportOptionsPage;
    protected SelectPublishingOptionsPage selectPublishingOptionsPage;
    protected SelectExportDirectoryPage selectExportDirPage;
    protected ExportMSPOptions exportOptions = new ExportMSPOptions();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(ExportMSPUIResources.exportMSPWizard_title);
    }

    public String getWizardExtenderExtensionPointId() {
        return WIZARD_EXTENSION_POINT_ID;
    }

    public void addPages() {
        if (this.wizardExtender == null) {
            this.selectProcessPage = new SelectProcessPage();
            this.selectExportOptionsPage = new SelectExportOptionsPage();
            this.selectPublishingOptionsPage = new SelectPublishingOptionsPage();
            this.selectExportDirPage = new SelectExportDirectoryPage();
            super.addPage((IWizardPage)this.selectProcessPage);
            super.addPage((IWizardPage)this.selectExportOptionsPage);
            super.addPage((IWizardPage)this.selectPublishingOptionsPage);
            super.addPage((IWizardPage)this.selectExportDirPage);
        } else {
            ArrayList<Object> wizardPages = new ArrayList<Object>();
            IWizardPage page = this.wizardExtender.getReplaceWizardPage(SelectProcessPage.PAGE_NAME);
            if (page != null) {
                wizardPages.add(page);
            } else {
                this.selectProcessPage = new SelectProcessPage();
                wizardPages.add(this.selectProcessPage);
            }
            page = this.wizardExtender.getReplaceWizardPage(SelectExportOptionsPage.PAGE_NAME);
            if (page != null) {
                wizardPages.add(page);
            } else {
                this.selectExportOptionsPage = new SelectExportOptionsPage();
                wizardPages.add((Object)this.selectExportOptionsPage);
            }
            page = this.wizardExtender.getReplaceWizardPage(SelectPublishingOptionsPage.PAGE_NAME);
            if (page != null) {
                wizardPages.add(page);
            } else {
                this.selectPublishingOptionsPage = new SelectPublishingOptionsPage();
                wizardPages.add((Object)this.selectPublishingOptionsPage);
            }
            page = this.wizardExtender.getReplaceWizardPage(SelectExportDirectoryPage.PAGE_NAME);
            if (page != null) {
                wizardPages.add(page);
            } else {
                this.selectExportDirPage = new SelectExportDirectoryPage();
                wizardPages.add((Object)this.selectExportDirPage);
            }
            super.getNewWizardPages(wizardPages);
            for (IWizardPage iWizardPage : wizardPages) {
                super.addPage(iWizardPage);
            }
            this.wizardExtender.initWizardPages(wizardPages);
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(ExportMSPUIPlugin.getDefault().getSharedImage("full/obj16/MSProject.gif"));
    }

    public boolean canFinish() {
        if (this.wizardExtender != null && !this.wizardExtender.canFinish()) {
            return false;
        }
        return this.getContainer().getCurrentPage() == this.selectExportDirPage && this.selectExportDirPage.isPageComplete();
    }

    public boolean doFinish() {
        return this.exportMSP(this.selectProcessPage.getProcess(), this.getExportOptions(), (IExportMSPService)ExportMSPService.getInstance());
    }

    public boolean exportMSP(Process process, ExportMSPOptions exportOptions, IExportMSPService service) {
        boolean ok;
        block12: {
            if (process == null || exportOptions == null || service == null) {
                throw new IllegalArgumentException();
            }
            try {
                boolean ok2;
                MethodConfiguration config = exportOptions.getMethodConfiguration();
                if (config == null) {
                    throw new IllegalArgumentException("exportOptions.getMethodConfiguration()");
                }
                if (!exportOptions.getPublishWebSite()) break block12;
                if (this.selectPublishingOptionsPage != null) {
                    this.selectPublishingOptionsPage.savePreferences();
                }
                if (PublishingUtil.hasValidProcessView((MethodConfiguration)config, (Process)process) || (ok2 = ExportMSPUIPlugin.getDefault().getMsgDialog().displayPrompt(ExportMSPUIResources.exportMSPWizard_title, ExportMSPUIResources.missingProcessContentWarning_msg))) break block12;
                return false;
            }
            catch (IllegalArgumentException e) {
                this.displayIllegalArgumentError(e.getMessage());
                return true;
            }
        }
        File exportDir = exportOptions.getExportDir();
        if (exportDir == null) {
            throw new IllegalArgumentException("exportOptions.getExportDir()");
        }
        String msprojectName = exportOptions.getMSProjectName();
        if (msprojectName == null) {
            throw new IllegalArgumentException("exportOptions.getMSProjectName()");
        }
        String msprojectFileName = String.valueOf(msprojectName) + ".xml";
        File msprojectFile = new File(exportDir, msprojectFileName);
        if (msprojectFile.exists() && !(ok = ExportMSPUIPlugin.getDefault().getMsgDialog().displayPrompt(ExportMSPUIResources.exportMSPWizard_title, NLS.bind((String)ExportMSPUIResources.overwriteText_msg, (Object[])new String[]{msprojectFileName, exportDir.getAbsolutePath()})))) {
            return false;
        }
        try {
            boolean success = service.exportMSProject(process, exportOptions);
            if (success) {
                ExportMSPUIPlugin.getDefault().getMsgDialog().displayInfo(ExportMSPUIResources.exportMSPWizard_title, NLS.bind((String)ExportMSPUIResources.completedText_msg, (Object[])new String[]{process.getName(), msprojectFile.getAbsolutePath()}));
            }
        }
        catch (ExportMSPServiceException e) {
            ExportMSPUIPlugin.getDefault().getMsgDialog().displayError(ExportMSPUIResources.exportMSPWizard_title, NLS.bind((String)ExportMSPUIResources.exportMSPError_msg, (Object[])new String[]{process.getName(), msprojectFile.getAbsolutePath()}), ExportMSPUIResources.exportMSPError_reason, (Throwable)e);
        }
        return true;
    }

    public SelectProcessPage getSelectProcessPage() {
        return this.selectProcessPage;
    }

    public SelectExportOptionsPage getExportOptionsPage() {
        return this.selectExportOptionsPage;
    }

    public SelectPublishingOptionsPage selectPublishingOptionsPage() {
        return this.selectPublishingOptionsPage;
    }

    public SelectExportDirectoryPage getSelectExportDirectoryPage() {
        return this.selectExportDirPage;
    }

    public ExportMSPOptions getExportOptions() {
        this.exportOptions.setMethodConfiguration(this.selectExportOptionsPage.getMethodConfiguration());
        this.exportOptions.setExportDir(new File(this.selectExportDirPage.getExportDirectory()));
        this.exportOptions.setMSProjectName(this.selectExportDirPage.getMSProjectName());
        this.exportOptions.setExportOnlyPlannedWBSElements(this.selectExportOptionsPage.getExportOnlyPlannedWBSElementsSelection());
        if (this.selectExportOptionsPage.getPublishWebSiteSelection()) {
            PublishOptions publishingOptions = this.selectPublishingOptionsPage.getPublishingOptions();
            boolean publishConfig = this.selectExportOptionsPage.getPublishConfigSelection();
            boolean publishProcess = this.selectExportOptionsPage.getPublishProcessSelection();
            publishingOptions.setPublishConfiguration(publishConfig);
            publishingOptions.setPublishProcess(publishProcess);
            this.exportOptions.setPublishWebSite(publishingOptions != null && (publishConfig || publishProcess));
            this.exportOptions.setPublishingOptions(publishingOptions);
        } else {
            this.exportOptions.setPublishWebSite(false);
            this.exportOptions.setPublishingOptions(null);
        }
        return this.exportOptions;
    }

    protected void displayIllegalArgumentError(String name) {
        String msg = NLS.bind((String)ExportMSPUIResources.illegalArgument_msg, (Object[])new String[]{name});
        ExportMSPUIPlugin.getDefault().getMsgDialog().displayError(ExportMSPUIResources.exportMSPWizard_title, ExportMSPUIResources.exportMSPInternalError_msg, ExportMSPUIResources.exportMSPError_reason, (Throwable)new IllegalArgumentException(msg));
    }
}

