/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.ui.dialogs;

import java.io.File;
import org.eclipse.epf.ui.EPFUIResources;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameFileConflictDialog
extends Dialog {
    protected Button okButton;
    protected Button cancelButton;
    protected Button overWriteButton;
    private Text ctrl_fileName;
    private int OVER_WRITE_ID = 22;
    private String messageStr;
    private String fileName;
    private Button button_replace;
    private Button button_unique;
    private String destination;

    public RenameFileConflictDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)dialogArea.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        GridData gridData = (GridData)dialogArea.getLayoutData();
        gridData.verticalIndent = 10;
        gridData.widthHint = 450;
        layout.numColumns = 3;
        Image image = Display.getCurrent().getSystemImage(8);
        if (image != null) {
            Label imageLabel = new Label(dialogArea, 0);
            image.setBackground(imageLabel.getBackground());
            imageLabel.setImage(image);
            imageLabel.setLayoutData((Object)new GridData(66));
        }
        Label message = new Label(dialogArea, 64);
        if (this.messageStr != null) {
            message.setText(this.messageStr);
        }
        GridData data1 = new GridData(768);
        data1.horizontalSpan = 2;
        message.setLayoutData((Object)data1);
        Label empty = new Label(dialogArea, 0);
        empty.setText("");
        Label note = new Label(dialogArea, 0);
        note.setText(EPFUIResources.Dialog_fileNameConflict_note);
        GridData data2 = new GridData(768);
        data2.horizontalSpan = 2;
        note.setLayoutData((Object)data2);
        empty = new Label(dialogArea, 0);
        empty.setText("");
        GridData data3 = new GridData(768);
        data3.horizontalSpan = 3;
        data3.heightHint = 10;
        empty.setLayoutData((Object)data3);
        empty = new Label(dialogArea, 0);
        empty.setText("");
        Label selectAction = new Label(dialogArea, 0);
        selectAction.setText(EPFUIResources.Dialog_fileName_selectAction_label);
        GridData data4 = new GridData(768);
        data4.horizontalSpan = 2;
        selectAction.setLayoutData((Object)data4);
        empty = new Label(dialogArea, 0);
        empty.setText("");
        empty = new Label(dialogArea, 0);
        empty.setText("");
        this.button_replace = new Button(dialogArea, 16);
        this.button_replace.setText(EPFUIResources.Dialog_fileName_replace_msg);
        this.button_replace.setSelection(true);
        empty = new Label(dialogArea, 0);
        empty.setText("");
        empty = new Label(dialogArea, 0);
        empty.setText("");
        this.button_unique = new Button(dialogArea, 16);
        this.button_unique.setText(EPFUIResources.Dialog_fileName_unique_msg);
        this.button_unique.setSelection(false);
        empty = new Label(dialogArea, 0);
        empty.setText("");
        empty = new Label(dialogArea, 0);
        empty.setText("");
        this.ctrl_fileName = new Text(dialogArea, 2048);
        GridData gridData1 = new GridData(1);
        gridData1.widthHint = 200;
        gridData1.verticalAlignment = 4;
        this.ctrl_fileName.setLayoutData((Object)gridData1);
        if (this.fileName != null) {
            this.ctrl_fileName.setText(this.fileName);
            this.ctrl_fileName.setEnabled(false);
        }
        this.ctrl_fileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RenameFileConflictDialog.this.okButton != null) {
                    RenameFileConflictDialog.this.okButton.setEnabled(RenameFileConflictDialog.this.ctrl_fileName.getText().trim().length() > 0);
                }
                RenameFileConflictDialog.this.fileName = RenameFileConflictDialog.this.ctrl_fileName.getText();
                File file = new File(String.valueOf(RenameFileConflictDialog.this.destination) + File.separator + RenameFileConflictDialog.this.fileName);
                if (file.exists()) {
                    RenameFileConflictDialog.this.okButton.setEnabled(false);
                } else {
                    RenameFileConflictDialog.this.okButton.setEnabled(true);
                }
            }
        });
        this.button_replace.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                RenameFileConflictDialog.this.ctrl_fileName.setEnabled(false);
                RenameFileConflictDialog.this.okButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.button_unique.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                RenameFileConflictDialog.this.ctrl_fileName.setEnabled(true);
                RenameFileConflictDialog.this.fileName = RenameFileConflictDialog.this.ctrl_fileName.getText();
                File file = new File(String.valueOf(RenameFileConflictDialog.this.destination) + File.separator + RenameFileConflictDialog.this.fileName);
                if (file.exists()) {
                    RenameFileConflictDialog.this.okButton.setEnabled(false);
                } else {
                    RenameFileConflictDialog.this.okButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        super.getShell().setText(EPFUIResources.Dialog_fileNameConflict_title);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = super.getButton(0);
        this.cancelButton = super.getButton(1);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public String getFilePath() {
        return this.fileName;
    }

    public void setFilePath(String fileName) {
        this.fileName = fileName;
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == this.OVER_WRITE_ID) {
            this.overWritePressed();
        }
        super.buttonPressed(buttonId);
    }

    private void overWritePressed() {
        this.setReturnCode(this.OVER_WRITE_ID);
        this.close();
    }

    protected void cancelPressed() {
        this.fileName = null;
        super.cancelPressed();
    }

    public String getMessageStr() {
        return this.messageStr;
    }

    public void setMessageStr(String messageStr) {
        this.messageStr = messageStr;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }
}

