/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.ui.EPFUIPlugin;
import org.eclipse.epf.ui.wizards.INewWizardPageContribution;
import org.eclipse.epf.ui.wizards.IWizardExtender;
import org.eclipse.epf.ui.wizards.NewWizardPageContribution;
import org.eclipse.epf.ui.wizards.ReplaceWizardPageContribution;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWizard
extends Wizard {
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected IWizardExtender wizardExtender;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.processWizardExtenderExtensionPoint();
        this.initializeExtender();
    }

    protected void initializeExtender() {
        if (this.wizardExtender != null) {
            this.wizardExtender.init(this);
        }
    }

    public abstract String getWizardExtenderExtensionPointId();

    public IWizardExtender getWizardExtender() {
        return this.wizardExtender;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = null;
        if (this.wizardExtender != null) {
            nextPage = this.wizardExtender.getNextPage(page);
        }
        if (nextPage == null) {
            nextPage = super.getNextPage(page);
        }
        return nextPage;
    }

    public boolean canFinish() {
        if (this.wizardExtender != null) {
            return this.wizardExtender.canFinish();
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        if (this.wizardExtender != null) {
            return this.wizardExtender.doFinish();
        }
        return this.doFinish();
    }

    public boolean doFinish() {
        return true;
    }

    protected IWizardExtender createWizardExtender(IWizardExtender defaultExtender) {
        return defaultExtender;
    }

    protected void processWizardExtenderExtensionPoint() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        String extensionPointId = this.getWizardExtenderExtensionPointId();
        if (extensionPointId == null) {
            return;
        }
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(extensionPointId);
        if (extensionPoint == null) {
            return;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement configElement = configElements[j];
                try {
                    IWizardExtender extender = (IWizardExtender)configElement.createExecutableExtension("class");
                    if (this.wizardExtender == null) {
                        this.wizardExtender = this.createWizardExtender(extender);
                        IConfigurationElement[] childConfigElements = configElement.getChildren("wizardPage");
                        int k = 0;
                        while (k < childConfigElements.length) {
                            IConfigurationElement childConfigElement = childConfigElements[k];
                            IWizardPage wizardPage = (IWizardPage)childConfigElement.createExecutableExtension("class");
                            String type = childConfigElement.getAttribute("type");
                            String target = childConfigElement.getAttribute("target");
                            String insert = childConfigElement.getAttribute("insert");
                            if (wizardPage != null && type != null && type.length() > 0) {
                                if (type.equals("replace")) {
                                    this.wizardExtender.addReplaceWizardPageContribution(new ReplaceWizardPageContribution(wizardPage, target));
                                } else if (type.equals("new")) {
                                    boolean insertAfter = true;
                                    if (insert != null && insert.equals("before")) {
                                        insertAfter = false;
                                    }
                                    this.wizardExtender.addNewWizardPageContribution(new NewWizardPageContribution(wizardPage, target, insertAfter));
                                }
                            }
                            ++k;
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    EPFUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
                ++j;
            }
            ++i;
        }
    }

    protected void getNewWizardPages(List<IWizardPage> wizardPages) {
        List<INewWizardPageContribution> contributions = this.wizardExtender.getNewWizardPageContributions();
        if (contributions != null) {
            for (NewWizardPageContribution newWizardPageContribution : contributions) {
                IWizardPage newWizardPage = newWizardPageContribution.getWizardPage();
                String targetWizardPageName = newWizardPageContribution.getTargetWizardPage();
                if (targetWizardPageName == null) continue;
                int totalPages = wizardPages.size();
                int index = 0;
                Iterator<IWizardPage> iter = wizardPages.iterator();
                while (wizardPages.size() == totalPages && iter.hasNext()) {
                    IWizardPage page = iter.next();
                    if (page.getName().equals(targetWizardPageName)) {
                        if (newWizardPageContribution.getInsertAfter()) {
                            wizardPages.add(index + 1, newWizardPage);
                        } else {
                            wizardPages.add(index, newWizardPage);
                        }
                    }
                    ++index;
                }
                if (wizardPages.size() != totalPages) continue;
                wizardPages.add(newWizardPage);
            }
        }
    }
}

