/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.configuration.PracticeSubgroupItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.Bookmark;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.util.IconUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.ISiteGenerator;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.services.PublishingContentValidator;
import org.eclipse.epf.publishing.services.PublishingRunnable;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractViewBuilder {
    protected static final int TIMEOUT_INTERVAL = 600000;
    protected static boolean profiling = PublishingPlugin.getDefault().isProfiling();
    protected ISiteGenerator siteGenerator;
    protected PublishOptions options;
    protected MethodConfiguration config;
    protected Bookmark defaultView;
    PublishingRunnable runnable = null;

    public AbstractViewBuilder(ISiteGenerator generator) {
        this.siteGenerator = generator;
        this.options = generator.getPublishOptions();
        this.config = generator.getHtmlBuilder().getLayoutManager().getConfiguration();
        this.runnable = new PublishingRunnable(generator.getHtmlBuilder(), 600000);
    }

    public ISiteGenerator getSiteGenerator() {
        return this.siteGenerator;
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.siteGenerator.getHtmlBuilder();
    }

    public PublishOptions getOptions() {
        return this.siteGenerator.getPublishOptions();
    }

    public ElementLayoutManager getLayoutMgr() {
        return this.getHtmlBuilder().getLayoutManager();
    }

    public PublishingContentValidator getValidator() {
        return (PublishingContentValidator)this.getHtmlBuilder().getValidator();
    }

    protected boolean canPublish(MethodElement element) {
        return this.isVisible(element);
    }

    protected boolean isVisible(MethodElement element) {
        if (element == null) {
            return false;
        }
        if (this.getValidator().isDiscarded(null, null, element)) {
            return false;
        }
        if (!ConfigurationHelper.canShow((MethodElement)element, (MethodConfiguration)this.config)) {
            return false;
        }
        if (this.options.isPublishProcess()) {
            return this.getValidator().inClosure(element);
        }
        return true;
    }

    protected void discardEmptyCategory(ContentCategory element, boolean discard) {
        if (discard) {
            this.getValidator().setDiscardedElement((MethodElement)element);
            this.getValidator().logWarning((MethodElement)element, PublishingResources.discaredCategoryWarning_msg);
        } else {
            this.getValidator().addValidCategory(element);
        }
    }

    protected MethodElement calc01FeatureValue(MethodElement element, EStructuralFeature feature) {
        return ConfigurationHelper.calc01FeatureValue((MethodElement)element, (EStructuralFeature)feature, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
    }

    protected List calc0nFeatureValue(MethodElement element, EStructuralFeature feature) {
        return ConfigurationHelper.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)feature, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
    }

    protected MethodElement calc01FeatureValue(MethodElement element, OppositeFeature feature) {
        return ConfigurationHelper.calc01FeatureValue((MethodElement)element, (OppositeFeature)feature, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
    }

    protected List calc0nFeatureValue(MethodElement element, OppositeFeature feature) {
        return ConfigurationHelper.calc0nFeatureValue((MethodElement)element, (OppositeFeature)feature, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
    }

    protected List getPublishedElements() {
        return this.getValidator().getPublishedElements();
    }

    protected void publish(IProgressMonitor monitor, MethodElement element) {
        block6: {
            try {
                List linkedElements = this.getValidator().getReferencedElements();
                List publishedElements = this.getValidator().getPublishedElements();
                HtmlBuilder htmlBuilder = this.getHtmlBuilder();
                if (!this.canPublish(element)) {
                    htmlBuilder.getValidator().logWarning(element, PublishingResources.invalidElementWarning_msg);
                    break block6;
                }
                if (publishedElements.contains(element)) break block6;
                try {
                    if (monitor != null) {
                        String str = linkedElements != null ? NLS.bind((String)PublishingResources.publishingLinkedElementTask_name, (Object)Integer.toString(publishedElements.size()), (Object)Integer.toString(linkedElements.size())) : NLS.bind((String)PublishingResources.publishingElementTask_name, (Object)element.getType().getName(), (Object)element.getName());
                        monitor.subTask(str);
                    }
                    IElementLayout layout = htmlBuilder.getLayoutManager().getLayout(element, true);
                    String htmlfile = this.runnable.generateHtml(layout);
                    this.elementPublished(layout, htmlfile);
                }
                catch (Exception ex) {
                    htmlBuilder.getValidator().logError(element, NLS.bind((String)PublishingResources.publishElementError_msg, (Object)ex.getMessage()), (Throwable)ex);
                }
                publishedElements.add(element);
            }
            catch (RuntimeException e) {
                this.getHtmlBuilder().getValidator().logError(element, NLS.bind((String)PublishingResources.publishElementError_msg, (Object)e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void elementPublished(IElementLayout layout, String htmlfile) {
    }

    private void copyNodeIcon(File source) {
        String name = source.getName();
        File dest = new File(this.siteGenerator.getNodeIconPath(), name);
        if (!FileUtil.copyFile((File)source, (File)dest)) {
            this.getHtmlBuilder().getValidator().logWarning(NLS.bind((String)PublishingResources.copyFileWarning_msg, (Object)source.getAbsolutePath(), (Object)dest.getAbsolutePath()));
        }
    }

    protected String getNodeIconName(Object obj) {
        File iconFile = null;
        String iconName = null;
        if (obj instanceof DescribableElement) {
            URI uri = ((DescribableElement)obj).getNodeicon();
            EObject uriInheritingBase = null;
            if (uri == null && this.config != null && obj instanceof VariabilityElement) {
                VariabilityElement[] uriInheritingBases = new VariabilityElement[1];
                uri = ConfigurationHelper.getInheritingUri((DescribableElement)((DescribableElement)obj), (URI)uri, (VariabilityElement[])uriInheritingBases, (MethodConfiguration)this.config, (int)0);
                uriInheritingBase = uriInheritingBases[0];
            }
            ((DescribableElement)obj).getType().getName().toLowerCase();
            if (uri != null) {
                boolean isFullPath = false;
                try {
                    URL url = uri.toURL();
                    if (url != null) {
                        iconFile = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
                        isFullPath = true;
                    }
                }
                catch (Exception exception) {}
                if (!isFullPath) {
                    iconFile = new File(TngUtil.getFullPathofNodeorShapeIconURI((EObject)(uriInheritingBase == null ? (EObject)obj : uriInheritingBase), (URI)uri));
                }
            }
        }
        if (iconFile != null && !iconFile.exists()) {
            iconFile = null;
        }
        if (iconFile == null) {
            if (obj instanceof MethodElement) {
                String type = ((MethodElement)obj).getType().getName().toLowerCase();
                iconFile = IconUtil.getNodeIconFile((String)type);
            } else if (obj instanceof PracticeSubgroupItemProvider) {
                iconFile = IconUtil.getNodeIconFile((PracticeSubgroupItemProvider)((PracticeSubgroupItemProvider)obj));
            }
        }
        if (iconFile != null) {
            if (!iconFile.exists()) {
                if (obj instanceof MethodElement) {
                    this.getHtmlBuilder().getValidator().logWarning((MethodElement)obj, NLS.bind((String)PublishingResources.missingIconFileWarning_msg, (Object)iconFile.getAbsolutePath()));
                } else {
                    this.getHtmlBuilder().getValidator().logWarning(NLS.bind((String)PublishingResources.missingIconFileWarning_msg, (Object)iconFile.getAbsolutePath()));
                }
            }
            this.copyNodeIcon(iconFile);
            iconName = iconFile.getName();
        }
        if (iconName == null || iconName.length() == 0) {
            String name = obj instanceof MethodElement ? ((MethodElement)obj).getName() : obj.toString();
            this.getHtmlBuilder().getValidator().logWarning(NLS.bind((String)PublishingResources.missingIconNameWarning_msg, (Object)name));
        }
        return iconName;
    }

    private String getName(Object obj) {
        String name = null;
        if (obj instanceof MethodElement) {
            int index;
            MethodElement e = (MethodElement)obj;
            name = ConfigurationHelper.getPresentationName((MethodElement)e, (MethodConfiguration)this.config);
            if ((name == null || name.equals("")) && (index = (name = e.getClass().getName()).lastIndexOf(".")) >= 0 && (name = name.substring(index + 1)).endsWith("Impl")) {
                name = name.substring(0, name.length() - 4);
            }
        } else if (obj instanceof ItemProviderAdapter) {
            ItemProviderAdapter provider = (ItemProviderAdapter)obj;
            name = provider.getText(obj);
        }
        return name;
    }

    private String getGUID(Object obj) {
        if (obj instanceof MethodElement) {
            return ((MethodElement)obj).getGuid();
        }
        return null;
    }

    private String getURL(Object obj) {
        if (obj instanceof MethodElement) {
            return this.getLayoutMgr().getLayout((MethodElement)obj, true).getUrl();
        }
        return "applet//empty.htm";
    }

    protected Bookmark createBookmark(IProgressMonitor monitor, Object element) {
        if (element instanceof MethodElement) {
            this.getHtmlBuilder().getValidator().addReferencedElement(null, (MethodElement)element);
        }
        String name = this.getName(element);
        String guid = this.getGUID(element);
        String url = this.getURL(element);
        String nodeIcon = this.getNodeIconName(element);
        String msg = NLS.bind((String)PublishingResources.generatingBookmarkTask_name, (Object)name);
        monitor.subTask(msg);
        return this.createBookmark(name, guid, url, nodeIcon, nodeIcon, element);
    }

    protected Bookmark createBookmark(String name, String guid, String url, String closeIcon, String openIcon, Object owner) {
        Bookmark b = new Bookmark(name);
        b.setPresentationName(name);
        b.setUniqueId(guid);
        b.setClosedIconName(closeIcon);
        b.setOpenIconName(openIcon);
        b.setFileName(url);
        b.setFromContentLibrary(true);
        b.setEnabled(true);
        b.setExist(true);
        b.setVisible(true);
        b.setTransparency(false);
        b.setDefault(true);
        b.setCurrent(false);
        b.setOwner(owner);
        return b;
    }

    public Bookmark getDefaultView() {
        return this.defaultView;
    }

    public abstract List<Bookmark> buildViews(IProgressMonitor var1);

    public void dispose() {
        this.config = null;
        if (this.runnable != null) {
            this.runnable.dispose();
            this.runnable = null;
        }
        if (this.siteGenerator != null) {
            this.siteGenerator.dispose();
            this.siteGenerator = null;
        }
    }
}

