/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.layout.Bookmark;
import org.eclipse.epf.library.layout.BookmarkList;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.services.AbstractSiteGenerator;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.util.PublishingUtil;

public class DefaultSiteGenerator
extends AbstractSiteGenerator {
    public static final String NO_APPLET_DIRECTORY = "noapplet";
    public static final String BOOKMARK_SUFFIX_XML = ".xml";
    public static final String BOOKMARK_SUFFIX_HTML = ".html";
    public static final String SPACE_REPLACEMENT = "_";
    public static final String SPACE_STRING = " ";
    public static final String PUBLISHED_BOOKMARKS_CFG_NAME = "PublishedBookmarks.xml";
    public static final String PUBLISHED_BOOKMARKS_DELIMITER = "*";
    protected static final String BOOKMARK_XSL_FILE = "xsl/bookmark.xsl";
    protected static final String BOOKMARKS_XSL_FILE = "xsl/PublishedBookmarks.xsl";
    protected static final String INDEX_XSL_FILE = "xsl/index.xsl";
    protected static final String TOPNAV_XSL_FILE = "xsl/topnav.xsl";
    protected static final String SEARCH_XSL_FILE = "xsl/search.xsl";
    private static final String APPLET_PATH = "applet" + File.separatorChar;
    private static final String NO_APPLET_PATH = "noapplet" + File.separatorChar;
    private static final String ICON_PATH = "images" + File.separatorChar;
    private static final String SERVER_SEARCH_PATH = "docroot/server_search";
    private static final String DEFAULT_BANNER_FILE = "EPFC_banner.jpg";
    protected File iconPath;

    public DefaultSiteGenerator(HtmlBuilder builder, PublishHTMLOptions options) {
        super(builder, options);
        this.iconPath = new File(this.pubDir, options.isPublishDynamicWebApp() ? String.valueOf(NO_APPLET_PATH) + ICON_PATH : String.valueOf(APPLET_PATH) + ICON_PATH);
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.builder;
    }

    public PublishOptions getPublishOptions() {
        return this.options;
    }

    public String getNodeIconPath() {
        return this.iconPath.getAbsolutePath();
    }

    public String getDefaultBannerImageFile() {
        return DEFAULT_BANNER_FILE;
    }

    public void prePublish() throws Exception {
        this.copyFiles();
    }

    public void postPublish() throws Exception {
        this.copyIconsForNonApplet();
        this.writeIndexAndTopNavHtml();
        this.writeSearchHtml();
    }

    protected void copyFiles() throws Exception {
        this.copyDocRootFiles();
        this.copyLocalizedFiles();
        this.copyCustomizedFiles();
    }

    protected void copyDocRootFiles() throws Exception {
        URL plugin_url = PublishingPlugin.getDefault().getInstallURL();
        URL url = new URL(plugin_url, "docroot/");
        String fromPath = Platform.resolve((URL)url).getPath();
        String includes = "*.*, process/**, images/**, index/**, scripts/**, stylesheets/**";
        String excludes = "";
        if (this.options.isPublishJavaScriptTree()) {
            includes = String.valueOf(includes) + ", noapplet/**";
        }
        LayoutResources.copyDir((String)fromPath, (String)this.pubDir, (String)includes, (String)excludes);
        String path = FileLocator.resolve((URL)new URL(plugin_url, SERVER_SEARCH_PATH)).getPath();
        includes = "*.*, search/**";
        LayoutResources.copyDir((String)path, (String)this.pubDir, (String)includes, null);
    }

    protected void copyCustomizedFiles() throws Exception {
        super.copyCustomizedFiles();
        if (this.options.aboutHTML != null && this.options.aboutHTML.length() > 0) {
            FileUtil.copyFile((String)this.options.aboutHTML, (String)(String.valueOf(this.pubDir) + "about.htm"));
        }
    }

    protected void copyLocalizedFiles() throws Exception {
        super.copyLocalizedFiles();
        if (this.options.isPublishJavaScriptTree()) {
            PublishingPlugin.getDefault().copyLocalizedFiles("docroot/noapplet/", new File(this.pubDir, "noapplet/"), false, false);
        }
    }

    protected void copyIconsForNonApplet() {
        try {
            if (this.options.isPublishJavaScriptTree()) {
                LayoutResources.copyDir((String)this.iconPath.getAbsolutePath(), (String)(String.valueOf(this.pubDir) + NO_APPLET_PATH + ICON_PATH));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String writeBookmark(Bookmark b) {
        String bookmarkFileName = super.getViewDataFileName(b, BOOKMARK_SUFFIX_XML);
        XmlElement xml = b.getXmlElement();
        String buffer = PublishingUtil.getHtml(xml, BOOKMARK_XSL_FILE);
        if (buffer != null) {
            String htmlPath = this.getBookmarkHtmlPath(bookmarkFileName);
            FileUtil.writeUTF8File((String)htmlPath, (String)buffer.toString());
        }
        return bookmarkFileName;
    }

    public void writePublishedBookmarks(List bookmarks, Bookmark defaultView) throws Exception {
        BookmarkList list = new BookmarkList();
        if (defaultView == null && bookmarks.size() > 0) {
            defaultView = (Bookmark)bookmarks.get(0);
        }
        for (Bookmark b : bookmarks) {
            String fileName = this.writeBookmark(b);
            list.addBookmark(b.getPresentationName(), fileName, defaultView == b);
        }
        XmlElement xml = list.getXmlElement();
        String buffer = PublishingUtil.getHtml(xml, BOOKMARKS_XSL_FILE);
        if (buffer != null) {
            String htmlPath = this.getBookmarkHtmlPath(PUBLISHED_BOOKMARKS_CFG_NAME);
            FileUtil.writeUTF8File((String)htmlPath, (String)buffer.toString());
        }
    }

    protected void writeIndexAndTopNavHtml() {
        String htmlPath;
        XmlElement optionXml = this.getOptionXml();
        String buffer = PublishingUtil.getHtml(optionXml, INDEX_XSL_FILE);
        if (buffer != null) {
            htmlPath = this.getIndexFilePath();
            FileUtil.writeUTF8File((String)htmlPath, (String)buffer.toString());
        }
        if ((buffer = PublishingUtil.getHtml(optionXml, TOPNAV_XSL_FILE)) != null) {
            htmlPath = String.valueOf(this.pubDir) + "topnav.htm";
            FileUtil.writeUTF8File((String)htmlPath, (String)buffer.toString());
        }
    }

    protected void writeSearchHtml() {
        XmlElement searchXml;
        String buffer;
        boolean serverSideSearch = this.options == null || this.options.isIncludeServletSearch();
        String webAppName = this.options.getDynamicWebAppName();
        if (webAppName != null && webAppName.length() > 0 && serverSideSearch && (buffer = PublishingUtil.getHtml(searchXml = new XmlElement("Search").setAttribute("webAppName", webAppName), SEARCH_XSL_FILE)) != null) {
            String htmlPath = this.getSearchFilePath();
            FileUtil.writeUTF8File((String)(String.valueOf(htmlPath) + "search.html"), (String)buffer.toString());
        }
    }

    protected String getBookmarkHtmlPath(String boomkarkFile) {
        int indx = boomkarkFile.lastIndexOf(BOOKMARK_SUFFIX_XML);
        return String.valueOf(this.pubDir) + NO_APPLET_DIRECTORY + File.separatorChar + boomkarkFile.substring(0, indx) + BOOKMARK_SUFFIX_HTML;
    }

    public String getIndexFilePath() {
        return String.valueOf(this.pubDir) + "index.htm";
    }

    private String getSearchFilePath() {
        return String.valueOf(this.pubDir) + File.separatorChar + "search" + File.separatorChar;
    }

    protected XmlElement getOptionXml() {
        boolean showGlossary = this.options == null || this.options.isPublishGlossary();
        boolean showIndex = this.options == null || this.options.isPublishIndex();
        XmlElement optionXml = new XmlElement("PublishingOption");
        if (this.options != null) {
            optionXml.setAttribute("title", this.options.getTitle()).setAttribute("bannerImage", this.options.bannerImage).setAttribute("bannerImageHeight", Integer.toString(this.options.getBannerImageHeight())).setAttribute("feedbackUrl", this.options.feedbackURL).setAttribute("showGlossary", showGlossary ? "true" : "false").setAttribute("showIndex", showIndex ? "true" : "false").setAttribute("serverSideSearch", this.options.isIncludeServletSearch() ? "true" : "false");
        }
        return optionXml;
    }

    public void dispose() {
        super.dispose();
    }
}

