/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.ContentResourceScanner;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.TermDefinition;

public class GlossaryList {
    private TreeMap itemMap = new TreeMap();
    private String pubDir;

    public GlossaryList(String pubDir) {
        this.pubDir = pubDir;
    }

    public void clear() {
        this.itemMap.clear();
    }

    public void add(TermDefinition element) {
        String name = TngUtil.getPresentationName((Object)element);
        String group = "" + name.charAt(0);
        this.getItemList(group).add(element);
    }

    private List getItemList(String group) {
        ArrayList l = (ArrayList)this.itemMap.get(group = group.toUpperCase());
        if (l == null) {
            l = new ArrayList();
            this.itemMap.put(group, l);
        }
        return l;
    }

    public StringBuffer getXml() {
        XmlElement xe = new XmlElement("Glossary");
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        xe.setAttribute("lang", lang);
        for (Map.Entry entry : this.itemMap.entrySet()) {
            String group = (String)entry.getKey();
            List items = (List)entry.getValue();
            xe.newChild("item").setAttribute("name", group).setAttribute("presentationName", group).setAttribute("navigation-mark", "true").setAttribute("content", "");
            for (TermDefinition element : items) {
                String name = element.getName();
                String presentationName = TngUtil.getPresentationName((Object)element);
                String content = element.getPresentation().getMainDescription();
                this.scanContentForResources((MethodElement)element, content, ResourceHelper.getElementPath((MethodElement)element));
                content = ResourceHelper.fixContentUrlPath((String)content, (String)ResourceHelper.getElementPath((MethodElement)element), (String)"./../");
                xe.newChild("item").setAttribute("name", name).setAttribute("presentationName", presentationName).setAttribute("content", content);
            }
        }
        return xe.toXml();
    }

    private void scanContentForResources(MethodElement owner, String content, String contentPath) {
        ContentResourceScanner scanner = this.getScanner(owner);
        if (scanner != null) {
            scanner.resolveResources(owner, content, contentPath);
        }
    }

    private ContentResourceScanner getScanner(MethodElement owner) {
        ILibraryResourceManager resMgr = ResourceHelper.getResourceMgr((MethodElement)owner);
        if (resMgr == null) {
            return null;
        }
        String rootContentPath = resMgr.getLogicalPluginPath(owner);
        File src_root = new File(resMgr.getPhysicalPluginPath(owner));
        File tgt_root = new File(this.pubDir, rootContentPath);
        ContentResourceScanner scanner = new ContentResourceScanner(src_root, tgt_root, rootContentPath, null);
        return scanner;
    }
}

