/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.serviceability.DebugTrace;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.layout.Bookmark;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.AbstractPublishManager;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.ConfigurationViewBuilder;
import org.eclipse.epf.publishing.services.DefaultSiteGenerator;
import org.eclipse.epf.publishing.services.GlossaryBuilder;
import org.eclipse.epf.publishing.services.ProcessPublishingContentValidator;
import org.eclipse.epf.publishing.services.ProcessPublishingElementRealizer;
import org.eclipse.epf.publishing.services.PublishingContentValidator;
import org.eclipse.epf.publishing.services.PublishingElementRealizer;
import org.eclipse.epf.publishing.services.index.DefinitionObject;
import org.eclipse.epf.publishing.services.index.KeyWordIndexHelper;
import org.eclipse.epf.publishing.util.PublishingUtil;
import org.eclipse.epf.search.SearchService;

public class PublishManager
extends AbstractPublishManager {
    protected static final String KEYWORD_DEF_FILE = "keywordindexdef.txt";
    protected static final String PUBLISHING_REPORT_XSL_FILE = "xsl/PublishingReport.xsl";
    protected static final String PUBLISHING_REPORT_HTML_FILE = "PublishingReport.html";

    protected AbstractViewBuilder createViewBuilder() {
        PublishingContentValidator validator = null;
        ElementRealizer realizer = null;
        if (this.options != null && this.options.publishProcess) {
            validator = new ProcessPublishingContentValidator(this.pubDir, this.options);
            realizer = ProcessPublishingElementRealizer.newProcessPublishingElementRealizer(this.config, (ProcessPublishingContentValidator)validator);
        } else {
            validator = new PublishingContentValidator(this.pubDir, this.options);
            realizer = PublishingElementRealizer.newPublishingElementRealizer(this.config, validator);
        }
        ElementLayoutManager layoutMgr = new ElementLayoutManager(this.config, this.pubDir, (IContentValidator)validator, true);
        layoutMgr.setElementRealizer(realizer);
        HtmlBuilder builder = new HtmlBuilder(layoutMgr);
        builder.enableContentScan(true);
        builder.enableTreeBrowser(true);
        DefaultSiteGenerator generator = new DefaultSiteGenerator(builder, this.options);
        return new ConfigurationViewBuilder(generator);
    }

    protected void prePublish(IProgressMonitor monitor) throws Exception {
        monitor.subTask(PublishingResources.initializingDirTask_name);
        File f = new File(this.viewBuilder.getHtmlBuilder().getPublishDir());
        if (!f.exists()) {
            f.mkdirs();
        }
        monitor.subTask(PublishingResources.copyingFilesTask_name);
        this.getSiteGenerator().prePublish();
    }

    protected void doPublish(IProgressMonitor monitor) throws Exception {
        String title;
        Collection<Resource> changedResources = this.loadLibrary(monitor);
        Collection existingMgrs = DiagramManager.getDiagramManagers();
        monitor.subTask(PublishingResources.generatingBookmarksTask_name);
        this.generateBookmarks(monitor);
        String string = title = this.options == null ? "" : this.options.getTitle();
        if (!monitor.isCanceled() && (this.options == null || this.options.isPublishGlossary())) {
            monitor.subTask(PublishingResources.generatingGlossaryTask_name);
            new GlossaryBuilder().execute(this.config, this.pubDir, title, monitor);
        }
        Collection newMgrs = DiagramManager.getDiagramManagers();
        PublishingUtil.disposeDiagramManagers(newMgrs, existingMgrs);
        PublishingUtil.unloadResources(changedResources);
        changedResources.clear();
        existingMgrs.clear();
        newMgrs.clear();
        Runtime.getRuntime().gc();
        if (monitor.isCanceled()) {
            return;
        }
        if (this.options == null || this.options.isPublishIndex()) {
            monitor.subTask(PublishingResources.generatingBookmarkIndexTask_name);
            this.generateBookmarkIndex(this.pubDir, title, monitor);
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (this.options != null && this.options.isPublishDynamicWebApp() && this.options.isIncludeServletSearch()) {
            monitor.subTask(PublishingResources.generatingSearchIndexTask_name);
            SearchService.getInstance().createIndex(this.pubDir, false);
        }
    }

    protected void postPublish(IProgressMonitor monitor) throws Exception {
        this.getSiteGenerator().postPublish();
        this.createWARFile();
        this.getPublishReportUrl();
    }

    private void generateBookmarks(IProgressMonitor monitor) throws Exception {
        long beginTime = 0L;
        long startTime = 0L;
        if (profiling) {
            beginTime = startTime = System.currentTimeMillis();
        }
        List<Bookmark> bookmarks = this.viewBuilder.buildViews(monitor);
        if (profiling) {
            DebugTrace.print((Object)this.viewBuilder, (String)"buildViews", (String)(String.valueOf(System.currentTimeMillis() - startTime) + " ms"));
        }
        Bookmark defaultView = this.viewBuilder.getDefaultView();
        if (monitor.isCanceled()) {
            return;
        }
        if (profiling) {
            startTime = System.currentTimeMillis();
        }
        this.getSiteGenerator().writePublishedBookmarks(bookmarks, defaultView);
        if (profiling) {
            DebugTrace.print((Object)this.getSiteGenerator(), (String)"writePublishedBookmarks", (String)(String.valueOf(System.currentTimeMillis() - startTime) + " ms"));
            DebugTrace.print((Object)this, (String)"generateBookmarks", (String)(String.valueOf(System.currentTimeMillis() - beginTime) + " ms"));
        }
    }

    public String getPublishedUrl() {
        String url;
        File f;
        if (this.success && (f = new File(url = this.getSiteGenerator().getIndexFilePath())).exists()) {
            return url;
        }
        return null;
    }

    protected void generateBookmarkIndex(String publishDir, String title, IProgressMonitor monitor) {
        try {
            String helpFile;
            String charSet;
            URL url = new URL(PublishingPlugin.getDefault().getInstallURL(), KEYWORD_DEF_FILE);
            if (url == null) {
                System.out.println("Unable to get index definition file ");
                return;
            }
            String deffile = Platform.resolve((URL)url).getPath();
            KeyWordIndexHelper indexHelper = new KeyWordIndexHelper(deffile, charSet = "utf-8", helpFile = null);
            DefinitionObject defObj = indexHelper.loadDefinition(publishDir);
            if (defObj != null) {
                defObj.setwwwRoot(publishDir);
                defObj.setIndexTitle(String.valueOf(PublishingResources.indexLabel_text) + " - " + title);
            }
            indexHelper.execute(monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPublishReportUrl() {
        String publishDir = this.viewBuilder.getHtmlBuilder().getPublishDir();
        String file_pathname = "logs" + File.separator + PUBLISHING_REPORT_HTML_FILE;
        File f = new File(publishDir, file_pathname);
        String report_file = f.getAbsolutePath();
        if (!f.exists()) {
            File errorLog = new File(publishDir, "logs" + File.separator + "error.log");
            File warningLog = new File(publishDir, "logs" + File.separator + "warning.log");
            File infoLog = new File(publishDir, "logs" + File.separator + "info.log");
            XmlElement reportXml = new XmlElement("PublishingReport");
            reportXml.newChild("pubDir").setAttribute("path", publishDir);
            reportXml.newChild("errorLog").setAttribute("name", "error.log").setAttribute("path", "./" + errorLog.getName());
            reportXml.newChild("warningLog").setAttribute("name", "warning.log").setAttribute("path", "./" + warningLog.getName());
            reportXml.newChild("infoLog").setAttribute("name", "info.log").setAttribute("path", "./" + infoLog.getName());
            PublishingContentValidator validator = (PublishingContentValidator)this.viewBuilder.getHtmlBuilder().getValidator();
            reportXml.addChild(validator.getReport());
            String buffer = PublishingUtil.getHtml(reportXml, PUBLISHING_REPORT_XSL_FILE);
            if (buffer != null) {
                FileUtil.writeUTF8File((String)report_file, (String)buffer.toString());
            }
        }
        return report_file;
    }

    protected void createWARFile() throws Exception {
        if (this.options != null && this.options.isPublishDynamicWebApp() && this.options.getDynamicWebAppName().length() > 0) {
            SearchService.getInstance().createWAR(this.pubDir, this.options.getDynamicWebAppName());
        }
    }

    public void dispose() {
        super.dispose();
    }
}

