/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishingUtil {
    public static void jarFiles(File jarDir, File jarFile) throws IOException {
        File[] files = jarDir.listFiles();
        if (jarFile.exists()) {
            jarFile.delete();
        }
        BufferedOutputStream bStream = new BufferedOutputStream(new FileOutputStream(jarFile));
        ZipOutputStream zipperStream = new ZipOutputStream(bStream);
        byte[] bytes = new byte[4096];
        int i = 0;
        while (i < files.length) {
            File currentFile = files[i];
            if (!currentFile.isDirectory()) {
                ZipEntry currEntry = new ZipEntry(currentFile.getName());
                zipperStream.putNextEntry(currEntry);
                BufferedInputStream biStream = new BufferedInputStream(new FileInputStream(currentFile));
                while (biStream.available() > 0) {
                    int num = biStream.read(bytes);
                    zipperStream.write(bytes, 0, num);
                }
                biStream.close();
                zipperStream.closeEntry();
            }
            ++i;
        }
        zipperStream.close();
        bStream.close();
    }

    public static String getHtml(XmlElement xmlElement, String xslPath) {
        URL url;
        block3: {
            try {
                Locale locale = Locale.getDefault();
                String lang = locale.getLanguage();
                xmlElement.setAttribute("lang", lang);
                url = new URL(PublishingPlugin.getDefault().getInstallURL(), xslPath);
                if (url != null) break block3;
                PublishingPlugin.getDefault().getLogger().logError("Unable to access XSL template " + xslPath);
                return null;
            }
            catch (Exception e) {
                PublishingPlugin.getDefault().getLogger().logError("Unable to generate HTML", (Throwable)e);
                return null;
            }
        }
        String xslURI = FileLocator.resolve((URL)url).getPath();
        StringBuffer xml = new StringBuffer();
        xml.append(XmlHelper.XML_HEADER).append(xmlElement.toXml());
        Properties xslParams = PublishingPlugin.getDefault().getProperties("/xsl/resources.properties");
        StringWriter sw = new StringWriter();
        XSLTProcessor.transform((String)xslURI, (String)xml.toString(), (Properties)xslParams, (Writer)sw);
        sw.flush();
        return ResourceHelper.decodeUrlsInContent((String)sw.getBuffer().toString());
    }

    public static boolean hasValidProcessView(MethodConfiguration config, Process process) {
        for (ContentCategory view : config.getProcessViews()) {
            if (!(view instanceof CustomCategory)) continue;
            CustomCategory cc = (CustomCategory)view;
            for (DescribableElement element : cc.getCategorizedElements()) {
                if (!(element instanceof Process) || ((Process)element).getGuid() != process.getGuid()) continue;
                return true;
            }
        }
        return false;
    }

    public static void unloadResources(Collection<Resource> resources) {
        PersistenceUtil.unload(resources);
    }

    public static void disposeDiagramManagers(Collection<DiagramManager> mgrs, Collection<DiagramManager> keeplist) {
        for (DiagramManager mgr : mgrs) {
            if (keeplist != null && keeplist.contains(mgr)) continue;
            mgr.dispose();
        }
    }
}

