/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui.internal;

import org.eclipse.epf.library.ui.providers.AbstractElementTreeContentProvider;
import org.eclipse.epf.search.ui.internal.MethodSearchResult;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class SearchResultTreeContentProvider
extends AbstractElementTreeContentProvider {
    private static final Object[] EMPTY_LIST = new Object[0];
    private MethodSearchResult searchResult;

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof MethodSearchResult) {
            Object[] elements = ((MethodSearchResult)((Object)inputElement)).getElements();
            if (elements.length == 0) {
                return EMPTY_LIST;
            }
            this.getElementMap().clear();
            int i = 0;
            while (i < elements.length) {
                this.insert(elements[i], false);
                ++i;
            }
            this.insertUIFolders(inputElement);
        }
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null && newInput instanceof MethodSearchResult) {
            this.setTreeViewer((TreeViewer)viewer);
            this.searchResult = (MethodSearchResult)((Object)newInput);
        }
    }

    public void elementsChanged(Object[] updatedElements) {
        int i = 0;
        while (i < updatedElements.length) {
            if (this.searchResult.getMatchCount(updatedElements[i]) > 0) {
                if (this.getTreeViewer().testFindItem(updatedElements[i]) != null) {
                    this.insert(updatedElements[i], true);
                } else {
                    this.remove(updatedElements[i], true);
                }
            } else {
                this.getTreeViewer().remove(updatedElements[i]);
            }
            ++i;
        }
        this.getTreeViewer().refresh();
    }

    protected void remove(Object element, boolean refreshViewer) {
        if (this.hasChildren(element)) {
            if (refreshViewer) {
                this.getTreeViewer().refresh(element);
            }
        } else if (this.searchResult.getMatchCount(element) == 0) {
            this.getElementMap().remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                this.removeFromSiblings(element, parent);
                this.remove(parent, refreshViewer);
            } else {
                this.removeFromSiblings(element, (Object)this.searchResult);
                if (refreshViewer) {
                    this.getTreeViewer().refresh();
                }
            }
        } else if (refreshViewer) {
            this.getTreeViewer().refresh(element);
        }
    }

    public Object getContentSource() {
        return this.searchResult;
    }
}

