/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma.ecore.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValueManager {
    public static final DefaultValueManager INSTANCE = new DefaultValueManager();
    private final Map<EStructuralFeature, Map<EClass, Object>> featureToTypedDefaultValuesMap = new HashMap<EStructuralFeature, Map<EClass, Object>>();
    private final Map<EClass, Map<EStructuralFeature, Object>> typeToFeatureDefaultValueMap = new HashMap<EClass, Map<EStructuralFeature, Object>>();
    private final Map<EStructuralFeature, Map<EClass, Object>> featureToTypedStaticDefaultValuesMap = new HashMap<EStructuralFeature, Map<EClass, Object>>();
    private final Map<EClass, Map<EStructuralFeature, Object>> typeToFeatureStaticDefaultValueMap = new HashMap<EClass, Map<EStructuralFeature, Object>>();
    private volatile boolean useStatic;

    protected DefaultValueManager() {
    }

    public void setUseStatic(boolean useStatic) {
        this.useStatic = useStatic;
    }

    public boolean isUseStatic() {
        return this.useStatic;
    }

    private static Map<EStructuralFeature, Object> getFeatureToDefaultValueMap(EClass type, Map<EStructuralFeature, Map<EClass, Object>> featureToTypedDefaultValuesMap, Map<EStructuralFeature, Object> featureToStaticDefaultValueMap) {
        Map<Object, Object> featureToDefaultValueMap;
        if (featureToTypedDefaultValuesMap.isEmpty()) {
            featureToDefaultValueMap = Collections.EMPTY_MAP;
        } else {
            featureToDefaultValueMap = new HashMap<EStructuralFeature, Object>();
            for (Map.Entry<EStructuralFeature, Map<EClass, Object>> entry : featureToTypedDefaultValuesMap.entrySet()) {
                EStructuralFeature feature = entry.getKey();
                if (type.getFeatureID(feature) == -1) continue;
                Object defaultValue = null;
                EClass selectedType = type;
                boolean found = false;
                for (Map.Entry<EClass, Object> ent : entry.getValue().entrySet()) {
                    EClass currentType = ent.getKey();
                    if (!currentType.isSuperTypeOf(type) || selectedType != null && !selectedType.isSuperTypeOf(currentType)) continue;
                    selectedType = currentType;
                    defaultValue = ent.getValue();
                    found = true;
                }
                if (!found) continue;
                Object staticDefaultValue = featureToStaticDefaultValueMap.get(feature);
                if (staticDefaultValue == null) {
                    staticDefaultValue = feature.getDefaultValue();
                }
                if ((defaultValue != null || staticDefaultValue == null) && (defaultValue == null || defaultValue.equals(staticDefaultValue) && (staticDefaultValue == null || staticDefaultValue.equals(feature.getDefaultValue())))) continue;
                featureToDefaultValueMap.put(feature, defaultValue);
            }
            if (featureToDefaultValueMap.isEmpty()) {
                featureToDefaultValueMap = Collections.EMPTY_MAP;
            }
        }
        return featureToDefaultValueMap;
    }

    public synchronized Map<EStructuralFeature, Object> getFeatureToDefaultValueMap(EClass type) {
        if (this.useStatic) {
            return this.getFeatureToStaticDefaultValueMap(type);
        }
        return this.getFeatureToDynamicDefaultValueMap(type);
    }

    private synchronized Map<EStructuralFeature, Object> getFeatureToDynamicDefaultValueMap(EClass type) {
        Map<EStructuralFeature, Object> featureToDefaultValueMap = this.typeToFeatureDefaultValueMap.get(type);
        if (featureToDefaultValueMap == null) {
            featureToDefaultValueMap = DefaultValueManager.getFeatureToDefaultValueMap(type, this.featureToTypedDefaultValuesMap, this.getFeatureToStaticDefaultValueMap(type));
            this.typeToFeatureDefaultValueMap.put(type, featureToDefaultValueMap);
        }
        return featureToDefaultValueMap;
    }

    private synchronized Map<EStructuralFeature, Object> getFeatureToStaticDefaultValueMap(EClass type) {
        Map<EStructuralFeature, Object> featureToDefaultValueMap = this.typeToFeatureStaticDefaultValueMap.get(type);
        if (featureToDefaultValueMap == null) {
            featureToDefaultValueMap = DefaultValueManager.getFeatureToDefaultValueMap(type, this.featureToTypedStaticDefaultValuesMap, Collections.EMPTY_MAP);
            this.typeToFeatureStaticDefaultValueMap.put(type, featureToDefaultValueMap);
        }
        return featureToDefaultValueMap;
    }

    private static final synchronized void setDefaultValue(EClass type, EStructuralFeature feature, Object defaultValue, Map<EStructuralFeature, Map<EClass, Object>> featureToTypedDefaultValuesMap) {
        if (!feature.getEContainingClass().isSuperTypeOf(type)) {
            return;
        }
        Map<EClass, Object> typeToDefaultValueMap = featureToTypedDefaultValuesMap.get(feature);
        if (typeToDefaultValueMap == null) {
            typeToDefaultValueMap = new HashMap<EClass, Object>();
            featureToTypedDefaultValuesMap.put(feature, typeToDefaultValueMap);
        }
        typeToDefaultValueMap.put(type, defaultValue);
    }

    public final synchronized void setDefaultValue(EClass type, EStructuralFeature feature, Object defaultValue) {
        DefaultValueManager.setDefaultValue(type, feature, defaultValue, this.featureToTypedDefaultValuesMap);
        this.typeToFeatureDefaultValueMap.clear();
    }

    public final synchronized void setStaticDefaultValue(EClass type, EStructuralFeature feature, Object defaultValue) {
        this.setDefaultValue(type, feature, defaultValue);
        DefaultValueManager.setDefaultValue(type, feature, defaultValue, this.featureToTypedStaticDefaultValuesMap);
    }

    public final void removeDefaultValue(EStructuralFeature feature) {
        this.featureToTypedDefaultValuesMap.remove(feature);
    }

    public final void removeDefaultValue(EStructuralFeature feature, EClass type) {
        assert (feature.getEContainingClass().isSuperTypeOf(type));
        Map<EClass, Object> typeToDefaultValueMap = this.featureToTypedDefaultValuesMap.get(feature);
        if (typeToDefaultValueMap != null) {
            typeToDefaultValueMap.remove(type);
        }
        this.typeToFeatureDefaultValueMap.clear();
    }

    private static void assignDefaultValues(EObject eObject, Map<EStructuralFeature, Object> featureToDefaultValueMap) {
        if (featureToDefaultValueMap.isEmpty()) {
            return;
        }
        for (Map.Entry<EStructuralFeature, Object> entry : featureToDefaultValueMap.entrySet()) {
            eObject.eSet(entry.getKey(), entry.getValue());
        }
    }

    public void assignDefaultValues(EObject eObject) {
        EClass type = eObject.eClass();
        Map<EStructuralFeature, Object> featureToStaticDefaultValueMap = this.getFeatureToStaticDefaultValueMap(type);
        DefaultValueManager.assignDefaultValues(eObject, featureToStaticDefaultValueMap);
        Map<EStructuralFeature, Object> featureToDefaultValueMap = this.getFeatureToDefaultValueMap(eObject.eClass());
        if (featureToDefaultValueMap != featureToStaticDefaultValueMap) {
            DefaultValueManager.assignDefaultValues(eObject, featureToDefaultValueMap);
        }
    }
}

