/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.registry.internal;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.equinox.http.registry.internal.DefaultRegistryHttpContext;
import org.eclipse.equinox.http.registry.internal.HttpContextManager;
import org.eclipse.equinox.http.registry.internal.ResourceManager;
import org.eclipse.equinox.http.registry.internal.ServletManager;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.packageadmin.PackageAdmin;

public class HttpRegistryManager {
    private HttpContextManager httpContextManager;
    private ServletManager servletManager;
    private ResourceManager resourceManager;
    private HttpService httpService;
    private PackageAdmin packageAdmin;
    private Map contexts = new HashMap();
    private Map servlets = new HashMap();
    private Map resources = new HashMap();
    private Set registered = new HashSet();

    public HttpRegistryManager(ServiceReference reference, HttpService httpService, PackageAdmin packageAdmin, IExtensionRegistry registry) {
        this.httpService = httpService;
        this.packageAdmin = packageAdmin;
        this.httpContextManager = new HttpContextManager(this, registry);
        this.servletManager = new ServletManager(this, reference, registry);
        this.resourceManager = new ResourceManager(this, reference, registry);
    }

    public void start() {
        this.httpContextManager.start();
        this.servletManager.start();
        this.resourceManager.start();
    }

    public void stop() {
        this.resourceManager.stop();
        this.servletManager.stop();
        this.httpContextManager.stop();
    }

    public synchronized boolean addResourcesContribution(String alias, String baseName, String httpContextId, IContributor contributor) {
        if (this.resources.containsKey(alias) || this.servlets.containsKey(alias)) {
            return false;
        }
        ResourcesContribution contribution = new ResourcesContribution(alias, baseName, httpContextId, contributor);
        this.resources.put(alias, contribution);
        if (httpContextId == null || this.contexts.containsKey(httpContextId)) {
            this.registerResources(contribution);
        }
        return true;
    }

    public synchronized boolean addServletContribution(String alias, Servlet servlet, Dictionary initparams, String httpContextId, IContributor contributor) {
        if (this.resources.containsKey(alias) || this.servlets.containsKey(alias)) {
            return false;
        }
        ServletContribution contribution = new ServletContribution(alias, servlet, initparams, httpContextId, contributor);
        this.servlets.put(alias, contribution);
        if (httpContextId == null || this.contexts.containsKey(httpContextId)) {
            this.registerServlet(contribution);
        }
        return true;
    }

    public synchronized void removeContribution(String alias) {
        this.resources.remove(alias);
        this.servlets.remove(alias);
        this.unregister(alias);
    }

    public synchronized HttpContext getHttpContext(String httpContextId, Bundle bundle) {
        Bundle httpContextBundle;
        AdminPermission resourcePermission;
        HttpContextContribution contribution = (HttpContextContribution)this.contexts.get(httpContextId);
        if (contribution == null) {
            return null;
        }
        if (System.getSecurityManager() != null && !bundle.hasPermission((Object)(resourcePermission = new AdminPermission(httpContextBundle = this.getBundle(contribution.contributor), "resource")))) {
            return null;
        }
        return contribution.context;
    }

    public synchronized boolean addHttpContextContribution(String httpContextId, HttpContext context, IContributor contributor) {
        Object contribution;
        if (this.contexts.containsKey(httpContextId)) {
            return false;
        }
        this.contexts.put(httpContextId, new HttpContextContribution(context, contributor));
        Iterator it = this.resources.values().iterator();
        while (it.hasNext()) {
            contribution = (ResourcesContribution)it.next();
            if (!httpContextId.equals(((ResourcesContribution)contribution).httpContextId)) continue;
            this.registerResources((ResourcesContribution)contribution);
        }
        it = this.servlets.values().iterator();
        while (it.hasNext()) {
            contribution = (ServletContribution)it.next();
            if (!httpContextId.equals(((ServletContribution)contribution).httpContextId)) continue;
            this.registerServlet((ServletContribution)contribution);
        }
        return true;
    }

    public synchronized void removeHttpContextContribution(String httpContextId) {
        if (this.contexts.remove(httpContextId) != null) {
            Object contribution;
            Iterator it = this.resources.values().iterator();
            while (it.hasNext()) {
                contribution = (ResourcesContribution)it.next();
                if (!httpContextId.equals(((ResourcesContribution)contribution).httpContextId)) continue;
                this.unregister(((ResourcesContribution)contribution).alias);
            }
            it = this.servlets.values().iterator();
            while (it.hasNext()) {
                contribution = (ServletContribution)it.next();
                if (!httpContextId.equals(((ServletContribution)contribution).httpContextId)) continue;
                this.unregister(((ServletContribution)contribution).alias);
            }
        }
    }

    public DefaultRegistryHttpContext createDefaultRegistryHttpContext() {
        HttpContext defaultContext = this.httpService.createDefaultHttpContext();
        return new DefaultRegistryHttpContext(defaultContext);
    }

    public Bundle getBundle(IContributor contributor) {
        return this.getBundle(contributor.getName());
    }

    public Bundle getBundle(String symbolicName) {
        Bundle[] bundles = this.packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    private void registerResources(ResourcesContribution contribution) {
        HttpContext context = this.getHttpContext(contribution.httpContextId, contribution.contributor);
        if (context == null) {
            return;
        }
        try {
            this.httpService.registerResources(contribution.alias, contribution.baseName, context);
            this.registered.add(contribution.alias);
        }
        catch (NamespaceException e) {
            e.printStackTrace();
        }
    }

    private void registerServlet(ServletContribution contribution) {
        HttpContext context = this.getHttpContext(contribution.httpContextId, contribution.contributor);
        if (context == null) {
            return;
        }
        try {
            this.httpService.registerServlet(contribution.alias, contribution.servlet, contribution.initparams, context);
            this.registered.add(contribution.alias);
        }
        catch (NamespaceException e) {
            e.printStackTrace();
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
    }

    private void unregister(String alias) {
        if (this.registered.remove(alias)) {
            this.httpService.unregister(alias);
        }
    }

    private HttpContext getHttpContext(String httpContextId, IContributor contributor) {
        Bundle httpContextBundle;
        AdminPermission resourcePermission;
        Bundle contributorBundle;
        if (httpContextId == null) {
            DefaultRegistryHttpContext defaultContext = this.createDefaultRegistryHttpContext();
            defaultContext.addResourceMapping(this.getBundle(contributor), null);
            return defaultContext;
        }
        HttpContextContribution contribution = (HttpContextContribution)this.contexts.get(httpContextId);
        if (System.getSecurityManager() != null && !(contributorBundle = this.getBundle(contributor)).hasPermission((Object)(resourcePermission = new AdminPermission(httpContextBundle = this.getBundle(contribution.contributor), "resource")))) {
            return null;
        }
        return contribution.context;
    }

    class HttpContextContribution {
        HttpContext context;
        IContributor contributor;

        public HttpContextContribution(HttpContext context, IContributor contributor) {
            this.context = context;
            this.contributor = contributor;
        }
    }

    class ResourcesContribution {
        String alias;
        String baseName;
        String httpContextId;
        IContributor contributor;

        public ResourcesContribution(String alias, String baseName, String httpContextId, IContributor contributor) {
            this.alias = alias;
            this.baseName = baseName;
            this.httpContextId = httpContextId;
            this.contributor = contributor;
        }
    }

    class ServletContribution {
        String alias;
        Servlet servlet;
        Dictionary initparams;
        String httpContextId;
        IContributor contributor;

        public ServletContribution(String alias, Servlet servlet, Dictionary initparams, String httpContextId, IContributor contributor) {
            this.alias = alias;
            this.servlet = servlet;
            this.initparams = initparams;
            this.httpContextId = httpContextId;
            this.contributor = contributor;
        }
    }
}

