/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import com.ibm.icu.util.Calendar;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.epf.common.service.versioning.VersionUtil;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.common.utils.ExtensionHelper;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.export.services.PluginExportService;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigSpecsImportManager;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.services.ElementDiffTree;
import org.eclipse.epf.importing.services.LibraryDiffManager;
import org.eclipse.epf.importing.services.LibraryImportManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.project.MethodLibraryProject;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.util.ConvertGuidanceType;
import org.eclipse.epf.library.ui.util.TypeConverter;
import org.eclipse.epf.library.ui.wizards.OpenLibraryWizard;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ConfigurationImportService {
    private boolean localDebug = false;
    private UpgradeCallerInfo upGradeInfo;
    private ConfigurationImportData data;
    LibraryDocument importingLibDoc = null;
    LibraryDiffManager diffMgr = null;
    ConfigSpecsImportManager specsMgr = null;

    public ConfigurationImportService(ConfigurationImportData data) {
        this.data = data;
    }

    public static ConfigurationImportService newInstance(ConfigurationImportData data) {
        Object obj = ExtensionHelper.create(ConfigurationImportService.class, (Object)data);
        if (obj instanceof ConfigurationImportService) {
            return (ConfigurationImportService)obj;
        }
        return new ConfigurationImportService(data);
    }

    protected LibraryDocument getImportingLibDoc() {
        return this.importingLibDoc;
    }

    public void analyze(IProgressMonitor monitor) {
        block18: {
            try {
                if (monitor != null) {
                    monitor.setTaskName(ImportResources.ConfigurationImportService_MSG0);
                }
                this.data.getErrorInfo().clear();
                String path = this.data.llData.getParentFolder();
                if (path.indexOf(String.valueOf(File.separator) + "library.xmi") < 0) {
                    path = String.valueOf(path) + File.separator + "library.xmi";
                }
                File importingLibPath = new File(path);
                boolean isLibraryFile = true;
                if (!importingLibPath.exists()) {
                    importingLibPath = new File(importingLibPath.getParentFile(), "export.xmi");
                    isLibraryFile = false;
                }
                if (!importingLibPath.exists()) {
                    this.data.getErrorInfo().addError(NLS.bind((String)ImportResources.ConfigurationImportService_MSG1, (Object)importingLibPath.getParent()));
                    return;
                }
                boolean handleVersion = isLibraryFile;
                if (handleVersion) {
                    this.upGradeInfo = new UpgradeInfo(UpgradeCallerInfo.upgradeImportConfig, importingLibPath);
                    if (!ConfigurationImportService.handleToolVersion(importingLibPath, this.upGradeInfo)) {
                        String errMsg = this.upGradeInfo.getErrorMsg();
                        if (errMsg == null || errMsg.length() == 0) {
                            errMsg = ImportResources.ImportConfigurationWizard_ERR_Import_configuration;
                        }
                        this.data.getErrorInfo().addError(NLS.bind((String)errMsg, (Object)importingLibPath.getParent()));
                        return;
                    }
                    if (this.upGradeInfo.getCopiedLibFile() != null) {
                        importingLibPath = this.upGradeInfo.getCopiedLibFile();
                    }
                }
                this.importingLibDoc = new LibraryDocument(importingLibPath);
                boolean isConfigSpecs = this.importingLibDoc.isConfigSpecsOnly();
                if (isConfigSpecs) {
                    this.specsMgr = new ConfigSpecsImportManager();
                    this.data.specs = this.specsMgr.getConfigSpecs(this.importingLibDoc);
                    break block18;
                }
                if (!isLibraryFile) {
                    this.data.getErrorInfo().addError(NLS.bind((String)ImportResources.ConfigurationImportService_MSG1, (Object)importingLibPath.getParent()));
                    return;
                }
                this.data.specs = null;
                String libDir = importingLibPath.getParentFile().getAbsolutePath();
                String projectName = "Configuration Import Project (" + Integer.toHexString(libDir.hashCode()) + ")";
                MethodLibraryProject.openProject((String)libDir, (String)projectName, (IProgressMonitor)monitor);
                try {
                    MethodLibrary importLibraty = LibraryUtil.loadLibrary((String)importingLibPath.getAbsolutePath());
                    MethodLibrary baseLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
                    this.handleTypeChanges(baseLibrary, importLibraty);
                    String baseLibDir = null;
                    try {
                        File bFile = new File(baseLibrary.eResource().getURI().toFileString()).getParentFile();
                        baseLibDir = bFile.getAbsolutePath();
                    }
                    catch (Throwable throwable) {}
                    if (libDir.equalsIgnoreCase(baseLibDir)) {
                        this.data.getErrorInfo().addError(NLS.bind((String)ImportResources.ConfigurationImportService_MSG2, (Object)importingLibPath.getParent()));
                        return;
                    }
                    ConfigurationImportService.fixImportLibrarySystemPackageGUIDs(baseLibrary, importLibraty);
                    this.diffMgr = new LibraryDiffManager(baseLibrary, importLibraty);
                    this.diffMgr.buildDiffTree();
                    if (this.localDebug) {
                        this.diffMgr.rootDiffTree.debugDump();
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                MethodLibraryProject.closeProject((String)libDir, (IProgressMonitor)monitor);
                MethodLibraryProject.deleteProject((String)libDir, (IProgressMonitor)monitor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public ConfigurationImportData getImportData() {
        return this.data;
    }

    public boolean isSpecsOnly() {
        return this.data.specs != null;
    }

    public ElementDiffTree getDiffTree() {
        return this.diffMgr.getDiffTree();
    }

    public MethodLibrary getImportingLibrary() {
        return this.diffMgr.getImportingLibrary();
    }

    public void performImport(IProgressMonitor monitor) {
        block17: {
            boolean refresh = RefreshJob.getInstance().isEnabled();
            if (refresh) {
                RefreshJob.getInstance().setEnabled(false);
            }
            try {
                try {
                    if (monitor != null) {
                        monitor.setTaskName(ImportResources.ConfigurationImportService_MSG3);
                    }
                    if (this.isSpecsOnly()) {
                        this.specsMgr.doImport(this.data.specs);
                    } else {
                        LibraryImportManager importingMgr = new LibraryImportManager(this.diffMgr, this.data.importList);
                        importingMgr.doMerge(this.data.replaceExisting, monitor);
                    }
                    MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
                    ResourceUtil.refreshResources((MethodLibrary)lib, (IProgressMonitor)monitor);
                }
                catch (Exception e) {
                    ImportPlugin.getDefault().getLogger().logError((Throwable)e);
                    if (refresh) {
                        RefreshJob.getInstance().setEnabled(true);
                    }
                    if (this.upGradeInfo != null) {
                        this.upGradeInfo.removeCopiedLibrary();
                        this.upGradeInfo = null;
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (refresh) {
                    RefreshJob.getInstance().setEnabled(true);
                }
                if (this.upGradeInfo != null) {
                    this.upGradeInfo.removeCopiedLibrary();
                    this.upGradeInfo = null;
                }
                throw throwable;
            }
            if (refresh) {
                RefreshJob.getInstance().setEnabled(true);
            }
            if (this.upGradeInfo != null) {
                this.upGradeInfo.removeCopiedLibrary();
                this.upGradeInfo = null;
            }
        }
        try {
            this.postImportOperation();
        }
        catch (Exception e) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    protected void postImportOperation() throws Exception {
        LibraryService.getInstance().reopenCurrentMethodLibrary();
    }

    public static String versionCheck(final String xmlPath, final String title) {
        final String[] ret = new String[]{null};
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                VersionUtil.VersionCheckInfo info = VersionUtil.checkLibraryVersion((File)new File(xmlPath));
                if (info == null) {
                    ret[0] = NLS.bind((String)ImportResources.versionMismatch_oldData_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                } else if (info.result < 0) {
                    ret[0] = info.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)ImportResources.versionMismatch_oldData, (Object[])new Object[]{info.toolVersion, Platform.getProduct().getName()}) : NLS.bind((String)ImportResources.versionMismatch_oldData_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                } else if (info.result > 0) {
                    ret[0] = info.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)ImportResources.versionMismatch_oldTool, (Object[])new Object[]{info.toolVersion, Platform.getProduct().getName()}) : NLS.bind((String)ImportResources.versionMismatch_oldTool_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                }
                if (ret[0] != null) {
                    ImportPlugin.getDefault().getMsgDialog().displayError(title, ret[0]);
                }
            }
        });
        return ret[0];
    }

    public static void fixImportLibrarySystemPackageGUIDs(MethodLibrary baseLibrary, MethodLibrary importLibraty) {
        HashMap<String, MethodPlugin> pluginsMap = new HashMap<String, MethodPlugin>();
        List plugins = baseLibrary.getMethodPlugins();
        int i = 0;
        while (i < plugins.size()) {
            MethodPlugin plugin = (MethodPlugin)plugins.get(i);
            pluginsMap.put(plugin.getGuid(), plugin);
            ++i;
        }
        if (pluginsMap.isEmpty()) {
            return;
        }
        ArrayList<MethodPlugin> importPluginsToFix = new ArrayList<MethodPlugin>();
        List importPlugins = importLibraty.getMethodPlugins();
        int i2 = 0;
        while (i2 < importPlugins.size()) {
            MethodPlugin plugin = (MethodPlugin)importPlugins.get(i2);
            if (pluginsMap.containsKey(plugin.getGuid())) {
                importPluginsToFix.add(plugin);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < importPluginsToFix.size()) {
            MethodPlugin importPlugin = (MethodPlugin)importPluginsToFix.get(i2);
            MethodPlugin basePlugin = (MethodPlugin)pluginsMap.get(importPlugin.getGuid());
            if (basePlugin != null) {
                List importPackages = TngUtil.getAllSystemPackages((MethodPlugin)importPlugin);
                HashMap<String, MethodElement> importPackageMap = new HashMap<String, MethodElement>();
                int j = 0;
                while (j < importPackages.size()) {
                    MethodElement importPackage = (MethodElement)importPackages.get(j);
                    importPackageMap.put(importPackage.getName(), importPackage);
                    ++j;
                }
                List basePackages = TngUtil.getAllSystemPackages((MethodPlugin)basePlugin);
                int j2 = 0;
                while (j2 < basePackages.size()) {
                    MethodElement basePackage = (MethodElement)basePackages.get(j2);
                    MethodElement importPackage = (MethodElement)importPackageMap.get(basePackage.getName());
                    if (importPackage != null) {
                        String guid = basePackage.getGuid();
                        if (!importPackage.getGuid().equals(guid)) {
                            importPackage.setGuid(guid);
                        }
                    }
                    ++j2;
                }
            }
            ++i2;
        }
    }

    private void handleTypeChanges(MethodLibrary baseLib, MethodLibrary importLib) {
        HashMap baseMap = new HashMap();
        ConfigurationImportService.collectPotentialTypeChanged(baseLib, baseMap);
        HashMap importMap = new HashMap();
        ConfigurationImportService.collectPotentialTypeChanged(importLib, importMap);
        ConfigurationImportService.handleTypeChanges(baseMap, importMap);
    }

    public static void handleTypeChanges(HashMap baseMap, HashMap importMap) {
        ArrayList<MethodElement[]> toChangeList = new ArrayList<MethodElement[]>();
        for (Map.Entry entry : importMap.entrySet()) {
            MethodElement elem;
            Object guid = entry.getKey();
            MethodElement baseElem = (MethodElement)baseMap.get(guid);
            if (baseElem == null || (elem = (MethodElement)entry.getValue()).eClass().equals(baseElem.eClass())) continue;
            MethodElement[] elemPair = new MethodElement[]{baseElem, elem};
            toChangeList.add(elemPair);
        }
        int i = 0;
        while (i < toChangeList.size()) {
            MethodElement[] elemPair = (MethodElement[])toChangeList.get(i);
            final MethodElement baseElem = elemPair[0];
            final MethodElement importElem = elemPair[1];
            if (baseElem instanceof Guidance) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ConvertGuidanceType.convertGuidance((Guidance)((Guidance)baseElem), (Shell)MsgBox.getDefaultShell(), null, (EClass)importElem.eClass());
                    }
                });
            } else if (baseElem instanceof Activity) {
                TypeConverter.convertActivity((Activity)((Activity)baseElem), (EClass)importElem.eClass());
            }
            ++i;
        }
    }

    public static void collectPotentialTypeChanged(MethodLibrary lib, HashMap map) {
        TreeIterator it = lib.eAllContents();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof Guidance) && !(obj instanceof Activity)) continue;
            MethodElement elem = (MethodElement)obj;
            map.put(elem.getGuid(), elem);
        }
    }

    public static boolean handleToolVersion(File libFile, final UpgradeCallerInfo info) {
        final String libFolderPath = libFile.getParentFile().getAbsolutePath();
        final boolean[] ret = new boolean[1];
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                ret[0] = OpenLibraryWizard.handleToolVersion((String)libFolderPath, (UpgradeCallerInfo)info);
            }
        });
        return ret[0];
    }

    public static class UpgradeInfo
    extends UpgradeCallerInfo {
        public UpgradeInfo(int callerType, File libFile) {
            super(callerType, libFile);
        }

        public void copyLibrary() {
            String userHome = System.getProperty("user.home");
            String desLibFolderPath = String.valueOf(userHome) + File.separator + "EPF" + File.separator + "Export" + File.separator + Long.toHexString(Calendar.getInstance().getTimeInMillis()) + File.separator;
            File desLibFolder = new File(desLibFolderPath);
            if (!desLibFolder.exists()) {
                desLibFolder.mkdirs();
            } else {
                FileUtil.deleteAllFiles((String)desLibFolder.getAbsolutePath());
            }
            PluginExportService.copyDir((File)this.getLibFile().getParentFile(), (File)desLibFolder);
            this.setCopiedLibFile(new File(String.valueOf(desLibFolderPath) + this.getLibFile().getName()));
        }

        public void removeCopiedLibrary() {
            if (this.getCopiedLibFile() == null) {
                return;
            }
            FileUtil.deleteAllFiles((String)this.getCopiedLibFile().getParentFile().getAbsolutePath());
            this.getCopiedLibFile().getParentFile().delete();
            this.setCopiedLibFile(null);
        }
    }
}

