/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.util.List;
import org.eclipse.epf.common.ui.util.PreferenceUtil;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportUIPreferences {
    private static final String IMPORT_PLUGIN_DIRS = "importPluginDirs";
    private static final String IMPORT_CONFIG_DIRS = "importConfigDirs";
    public static final String CHECK_BASE_PLUGINS = "checkBasePlugins";
    private static final String DEFAULT_IMPORT_PLUGIN_DIR_NAME = "Export" + FileUtil.FILE_SEP + "Plugins";
    private static final String DEFAULT_IMPORT_CONFIG_DIR_NAME = "Export" + FileUtil.FILE_SEP + "Configurations";
    private static String defaultImportPluginDir = null;
    private static String defaultImportConfigDir = null;
    private static IPreferenceStore prefStore = ImportPlugin.getDefault().getPreferenceStore();

    static {
        prefStore.setDefault(IMPORT_PLUGIN_DIRS, ImportUIPreferences.getDefaultImportPluginDir());
        prefStore.setDefault(IMPORT_CONFIG_DIRS, ImportUIPreferences.getDefaultImportConfigDir());
        prefStore.setDefault(CHECK_BASE_PLUGINS, true);
    }

    public static String getDefaultImportPluginDir() {
        if (defaultImportPluginDir == null) {
            defaultImportPluginDir = System.getProperty("user.home");
            String appName = LibraryUIPreferences.getApplicationShortName();
            defaultImportPluginDir = appName != null && appName.length() > 0 ? String.valueOf(defaultImportPluginDir) + FileUtil.FILE_SEP + appName + FileUtil.FILE_SEP + DEFAULT_IMPORT_PLUGIN_DIR_NAME : String.valueOf(defaultImportPluginDir) + FileUtil.FILE_SEP + DEFAULT_IMPORT_PLUGIN_DIR_NAME;
        }
        return defaultImportPluginDir;
    }

    public static String[] getImportPluginDirs() {
        return PreferenceUtil.getStringValues((IPreferenceStore)prefStore, (String)IMPORT_PLUGIN_DIRS);
    }

    public static List<String> getImportPluginDirsList() {
        return PreferenceUtil.getList((IPreferenceStore)prefStore, (String)IMPORT_PLUGIN_DIRS);
    }

    public static void addImportPluginDir(String dir) {
        PreferenceUtil.addToList((IPreferenceStore)prefStore, (String)IMPORT_PLUGIN_DIRS, (String)dir);
    }

    public static String getDefaultImportConfigDir() {
        if (defaultImportConfigDir == null) {
            defaultImportConfigDir = System.getProperty("user.home");
            String appName = LibraryUIPreferences.getApplicationShortName();
            defaultImportConfigDir = appName != null && appName.length() > 0 ? String.valueOf(defaultImportConfigDir) + FileUtil.FILE_SEP + appName + FileUtil.FILE_SEP + DEFAULT_IMPORT_CONFIG_DIR_NAME : String.valueOf(defaultImportConfigDir) + FileUtil.FILE_SEP + DEFAULT_IMPORT_CONFIG_DIR_NAME;
        }
        return defaultImportConfigDir;
    }

    public static String[] getImportConfigDirs() {
        return PreferenceUtil.getStringValues((IPreferenceStore)prefStore, (String)IMPORT_CONFIG_DIRS);
    }

    public static List<String> getImportConfigDirsList() {
        return PreferenceUtil.getList((IPreferenceStore)prefStore, (String)IMPORT_CONFIG_DIRS);
    }

    public static void addImportConfigDir(String dir) {
        PreferenceUtil.addToList((IPreferenceStore)prefStore, (String)IMPORT_CONFIG_DIRS, (String)dir);
    }

    public static boolean getCheckBasePlugins() {
        return prefStore.getBoolean(CHECK_BASE_PLUGINS);
    }

    public static void setCheckBasePlugins(boolean value) {
        prefStore.setValue(CHECK_BASE_PLUGINS, value);
    }
}

