/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.epf.common.preferences.IPreferenceStoreWrapper;
import org.eclipse.epf.common.preferences.IPropertyChangeEventWrapper;
import org.eclipse.epf.common.preferences.IPropertyChangeListenerWrapper;
import org.eclipse.epf.common.serviceability.DebugTrace;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.InvalidMethodElementNameException;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceException;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.preferences.LibraryPreferences;
import org.eclipse.epf.library.project.MethodLibraryProject;
import org.eclipse.epf.library.services.LibraryModificationHelper;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.persistence.refresh.IRefreshEvent;
import org.eclipse.epf.persistence.refresh.IRefreshListener;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.LibrarySchedulingRule;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.ui.IPropertyListener;

public abstract class AbstractLibraryManager
implements ILibraryManager {
    public static final int PROP_DIRTY = 1;
    public static final String ARG_LIBRARY_NAME = "library.name";
    public static final String ARG_LIBRARY_REGISTER_TYPE = "libraryRegisterType";
    protected static boolean debug = LibraryPlugin.getDefault().isDebugging();
    protected MethodLibrary library;
    protected AdapterFactoryEditingDomain editingDomain;
    private List libraryChangedListeners = new ArrayList();
    private ListenerList resourceChangeListeners = new ListenerList();
    private Map saveOptions;
    protected boolean skipEventProcessing = false;
    private CommandStackListener commandStackListener = new CommandStackListener(){

        public void commandStackChanged(final EventObject event) {
            if (debug) {
                DebugTrace.print((Object)this, (String)"commandStackChanged", (String)("event=" + event));
            }
            if (!AbstractLibraryManager.this.skipEventProcessing) {
                SafeUpdateController.asyncExec(new Runnable(){

                    public void run() {
                        Command mostRecentCommand = LibraryUtil.unwrap(((CommandStack)event.getSource()).getMostRecentCommand());
                        if (mostRecentCommand != null) {
                            if (mostRecentCommand instanceof AddCommand) {
                                AddCommand cmd = (AddCommand)mostRecentCommand;
                                EObject owner = cmd.getOwner();
                                Collection objs = new ArrayList<EObject>();
                                objs.add(owner);
                                AbstractLibraryManager.this.notifyListeners(8, objs);
                                if (!(owner instanceof MethodConfiguration)) {
                                    objs = mostRecentCommand.getResult();
                                    if (owner instanceof MethodPackage && !(objs = LibraryUtil.getContainedElements(owner, objs)).isEmpty()) {
                                        AbstractLibraryManager.this.addNewPackagesToConfiguration(objs);
                                    }
                                    AbstractLibraryManager.this.notifyListeners(32, objs);
                                }
                            } else if (mostRecentCommand instanceof PasteFromClipboardCommand) {
                                Collection objs = mostRecentCommand.getResult();
                                AbstractLibraryManager.this.notifyListeners(32, objs);
                                PasteFromClipboardCommand cmd = (PasteFromClipboardCommand)mostRecentCommand;
                                if (cmd.getOwner() instanceof MethodPackage && !(objs = LibraryUtil.getContainedElements(cmd.getOwner(), objs)).isEmpty()) {
                                    AbstractLibraryManager.this.addNewPackagesToConfiguration(objs);
                                }
                            } else if (mostRecentCommand instanceof CreateChildCommand) {
                                AbstractLibraryManager.this.notifyListeners(32, mostRecentCommand.getAffectedObjects());
                            } else if (mostRecentCommand != null) {
                                AbstractLibraryManager.this.notifyListeners(8, mostRecentCommand.getAffectedObjects());
                            }
                        }
                    }
                });
            }
        }
    };
    private INotifyChangedListener notifyChangedListener = new INotifyChangedListener(){

        public void notifyChanged(Notification notification) {
            if (debug) {
                DebugTrace.print((Object)this, (String)"notifyChanged", (String)("notification=" + notification));
            }
            if (!AbstractLibraryManager.this.skipEventProcessing) {
                int eventType = notification.getEventType();
                switch (eventType) {
                    case 3: {
                        Object notifier = notification.getNotifier();
                        Object value = notification.getNewValue();
                        if (!(notifier instanceof MethodLibrary) || !(value instanceof MethodPlugin)) break;
                        ArrayList<Object> affectedObjects = new ArrayList<Object>();
                        affectedObjects.add(value);
                        AbstractLibraryManager.this.notifyListeners(32, affectedObjects);
                        break;
                    }
                    case 1: {
                        Object notifier = notification.getNotifier();
                        if (notifier == null) break;
                        ArrayList<Object> affectedObjects = new ArrayList<Object>();
                        affectedObjects.add(notifier);
                        AbstractLibraryManager.this.notifyListeners(8, affectedObjects);
                        break;
                    }
                    case 4: {
                        Object notifier = notification.getNotifier();
                        Object oldValue = notification.getOldValue();
                        ArrayList<Object> affectedObjects = new ArrayList<Object>();
                        if (oldValue instanceof EObject && ((EObject)oldValue).eContainer() == null) {
                            affectedObjects.add(oldValue);
                            AbstractLibraryManager.this.notifyListeners(16, affectedObjects);
                            break;
                        }
                        affectedObjects.add(notifier);
                        AbstractLibraryManager.this.notifyListeners(8, affectedObjects);
                        break;
                    }
                    case 6: {
                        ArrayList oldValue = new ArrayList((Collection)notification.getOldValue());
                        ArrayList deletedElements = new ArrayList();
                        ArrayList removedReferences = new ArrayList();
                        if (!oldValue.isEmpty()) {
                            for (Object element : oldValue) {
                                if (!(element instanceof EObject)) continue;
                                if (((EObject)element).eContainer() == null) {
                                    deletedElements.add(element);
                                    continue;
                                }
                                removedReferences.add(element);
                            }
                        }
                        if (!deletedElements.isEmpty()) {
                            AbstractLibraryManager.this.notifyListeners(16, deletedElements);
                        }
                        if (removedReferences.isEmpty()) break;
                        AbstractLibraryManager.this.notifyListeners(8, removedReferences);
                    }
                }
            }
        }
    };
    private Adapter resourceChangedListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (debug) {
                DebugTrace.print((Object)((Object)this), (String)"notifyChanged", (String)("msg=" + msg));
            }
            if (msg.getFeatureID(null) == 3 && msg.getEventType() == 1) {
                AbstractLibraryManager.this.firePropertyChange(msg.getNotifier(), 1);
            }
        }
    };
    private IRefreshListener refreshListener = new IRefreshListener(){

        public void notifyRefreshed(IRefreshEvent event) {
            if (debug) {
                DebugTrace.print((Object)this, (String)"notifyRefreshed", (String)("event=" + event));
            }
            AbstractLibraryManager.this.handleRefreshEvent(event);
        }
    };
    private IPropertyChangeListenerWrapper preferenceStoreChangeListener = new IPropertyChangeListenerWrapper(){

        public void propertyChange(IPropertyChangeEventWrapper event) {
            if (event.getProperty().equals("discardUnresolvedReferences")) {
                AbstractLibraryManager.this.saveOptions.put("DISCARD_UNRESOLVED_REFERENCES", event.getNewValue());
            }
        }
    };

    public AbstractLibraryManager() {
        this.init();
    }

    protected void init() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"init");
        }
        LibraryPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferenceStoreChangeListener);
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        ILibraryResourceSet resourceSet = this.createResourceSet();
        resourceSet.addRefreshListener(this.refreshListener);
        RefreshJob.getInstance().setResourceSet((ResourceSet)resourceSet);
        this.saveOptions = resourceSet.getDefaultSaveOptions();
        this.saveOptions.put("DISCARD_UNRESOLVED_REFERENCES", LibraryPreferences.getDiscardUnresolvedReferences());
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, (ResourceSet)resourceSet);
        this.registerEditingDomain(this.editingDomain);
    }

    public void saveMethodLibrary() throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)this, (String)"saveMethodLibrary");
        }
        try {
            try {
                if (this.library != null) {
                    this.skipEventProcessing = true;
                    ILibraryResourceSet resourceSet = (ILibraryResourceSet)this.editingDomain.getResourceSet();
                    resourceSet.save(this.saveOptions);
                    ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
                    this.skipEventProcessing = false;
                    this.firePropertyChange(this.library, 1);
                }
            }
            catch (Exception e) {
                throw new LibraryServiceException(e);
            }
        }
        finally {
            this.skipEventProcessing = false;
        }
    }

    public void discardMethodLibraryChanges() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"discardMethodLibraryChanges");
        }
        for (Resource resource : this.getEditingDomain().getResourceSet().getResources()) {
            resource.setModified(false);
        }
    }

    public void closeMethodLibrary() throws LibraryServiceException {
        if (debug) {
            String msg = "library=" + this.library + ", memory on entry=" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
            DebugTrace.print((Object)this, (String)"closeMethodLibrary", (String)msg);
        }
        File libFile = new File(this.library.eResource().getURI().toFileString());
        String libPath = libFile.getParentFile().getAbsolutePath();
        LibraryService.getInstance().removeConfigurationManagers(this.library);
        this.removeResourceChangedListeners();
        LayoutResources.clear();
        Suppression.clearCachedSuppressions();
        TngUtil.umaItemProviderAdapterFactory.dispose();
        ILibraryResourceSet resourceSet = (ILibraryResourceSet)this.editingDomain.getResourceSet();
        resourceSet.unload();
        try {
            MethodLibraryProject.closeProject(libPath, null);
        }
        catch (Exception e) {
            throw new LibraryServiceException(e);
        }
        RefreshJob.getInstance().reset();
        Runtime.getRuntime().gc();
        if (debug) {
            String msg = "library=" + this.library + ", memory on exit=" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
            DebugTrace.print((Object)this, (String)"closeMethodLibrary", (String)msg);
        }
    }

    public MethodLibrary getMethodLibrary() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"getMethodLibrary", (String)("library=" + this.library));
        }
        return this.library;
    }

    public void setMethodLibrary(MethodLibrary library) {
        Resource resource;
        if (debug) {
            DebugTrace.print((Object)this, (String)"setMethodLibrary", (String)("library=" + library));
        }
        if (this.library != null && (resource = this.library.eResource()) != null) {
            resource.getContents().clear();
            resource.getContents().add((Object)library);
        }
        this.library = library;
    }

    public ComposedAdapterFactory getAdapterFactory() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"getAdapterFactory");
        }
        return (ComposedAdapterFactory)this.getEditingDomain().getAdapterFactory();
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"getEditingDomain", (String)("editingDomain=" + this.editingDomain));
        }
        return this.editingDomain;
    }

    public void registerEditingDomain(AdapterFactoryEditingDomain domain) {
        AdapterFactory adapterFactory;
        if (debug) {
            DebugTrace.print((Object)this, (String)"registerEditingDomain", (String)("domain=" + domain));
        }
        if ((adapterFactory = domain.getAdapterFactory()) instanceof ComposedAdapterFactory) {
            ComposedAdapterFactory composedAdapterFactory = (ComposedAdapterFactory)adapterFactory;
            composedAdapterFactory.removeListener(this.notifyChangedListener);
            composedAdapterFactory.addListener(this.notifyChangedListener);
        }
        domain.getCommandStack().removeCommandStackListener(this.commandStackListener);
        domain.getCommandStack().addCommandStackListener(this.commandStackListener);
    }

    public void unregisterEditingDomain(AdapterFactoryEditingDomain domain) {
        AdapterFactory adapterFactory = domain.getAdapterFactory();
        if (adapterFactory instanceof ComposedAdapterFactory) {
            ComposedAdapterFactory composedAdapterFactory = (ComposedAdapterFactory)adapterFactory;
            composedAdapterFactory.removeListener(this.notifyChangedListener);
        }
        domain.getCommandStack().removeCommandStackListener(this.commandStackListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ILibraryChangeListener listener) {
        List list = this.libraryChangedListeners;
        synchronized (list) {
            if (debug) {
                DebugTrace.print((Object)this, (String)"addListener", (String)("listener=" + listener));
            }
            if (!this.libraryChangedListeners.contains(listener)) {
                this.libraryChangedListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeListener(ILibraryChangeListener listener) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"removeListener", (String)("listener=" + listener));
        }
        if (listener != null) {
            List list = this.libraryChangedListeners;
            synchronized (list) {
                this.libraryChangedListeners.remove(listener);
            }
        }
    }

    public void addPropertyListener(IPropertyListener listener) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"addPropertyListener", (String)("listener=" + listener));
        }
        this.resourceChangeListeners.add((Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"removePropertyListener", (String)("listener=" + listener));
        }
        this.resourceChangeListeners.remove((Object)listener);
    }

    public void startListeningTo(CommandStack commandStack) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"startListeningTo", (String)("commandStack=" + commandStack));
        }
        commandStack.addCommandStackListener(this.commandStackListener);
    }

    public void stopListeningTo(CommandStack commandStack) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"stopListeningTo", (String)("commandStack=" + commandStack));
        }
        commandStack.removeCommandStackListener(this.commandStackListener);
    }

    public void startListeningTo(ComposedAdapterFactory adapterFactory) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"startListeningTo", (String)("adapterFactory=" + adapterFactory));
        }
        adapterFactory.addListener(this.notifyChangedListener);
    }

    public void stopListeningTo(ComposedAdapterFactory adapterFactory) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"stopListeningTo", (String)("adapterFactory=" + adapterFactory));
        }
        adapterFactory.removeListener(this.notifyChangedListener);
    }

    public MethodElement getMethodElement(String guid) {
        try {
            ILibraryResourceSet resourceSet = (ILibraryResourceSet)this.library.eResource().getResourceSet();
            if (resourceSet != null) {
                return (MethodElement)resourceSet.getEObject(guid);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        return null;
    }

    public URI getElementRelativeURI(MethodElement element) {
        Resource resource;
        if (debug) {
            DebugTrace.print((Object)this, (String)"getElementRelativeURI", (String)("element=" + element));
        }
        if (element != null && (resource = this.library.eResource()) != null) {
            URI libraryURI = resource.getURI();
            URI elementURI = element.eResource().getURI();
            return elementURI.deresolve(libraryURI);
        }
        return null;
    }

    public boolean isMethodLibraryReadOnly() {
        URI libraryURI;
        if (debug) {
            DebugTrace.print((Object)this, (String)"isMethodLibraryReadOnly");
        }
        if ((libraryURI = this.library.eResource().getURI()).isFile()) {
            File libraryXMIFile = new File(libraryURI.toFileString());
            return libraryXMIFile.exists() && !libraryXMIFile.canWrite();
        }
        return false;
    }

    public boolean isMethodLibraryModified() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"isMethodLibraryModified");
        }
        for (Resource resource : this.getEditingDomain().getResourceSet().getResources()) {
            if (!resource.isModified()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnresolvedProxy() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"hasUnresolvedProxy");
        }
        ILibraryResourceSet resourceSet = (ILibraryResourceSet)this.editingDomain.getResourceSet();
        return resourceSet.hasUnresolvedProxy();
    }

    public Collection reloadResources(final Collection resources) {
        if (debug) {
            System.out.println("AbstractLibraryManager.reloadResources(): START");
        }
        try {
            final ArrayList reloadedResources = new ArrayList();
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    reloadedResources.addAll(AbstractLibraryManager.this.doReloadResources(resources));
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)new LibrarySchedulingRule(this.library), 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
            ArrayList arrayList = reloadedResources;
            return arrayList;
        }
        finally {
            if (debug) {
                System.out.println("AbstractLibraryManager.doReloadResources(): END");
            }
        }
    }

    private Collection doReloadResources(Collection resources) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"reloadResources");
        }
        if (this.library == null) {
            return Collections.EMPTY_LIST;
        }
        LibraryService libSvc = (LibraryService)LibraryService.getInstance();
        Resource currentLibResource = null;
        ILibraryManager currentLibMgr = null;
        Resource currentConfigResource = null;
        MethodConfiguration currentConfig = null;
        ArrayList<Resource> configResources = new ArrayList<Resource>();
        ArrayList<MethodElement> configs = new ArrayList<MethodElement>();
        for (Resource resource : resources) {
            MethodElement e = PersistenceUtil.getMethodElement((Resource)resource);
            if (e == libSvc.getCurrentMethodLibrary()) {
                currentLibMgr = libSvc.getCurrentLibraryManager();
                currentLibResource = resource;
                continue;
            }
            if (e == libSvc.getCurrentMethodConfiguration()) {
                currentConfigResource = resource;
                currentConfig = libSvc.getCurrentMethodConfiguration();
                continue;
            }
            if (!(e instanceof MethodConfiguration)) continue;
            configResources.add(resource);
            configs.add(e);
        }
        ILibraryResourceSet resourceSet = (ILibraryResourceSet)this.library.eResource().getResourceSet();
        Collection reloadedResources = resourceSet.reloadResources(resources);
        if (!reloadedResources.isEmpty()) {
            if (currentLibResource != null || currentConfigResource != null) {
                for (Resource resource : reloadedResources) {
                    int id;
                    MethodElement e;
                    if (resource == currentLibResource && (e = PersistenceUtil.getMethodElement((Resource)resource)) instanceof MethodLibrary) {
                        MethodLibrary newLib = (MethodLibrary)e;
                        libSvc.setCurrentMethodLibrary(newLib);
                        if (currentLibMgr instanceof AbstractLibraryManager) {
                            libSvc.removeLibraryManager(currentLibMgr);
                            ((AbstractLibraryManager)currentLibMgr).updateMethodLibrary(newLib);
                            libSvc.setLibraryManager(currentLibMgr);
                        }
                    }
                    if (resource == currentConfigResource) {
                        e = PersistenceUtil.getMethodElement((Resource)resource);
                        if (!(e instanceof MethodConfiguration)) continue;
                        libSvc.removeConfigurationManager(currentConfig);
                        MethodConfiguration config = (MethodConfiguration)e;
                        libSvc.setCurrentMethodConfiguration(config);
                        continue;
                    }
                    if (configResources.isEmpty() || (id = configResources.indexOf(resource)) == -1) continue;
                    libSvc.removeConfigurationManager((MethodConfiguration)configs.get(id));
                }
            }
            Suppression.cleanUp();
        }
        return reloadedResources;
    }

    private void updateMethodLibrary(MethodLibrary newLib) {
        this.library = newLib;
    }

    public Map getSaveOptions() {
        if (debug) {
            DebugTrace.print((Object)this, (String)"getSaveOptions");
        }
        return this.saveOptions;
    }

    public void addMethodPlugin(final MethodPlugin plugin) throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)this, (String)"addMethodPlugin", (String)("plugin=" + plugin));
        }
        final Exception[] exceptions = new Exception[1];
        try {
            SafeUpdateController.syncExec(new Runnable(){

                public void run() {
                    AbstractLibraryManager.this.library.getMethodPlugins().add(plugin);
                    ILibraryPersister.FailSafeMethodLibraryPersister persister = Services.getLibraryPersister((String)AbstractLibraryManager.this.getLibraryPersisterType()).getFailSafePersister();
                    try {
                        persister.save(AbstractLibraryManager.this.library.eResource());
                        persister.commit();
                    }
                    catch (Exception e) {
                        persister.rollback();
                        exceptions[0] = e;
                        return;
                    }
                    plugin.eResource().eAdapters().add((Object)AbstractLibraryManager.this.resourceChangedListener);
                }
            });
        }
        catch (Exception e) {
            throw new LibraryServiceException(e);
        }
        if (exceptions[0] != null) {
            throw new LibraryServiceException(exceptions[0]);
        }
    }

    public void dispose() {
        IPreferenceStoreWrapper prefStoreWrapper;
        if (this.preferenceStoreChangeListener != null && (prefStoreWrapper = LibraryPlugin.getDefault().getPreferenceStore()) != null) {
            prefStoreWrapper.removePropertyChangeListener(this.preferenceStoreChangeListener);
        }
        if (this.libraryChangedListeners.size() > 0) {
            this.libraryChangedListeners.clear();
        }
        if (this.resourceChangeListeners.size() > 0) {
            this.resourceChangeListeners.clear();
        }
        if (this.editingDomain != null) {
            this.unregisterEditingDomain(this.editingDomain);
            this.editingDomain = null;
        }
        this.library = null;
    }

    protected void checkElementCreationArguments(MethodElement containingElement, String name) throws LibraryServiceException {
        if (containingElement == null) {
            throw new IllegalArgumentException();
        }
        if (name == null || name.length() == 0) {
            throw new InvalidMethodElementNameException();
        }
    }

    protected void handleRefreshEvent(IRefreshEvent event) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"handleRefreshEvent", (String)("refreshedResources=" + event.getRefreshedResources()));
        }
        if (!event.getUnloadedObjects().isEmpty()) {
            TngAdapterFactory.INSTANCE.cleanUp();
        }
    }

    protected synchronized void notifyListeners(int option, Collection collection) {
        HashSet processed = new HashSet();
        while (this._doNotifyListeners(option, collection, processed)) {
        }
    }

    private boolean _doNotifyListeners(final int option, final Collection collection, Collection processed) {
        boolean changed;
        block4: {
            if (debug) {
                DebugTrace.print((Object)this, (String)"notifyListeners", (String)("option=" + option));
            }
            changed = false;
            try {
                for (final ILibraryChangeListener listener : new ArrayList(this.libraryChangedListeners)) {
                    if (listener == null || processed.contains(listener)) continue;
                    processed.add(listener);
                    changed = true;
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            if (debug) {
                                DebugTrace.print((Object)this, (String)"notifyListeners", (String)("listener=" + listener));
                            }
                            listener.libraryChanged(option, collection);
                        }
                    });
                }
            }
            catch (Exception e) {
                if (!debug) break block4;
                DebugTrace.print((Object)this, (String)"notifyListeners", (Throwable)e);
            }
        }
        return changed;
    }

    protected void firePropertyChange(final Object source, final int propertyId) {
        if (debug) {
            DebugTrace.print((Object)this, (String)"firePropertyChange", (String)("source=" + source));
        }
        Object[] array = this.resourceChangeListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final IPropertyListener listener = (IPropertyListener)array[i];
            SafeUpdateController.asyncExec(new Runnable(){

                public void run() {
                    if (debug) {
                        DebugTrace.print((Object)this, (String)"firePropertyChange", (String)("listener=" + listener));
                    }
                    listener.propertyChanged(source, propertyId);
                }
            });
            ++i;
        }
    }

    protected void addResourceChangedListeners() {
        if (this.library == null || this.library.eResource() == null) {
            return;
        }
        if (!this.library.eResource().eAdapters().contains((Object)this.resourceChangedListener)) {
            this.library.eResource().eAdapters().add((Object)this.resourceChangedListener);
        }
        for (MethodPlugin plugin : this.library.getMethodPlugins()) {
            if (plugin.eResource().eAdapters().contains((Object)this.resourceChangedListener)) continue;
            plugin.eResource().eAdapters().add((Object)this.resourceChangedListener);
        }
        for (MethodConfiguration config : this.library.getPredefinedConfigurations()) {
            if (config.eResource().eAdapters().contains((Object)this.resourceChangedListener)) continue;
            config.eResource().eAdapters().add((Object)this.resourceChangedListener);
        }
    }

    protected void removeResourceChangedListeners() {
        if (this.library == null || this.library.eResource() == null) {
            return;
        }
        this.library.eResource().eAdapters().remove((Object)this.resourceChangedListener);
        for (MethodPlugin plugin : this.library.getMethodPlugins()) {
            plugin.eResource().eAdapters().remove((Object)this.resourceChangedListener);
        }
        for (MethodConfiguration config : this.library.getPredefinedConfigurations()) {
            config.eResource().eAdapters().remove((Object)this.resourceChangedListener);
        }
    }

    protected Resource getMethodLibraryResource() {
        return this.library != null ? this.library.eResource() : null;
    }

    public java.net.URI getMethodLibraryURI() {
        Resource savedResource = this.getMethodLibraryResource();
        if (savedResource != null) {
            URI resourceURI = savedResource.getURI();
            try {
                File file = new File(resourceURI.toFileString());
                return file.getParentFile().toURI();
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return null;
    }

    private void addNewPackagesToConfiguration(Collection newobjs) {
        if (newobjs == null || newobjs.size() == 0) {
            return;
        }
        LibraryModificationHelper helper = new LibraryModificationHelper();
        try {
            try {
                for (EObject e : newobjs) {
                    Object configs;
                    EObject parent;
                    if (!(e instanceof MethodPackage) || (parent = e.eContainer()) == null || !(parent instanceof MethodPackage) || !((configs = ((MultiResourceEObject)parent).getOppositeFeatureValue(AssociationHelper.MethodPackage_MethodConfigurations)) instanceof List)) continue;
                    for (MethodConfiguration config : (List)configs) {
                        List pkgs = config.getMethodPackageSelection();
                        if (pkgs.contains(e)) continue;
                        helper.getActionManager().doAction(3, (EObject)config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_MethodPackageSelection(), (Object)e, -1);
                    }
                }
                helper.save();
            }
            catch (RuntimeException e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                helper.dispose();
            }
        }
        finally {
            helper.dispose();
        }
    }

    protected abstract String getLibraryPersisterType();

    protected abstract ILibraryResourceSet createResourceSet();
}

