/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationData;
import org.eclipse.epf.library.configuration.ConfigurationProperties;
import org.eclipse.epf.library.configuration.SupportingElementData;
import org.eclipse.epf.library.configuration.closure.ConfigurationClosure;
import org.eclipse.epf.library.configuration.closure.DependencyManager;
import org.eclipse.epf.library.edit.util.MethodElementProperties;
import org.eclipse.epf.library.edit.util.MethodElementPropertyMgr;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

public class ConfigurationManager
implements IConfigurationManager {
    protected static boolean debug = LibraryPlugin.getDefault().isDebugging();
    protected MethodConfiguration config;
    private ConfigurationData configData;
    private SupportingElementData supportingElementData;
    private ConfigurationProperties configProps;
    protected MethodLibrary library;
    protected ILibraryManager libraryManager;
    protected DependencyManager dependencyManager;
    protected ElementLayoutManager layoutManager;
    protected ConfigurationClosure closure;
    protected AdapterFactoryContentProvider afcp;

    public ConfigurationManager(MethodConfiguration config) {
        this.config = config;
        if (!ConfigurationData.ignoreSupportingPlugin) {
            this.supportingElementData = new SupportingElementData(config);
        }
        this.configData = ConfigurationData.newConfigurationData(config);
        this.configProps = new ConfigurationProperties(config);
        MethodElementPropertyMgr.getInstance().register((MethodElement)config, (MethodElementProperties)this.configProps);
        this.library = LibraryServiceUtil.getMethodLibrary((MethodElement)config);
        this.libraryManager = LibraryService.getInstance().getLibraryManager(this.library);
        this.afcp = new AdapterFactoryContentProvider((AdapterFactory)this.libraryManager.getAdapterFactory());
        this.dependencyManager = new DependencyManager(this.library, config);
        this.layoutManager = config == null ? new ElementLayoutManager() : new ElementLayoutManager(config);
    }

    public MethodConfiguration getMethodConfiguration() {
        return this.config;
    }

    public ConfigurationData getConfigurationData() {
        return this.configData;
    }

    public SupportingElementData getSupportingElementData() {
        return this.supportingElementData;
    }

    public MethodLibrary getMethodLibrary() {
        return this.library;
    }

    public AdapterFactory getAdapterFactory() {
        return this.libraryManager.getAdapterFactory();
    }

    public AdapterFactoryContentProvider getContentProvider() {
        return this.afcp;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public ElementLayoutManager getElementLayoutManager() {
        return this.layoutManager;
    }

    public ConfigurationClosure getConfigurationClosure() {
        return this.closure;
    }

    public void makeConfigurationClosure() {
        if (this.closure != null) {
            this.closure.fixErrors();
        }
    }

    public List getMethodPlugins() {
        return this.library.getMethodPlugins();
    }

    public void dispose() {
        this.configData.dispose();
        this.configData = null;
        this.config = null;
        this.library = null;
        this.libraryManager = null;
        this.dependencyManager = null;
        this.layoutManager = null;
        this.closure = null;
        MethodElementPropertyMgr.getInstance().unregister((MethodElement)this.config);
        this.configProps = null;
    }

    public ConfigurationProperties getConfigurationProperties() {
        return this.configProps;
    }
}

