/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.library.CreateLibraryManagerException;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.internal.LibraryManagerElement;
import org.eclipse.epf.services.Services;
import org.osgi.framework.Bundle;

public class LibraryManagerFactory {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.library";
    public static final String EXTENSION_POINT_NAME = "libraryManagers";
    public static final String CLASS_ATTRIB_NAME = "class";
    public static final String TYPE_ATTRIB_NAME = "type";
    public static final String TYPE_NAME_ATTRIB_NAME = "typeName";
    private static final String VERSION_ATTRIB_NAME = "version";
    private static LibraryManagerFactory instance = null;
    private Map<String, LibraryManagerElement> libraryManagerElements = new HashMap<String, LibraryManagerElement>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LibraryManagerFactory getInstance() {
        if (instance != null) return instance;
        Class<LibraryManagerFactory> clazz = LibraryManagerFactory.class;
        synchronized (LibraryManagerFactory.class) {
            if (instance != null) return instance;
            instance = new LibraryManagerFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LibraryManagerFactory() {
        this.init();
    }

    protected void init() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                String pluginId = extension.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)pluginId);
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        String className = configElement.getAttribute(CLASS_ATTRIB_NAME);
                        String typeId = configElement.getAttribute(TYPE_ATTRIB_NAME);
                        String typeName = configElement.getAttribute(TYPE_NAME_ATTRIB_NAME);
                        if (className != null && className.trim().length() > 0 && typeId != null && typeId.trim().length() > 0 && typeName != null && typeName.trim().length() > 0) {
                            int version = Services.parseVersion((String)configElement.getAttribute(VERSION_ATTRIB_NAME));
                            LibraryManagerElement provider = this.libraryManagerElements.get(typeId);
                            if (provider == null || provider.getVersion() < version) {
                                provider = new LibraryManagerElement(bundle, className, typeId, typeName, version);
                                this.libraryManagerElements.put(typeId, provider);
                            }
                        }
                    }
                    catch (Exception e) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public ILibraryManager createLibraryManager(String type) throws CreateLibraryManagerException {
        LibraryManagerElement provider = this.libraryManagerElements.get(type);
        if (provider == null) {
            throw new CreateLibraryManagerException();
        }
        try {
            Class clazz = provider.getBundle().loadClass(provider.getClassName());
            return (ILibraryManager)clazz.newInstance();
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            throw new CreateLibraryManagerException(e);
        }
    }

    public Map getLibraryTypes() {
        HashMap<String, String> types = new HashMap<String, String>();
        for (String typeId : this.libraryManagerElements.keySet()) {
            String typeName = this.libraryManagerElements.get(typeId).getTypeName();
            types.put(typeId, typeName);
        }
        return types;
    }
}

