/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.configuration.MethodConfigurationElementList;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessFamily;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryServiceUtil {
    private static final IFilter CHECKLIST_FILTER = new IFilter(){

        public boolean accept(Object obj) {
            return obj instanceof Checklist;
        }
    };

    public static String getMethodLibraryPath(MethodLibrary library) {
        URI resourceURI;
        if (library == null) {
            return null;
        }
        Resource resource = library.eResource();
        if (resource != null && (resourceURI = resource.getURI()) != null && resourceURI.isFile()) {
            String path = resourceURI.toFileString();
            return new File(path).getParentFile().getAbsolutePath();
        }
        return null;
    }

    public static String getCurrentMethodLibraryPath() {
        return LibraryServiceUtil.getMethodLibraryPath(LibraryService.getInstance().getCurrentMethodLibrary());
    }

    public static MethodLibrary getMethodLibrary(MethodElement element) {
        MethodElement obj = element;
        while (obj != null) {
            if (obj instanceof MethodLibrary) {
                return (MethodLibrary)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public static MethodConfiguration getMethodConfiguration(MethodLibrary library, String name) {
        if (library != null) {
            List configs = library.getPredefinedConfigurations();
            for (MethodConfiguration config : configs) {
                if (config instanceof ProcessFamily || !config.getName().equals(name)) continue;
                return config;
            }
        }
        return null;
    }

    public static MethodConfiguration[] getMethodConfigurations(MethodLibrary library) {
        ArrayList configs;
        if (library != null) {
            configs = new ArrayList(library.getPredefinedConfigurations());
            Iterator i = configs.iterator();
            while (i.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)i.next();
                if (config != null && !(config instanceof ProcessFamily)) continue;
                i.remove();
            }
        } else {
            configs = Collections.EMPTY_LIST;
        }
        MethodConfiguration[] result = new MethodConfiguration[configs.size()];
        configs.toArray(result);
        return result;
    }

    public static String[] getMethodConfigurationNames(MethodLibrary library) {
        ArrayList<String> configNames = new ArrayList<String>();
        if (library != null) {
            List configs = library.getPredefinedConfigurations();
            for (MethodConfiguration config : configs) {
                if (config instanceof ProcessFamily) continue;
                configNames.add(config.getName());
            }
        }
        String[] result = new String[configNames.size()];
        configNames.toArray(result);
        return result;
    }

    public static Map<String, Process> getProcesses() {
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        if (library == null) {
            return null;
        }
        TreeMap<String, Process> result = new TreeMap<String, Process>();
        List<MethodPlugin> methodPlugins = LibraryUtil.getMethodPlugins(library);
        for (MethodPlugin methodPlugin : methodPlugins) {
            String[] deliveryProcessPaths;
            String[] capabilityPatternPaths;
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(capabilityPatternPaths = ModelStructure.DEFAULT.capabilityPatternPath));
            if (methodPackage instanceof ProcessPackage && methodPackage instanceof ProcessPackage) {
                LibraryServiceUtil.getCapabilityPatterns((ProcessPackage)methodPackage, result);
            }
            if (!((methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(deliveryProcessPaths = ModelStructure.DEFAULT.deliveryProcessPath))) instanceof ProcessPackage) || !(methodPackage instanceof ProcessPackage)) continue;
            LibraryServiceUtil.getDeliveryProcesses((ProcessPackage)methodPackage, result);
        }
        return result;
    }

    public static Map<String, Process> getCapabilityPatterns() {
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        if (library == null) {
            return null;
        }
        TreeMap<String, Process> result = new TreeMap<String, Process>();
        List<MethodPlugin> methodPlugins = LibraryUtil.getMethodPlugins(library);
        for (MethodPlugin methodPlugin : methodPlugins) {
            String[] capabilityPatternPaths;
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(capabilityPatternPaths = ModelStructure.DEFAULT.capabilityPatternPath));
            if (!(methodPackage instanceof ProcessPackage)) continue;
            LibraryServiceUtil.getCapabilityPatterns((ProcessPackage)methodPackage, result);
        }
        return result;
    }

    public static List<CapabilityPattern> getCapabilityPatterns(MethodPlugin plugin) {
        ArrayList<CapabilityPattern> capabilityPatterns = new ArrayList<CapabilityPattern>();
        List items = TngUtil.getAllProcesses((MethodPlugin)plugin);
        for (Process process : items) {
            if (!(process instanceof CapabilityPattern)) continue;
            capabilityPatterns.add((CapabilityPattern)process);
        }
        return capabilityPatterns;
    }

    public static Map<String, Process> getDeliveryProcesses() {
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        if (library == null) {
            return null;
        }
        TreeMap<String, Process> result = new TreeMap<String, Process>();
        List<MethodPlugin> methodPlugins = LibraryUtil.getMethodPlugins(library);
        for (MethodPlugin methodPlugin : methodPlugins) {
            String[] deliveryProcessPaths;
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(deliveryProcessPaths = ModelStructure.DEFAULT.deliveryProcessPath));
            if (!(methodPackage instanceof ProcessPackage)) continue;
            LibraryServiceUtil.getDeliveryProcesses((ProcessPackage)methodPackage, result);
        }
        return result;
    }

    public static List<DeliveryProcess> getDeliveryProcesses(MethodPlugin plugin) {
        ArrayList<DeliveryProcess> deliveryProcesses = new ArrayList<DeliveryProcess>();
        List items = TngUtil.getAllProcesses((MethodPlugin)plugin);
        for (Process process : items) {
            if (!(process instanceof DeliveryProcess)) continue;
            deliveryProcesses.add((DeliveryProcess)process);
        }
        return deliveryProcesses;
    }

    protected static void getCapabilityPatterns(ProcessPackage processPackage, Map<String, Process> result) {
        List childPackages = processPackage.getChildPackages();
        for (MethodPackage pkg : childPackages) {
            if (pkg instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)pkg;
                Process process = processComponent.getProcess();
                if (!(process instanceof CapabilityPattern)) continue;
                String name = process.getName();
                result.put(name, process);
                continue;
            }
            if (!(pkg instanceof ProcessPackage)) continue;
            LibraryServiceUtil.getCapabilityPatterns((ProcessPackage)pkg, result);
        }
    }

    protected static void getDeliveryProcesses(ProcessPackage processPackage, Map<String, Process> result) {
        List childPackages = processPackage.getChildPackages();
        for (MethodPackage pkg : childPackages) {
            if (pkg instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)pkg;
                Process process = processComponent.getProcess();
                if (!(process instanceof DeliveryProcess)) continue;
                String name = process.getName();
                result.put(name, process);
                continue;
            }
            if (!(pkg instanceof ProcessPackage)) continue;
            LibraryServiceUtil.getDeliveryProcesses((ProcessPackage)pkg, result);
        }
    }

    public static String[] getProcessFamilyNames(MethodLibrary library) {
        ArrayList<String> processFamilyNames = new ArrayList<String>();
        if (library != null) {
            List configs = library.getPredefinedConfigurations();
            for (MethodConfiguration config : configs) {
                if (!(config instanceof ProcessFamily)) continue;
                processFamilyNames.add(config.getName());
            }
        }
        String[] result = new String[processFamilyNames.size()];
        processFamilyNames.toArray(result);
        return result;
    }

    public static String[] getContexts(Process process) {
        ArrayList<String> contextNames = new ArrayList<String>();
        if (process != null) {
            List contexts = process.getValidContext();
            for (MethodConfiguration context : contexts) {
                contextNames.add(context.getName());
            }
        }
        String[] result = new String[contextNames.size()];
        contextNames.toArray(result);
        return result;
    }

    public static Map<String, MethodConfiguration> getMethodConfigurations(Process process) {
        if (process == null) {
            return null;
        }
        TreeMap<String, MethodConfiguration> result = new TreeMap<String, MethodConfiguration>();
        MethodConfiguration defaultContext = process.getDefaultContext();
        if (defaultContext != null) {
            result.put(defaultContext.getName(), defaultContext);
        }
        List contexts = process.getValidContext();
        for (MethodConfiguration context : contexts) {
            if (context == null) continue;
            result.put(context.getName(), context);
        }
        return result;
    }

    public static Map<String, Checklist> getChecklists(MethodConfiguration config) {
        if (config == null) {
            return null;
        }
        HashMap<String, Checklist> result = new HashMap<String, Checklist>();
        ArrayList<IFilter> filterList = new ArrayList<IFilter>();
        filterList.add(CHECKLIST_FILTER);
        MethodConfigurationElementList elementList = new MethodConfigurationElementList(config, filterList);
        List elements = elementList.getList();
        for (Object obj : elements) {
            if (!(obj instanceof Checklist)) continue;
            Checklist checklist = (Checklist)obj;
            result.put(checklist.getName(), checklist);
        }
        return result;
    }

    public void setGUID(MethodElement element) {
        EList children;
        String guid = element.getGuid();
        if (guid == null || guid.length() == 0) {
            guid = EcoreUtil.generateUUID();
            boolean oldNotify = element.eDeliver();
            try {
                element.eSetDeliver(false);
                element.setGuid(guid);
            }
            finally {
                element.eSetDeliver(oldNotify);
            }
        }
        if ((children = element.eContents()) != null && children.size() > 0) {
            for (Object child : children) {
                if (!(child instanceof MethodElement)) continue;
                this.setGUID((MethodElement)child);
            }
        }
    }

    public static String getDebugString(MethodElement element) {
        if (element == null) {
            return "null";
        }
        return String.valueOf(element.getClass().getName()) + "[name: " + element.getName() + ", guid=" + element.getGuid() + "]";
    }

    public static ILibraryPersister getCurrentPersister() {
        try {
            ResourceSet resourceSet = LibraryService.getInstance().getCurrentLibraryManager().getEditingDomain().getResourceSet();
            if (resourceSet instanceof ILibraryResourceSet) {
                return ((ILibraryResourceSet)resourceSet).getPersister();
            }
        }
        catch (NullPointerException nullPointerException) {}
        return null;
    }

    public static ILibraryPersister getPersisterFor(Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet instanceof ILibraryResourceSet) {
            return ((ILibraryResourceSet)resourceSet).getPersister();
        }
        return null;
    }

    public static MethodPlugin createMethodPlugin(String name, String briefDesc, String authors, Object[] referencedPlugins) throws Exception {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        MethodPlugin plugin = UmaFactory.eINSTANCE.createMethodPlugin();
        plugin.setName(StrUtil.makeValidFileName((String)name));
        if (briefDesc != null) {
            plugin.setBriefDescription(briefDesc);
        }
        if (authors != null) {
            plugin.setAuthors(authors);
        }
        if (referencedPlugins != null) {
            int i = 0;
            while (i < referencedPlugins.length) {
                MethodPlugin referencedPlugin = (MethodPlugin)referencedPlugins[i];
                if (plugin != null) {
                    plugin.getBases().add(referencedPlugin);
                }
                ++i;
            }
        }
        ModelStorage.initialize(plugin);
        return plugin;
    }
}

