/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.bridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.command.ActionManager;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramAdapter
extends NodeAdapter {
    private org.eclipse.epf.uma.Activity baseAct;
    protected IFilter filter;
    private Suppression suppression;
    protected long umaLastModified;

    public DiagramAdapter(BreakdownElementWrapperItemProvider wrapper) {
        this((org.eclipse.epf.uma.Activity)TngUtil.unwrap((Object)wrapper));
        this.wrapper = wrapper;
        this.basicSetTargetReadOnly(wrapper.isReadOnly());
    }

    public DiagramAdapter(org.eclipse.epf.uma.Activity e) {
        super((MethodElement)e);
        if (ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)e)) {
            this.baseAct = (org.eclipse.epf.uma.Activity)e.getVariabilityBasedOnElement();
            this.baseAct.eAdapters().add((Object)this.methodElementAdapter);
        }
    }

    @Override
    public void dispose() {
        for (ActivityNode node : this.getNodes()) {
            NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
            if (nodeAdapter == null) continue;
            nodeAdapter.dispose();
        }
        super.dispose();
        if (this.baseAct != null) {
            this.baseAct.eAdapters().remove((Object)this.methodElementAdapter);
        }
    }

    @Override
    protected void handleNotification(Notification msg) {
        switch (msg.getFeatureID(Activity.class)) {
            case 62: {
                switch (msg.getEventType()) {
                    case 3: {
                        this.nodeAdded(msg.getPosition(), (ActivityNode)msg.getNewValue());
                        return;
                    }
                    case 4: {
                        this.nodeRemoved((ActivityNode)msg.getOldValue());
                        return;
                    }
                    case 5: {
                        Collection collection = (Collection)msg.getNewValue();
                        for (ActivityNode node : collection) {
                            this.nodeAdded(msg.getPosition(), node);
                        }
                        return;
                    }
                    case 6: {
                        Collection collection = (Collection)msg.getOldValue();
                        Iterator iter = collection.iterator();
                        while (iter.hasNext()) {
                            this.nodeRemoved((ActivityNode)iter.next());
                        }
                        return;
                    }
                }
            }
        }
        super.handleNotification(msg);
    }

    protected void replaceNode(Object oldElement, Object newElement) {
    }

    @Override
    protected NodeAdapter.MethodElementAdapter createMethodElementAdapter() {
        return new ActivityAdapter();
    }

    protected final void populateLinks() {
        this.populateLinks(this.getNodes());
    }

    /*
     * Unable to fully structure code
     */
    protected void populateLinks(List<ActivityNode> selectedNodes) {
        size = selectedNodes.size();
        notifies = new boolean[size];
        try {
            i = 0;
            while (i < size) {
                node = selectedNodes.get(i);
                notifies[i] = node.eDeliver();
                node.eSetDeliver(false);
                ++i;
            }
            for (ActivityNode node : selectedNodes) {
                this.populateLinks(node, false);
            }
        }
        finally {
            i = 0;
            ** while (i < size)
        }
lbl-1000:
        // 1 sources

        {
            selectedNodes.get(i).eSetDeliver(notifies[i]);
            ++i;
            continue;
        }
lbl21:
        // 1 sources

    }

    protected List getNodes() {
        Activity diagram = this.getDiagram();
        return diagram != null ? this.getDiagram().getNodes() : Collections.emptyList();
    }

    @Override
    protected Activity getDiagram() {
        return (Activity)this.getTarget();
    }

    protected boolean removeNode(Object obj) {
        if (!TngUtil.isInstanceOf((Collection)this.getBreakdownElementTypes(), (Object)obj)) {
            return false;
        }
        ActivityNode node = BridgeHelper.findNode(this.getDiagram(), obj);
        if (node == null) {
            return false;
        }
        for (ActivityEdge link : node.getOutgoings()) {
            link.setTarget(null);
        }
        for (ActivityEdge link : node.getIncomings()) {
            link.setSource(null);
        }
        node.getOutgoings().clear();
        node.getIncomings().clear();
        this.getNodes().remove(node);
        return true;
    }

    protected void removeNodes(Collection collection) {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.removeNode(iter.next());
        }
    }

    protected ActivityNode addNode(Object obj) {
        ActivityNode node = this.addNode(this.getNodes(), obj);
        if (node == null) {
            return node;
        }
        this.populateLinks(node, true);
        return node;
    }

    protected Collection addNodes(Collection collection) {
        ArrayList nodes = new ArrayList();
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.addNode(nodes, iter.next());
        }
        this.getNodes().addAll(nodes);
        return nodes;
    }

    public void moveNode(Object oldValue) {
    }

    protected void populateLinks(ActivityNode node, boolean disableNotification) {
    }

    protected ActivityNode toNode(MethodElement e) {
        ActivityNode node = this.newNode(e);
        if (node == null) {
            return null;
        }
        this.initializeNode(node, e);
        return node;
    }

    protected void initializeNodeAdapter(NodeAdapter nodeAdapter) {
        nodeAdapter.setEditingDomain(this.domain);
        nodeAdapter.actionManager = this.actionManager;
    }

    private void initializeNode(ActivityNode node, MethodElement e) {
        String name = BridgeHelper.getNodeName(e);
        node.setName(name);
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
        if (nodeAdapter != null && nodeAdapter.getElement() != e) {
            nodeAdapter.dispose();
            nodeAdapter = null;
        }
        if (nodeAdapter == null) {
            nodeAdapter = this.createNodeAdapter(e);
            this.initializeNodeAdapter(nodeAdapter);
            node.eAdapters().add((Object)nodeAdapter);
        }
    }

    protected NodeAdapter createNodeAdapter(MethodElement e) {
        return null;
    }

    protected ActivityNode newNode(MethodElement e) {
        return null;
    }

    protected ActivityNode addNode(Collection nodes, Object obj) {
        ActivityNode node;
        if (TngUtil.isInstanceOf((Collection)this.getBreakdownElementTypes(), (Object)obj) && (node = this.toNode((MethodElement)obj)) != null) {
            nodes.add(node);
            return node;
        }
        return null;
    }

    protected List getBreakdownElementTypes() {
        return Collections.singletonList(BreakdownElement.class);
    }

    public org.eclipse.epf.uma.Activity getActivity() {
        return (org.eclipse.epf.uma.Activity)this.element;
    }

    @Override
    protected void removeFromUmaModel(ActivityNode removedNode) {
        MethodElement e = BridgeHelper.getMethodElement((EModelElement)removedNode);
        if (e instanceof BreakdownElement) {
            this.getActionManager().doAction(4, (EObject)this.getActivity(), (EStructuralFeature)UmaPackage.Literals.ACTIVITY__BREAKDOWN_ELEMENTS, (Object)e, -1);
        }
        super.removeFromUmaModel(removedNode);
    }

    protected void extractChildren(ITreeItemContentProvider adapter, Object object, Collection children) {
        BSActivityItemProvider itemProvider;
        boolean oldRolledUp = false;
        if (adapter instanceof BSActivityItemProvider) {
            itemProvider = (BSActivityItemProvider)adapter;
            oldRolledUp = itemProvider.isRolledUp();
            itemProvider.basicSetRolledUp(false);
        } else if (adapter instanceof IBSItemProvider) {
            itemProvider = (IBSItemProvider)adapter;
            oldRolledUp = itemProvider.isRolledUp();
            itemProvider.setRolledUp(false);
        }
        try {
            for (Object child : adapter.getChildren(object)) {
                if (this.getSuppression().isSuppressed(child)) continue;
                children.add(child);
            }
        }
        finally {
            if (adapter instanceof IBSItemProvider) {
                ((IBSItemProvider)adapter).setRolledUp(oldRolledUp);
            }
        }
    }

    public Suppression getSuppression() {
        return this.suppression;
    }

    public void setSuppression(Suppression suppression) {
        this.suppression = suppression;
    }

    private void updateView(Collection<?> selectedNodes) throws InterruptedException, RollbackException {
        DiagramAdapter.updateView(this.getView(), selectedNodes);
    }

    private static boolean isWorkBreakdownElementType(View node) {
        String type = node.getType();
        return type != null && ("1007".equals(type) || "1010".equals(type) || "1011".equals(type) || "1009".equals(type) || "1012".equals(type));
    }

    private static void updateView(View view, Collection<?> selectedNodes) {
        for (View node : view.getChildren()) {
            if (selectedNodes.contains(node.getElement())) {
                NodeAdapter adapter = BridgeHelper.getNodeAdapter(node.getElement());
                if (adapter != null) {
                    adapter.updateView();
                }
                node.setVisible(true);
                continue;
            }
            if (node.getElement() instanceof ActivityNode) {
                if (!node.isVisible()) continue;
                node.setVisible(false);
                continue;
            }
            if (node.getElement() instanceof ActivityPartition) {
                DiagramAdapter.updateView(node, selectedNodes);
                continue;
            }
            if (DiagramAdapter.isWorkBreakdownElementType(node) && (!node.isSetElement() || node.getElement() == view.getElement())) {
                if (!node.isVisible()) continue;
                node.setVisible(false);
                continue;
            }
            if (node.isVisible()) continue;
            node.setVisible(true);
        }
    }

    private void updateEdges(Collection selectedNodes) throws InterruptedException, RollbackException {
        for (View node : this.getView().getChildren()) {
            if (selectedNodes.contains(node.getElement())) {
                NodeAdapter adapter = BridgeHelper.getNodeAdapter(node.getElement());
                adapter.updateView();
                node.setVisible(true);
                this.setEdgeVisibility(node, true);
                continue;
            }
            if (node.getElement() instanceof ActivityNode) {
                if (!node.isVisible()) continue;
                this.setEdgeVisibility(node, false);
                continue;
            }
            if (node.isVisible()) continue;
            node.setVisible(true);
            this.setEdgeVisibility(node, true);
        }
    }

    private void setEdgeVisibility(View view, boolean visibility) {
        Diagram diagram = view.getDiagram();
        for (Edge edge : diagram.getEdges()) {
            if (edge.getSource() != view && edge.getTarget() != view) continue;
            if (visibility) {
                view.setVisible(true);
            }
            edge.setVisible(visibility);
        }
    }

    public void populateDiagram() {
        boolean notify = this.notificationEnabled;
        try {
            try {
                this.notificationEnabled = false;
                final ArrayList selectedNodes = new ArrayList();
                Activity diagram = this.getDiagram();
                TxUtil.runInTransaction((EObject)diagram, (Runnable)new Runnable(){

                    public void run() {
                        selectedNodes.addAll(DiagramAdapter.this.populateNodes());
                        DiagramAdapter.this.populateLinks(selectedNodes);
                    }
                });
                for (ActivityNode node : selectedNodes) {
                    NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
                    if (nodeAdapter == null) continue;
                    nodeAdapter.addConsumer((Object)this);
                }
                TxUtil.runInTransaction((EObject)diagram, (Runnable)new Runnable(){

                    public void run() {
                        try {
                            DiagramAdapter.this.updateEdges(selectedNodes);
                            DiagramAdapter.this.updateView(selectedNodes);
                        }
                        catch (Exception e) {
                            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                        }
                    }
                });
            }
            catch (Exception e) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                this.notificationEnabled = notify;
            }
        }
        finally {
            this.notificationEnabled = notify;
        }
    }

    protected Collection populateNodes() {
        return Collections.EMPTY_LIST;
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    @Override
    public IActionManager getActionManager() {
        if (this.actionManager == null) {
            this.actionManager = new ActionManager(){

                public boolean doAction(int actionType, EObject object, EStructuralFeature feature, Object value, int index) {
                    boolean ret = super.doAction(actionType, object, feature, value, index);
                    if (ret) {
                        DiagramAdapter.this.umaLastModified = System.currentTimeMillis();
                    }
                    return ret;
                }
            };
        }
        return this.actionManager;
    }

    public long getUmaLastModified() {
        return this.umaLastModified;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    protected class ActivityAdapter
    extends NodeAdapter.MethodElementAdapter {
        protected ActivityAdapter() {
            super(DiagramAdapter.this);
        }

        protected Collection handleNotification(Notification msg) {
            ArrayList<ActivityNode> newNodesToRefresh = new ArrayList<ActivityNode>();
            block0 : switch (msg.getFeatureID(org.eclipse.epf.uma.Activity.class)) {
                case 40: {
                    switch (msg.getEventType()) {
                        case 3: {
                            ActivityNode node = DiagramAdapter.this.addNode(msg.getNewValue());
                            if (node == null || msg.getNotifier() != DiagramAdapter.this.baseAct) break block0;
                            BridgeHelper.getNodeAdapter((EObject)node).basicSetTargetReadOnly(true);
                            newNodesToRefresh.add(node);
                            break;
                        }
                        case 4: {
                            DiagramAdapter.this.removeNode(msg.getOldValue());
                            break;
                        }
                        case 5: {
                            Collection nodes = DiagramAdapter.this.addNodes((Collection)msg.getNewValue());
                            if (msg.getNotifier() != DiagramAdapter.this.baseAct) break block0;
                            for (ActivityNode node : nodes) {
                                BridgeHelper.getNodeAdapter((EObject)node).basicSetTargetReadOnly(true);
                                newNodesToRefresh.add(node);
                            }
                            break block0;
                        }
                        case 6: {
                            DiagramAdapter.this.removeNodes((Collection)msg.getOldValue());
                            break;
                        }
                        case 7: {
                            DiagramAdapter.this.moveNode(msg.getNewValue());
                            break;
                        }
                        case 1: {
                            DiagramAdapter.this.replaceNode(msg.getOldValue(), msg.getNewValue());
                        }
                    }
                    break;
                }
                default: {
                    return super.handleNotification(msg);
                }
            }
            return newNodesToRefresh;
        }
    }
}

