/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.CVSWorkspaceSubscriber;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.ccvs.ui.operations.WorkspaceResourceMapper;
import org.eclipse.team.internal.ui.mapping.BuildScopeOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class RepositoryProviderOperation
extends CVSOperation {
    public static boolean consultModelsWhenBuildingScope = true;
    private ISynchronizationScopeManager manager;
    private final ResourceMapping[] selectedMappings;

    public static ResourceMapping[] asResourceMappers(IResource[] resources) {
        return RepositoryProviderOperation.asResourceMappers(resources, 2);
    }

    public static ResourceMapping[] asResourceMappers(IResource[] resources, int depth) {
        return WorkspaceResourceMapper.asResourceMappers(resources, depth);
    }

    public RepositoryProviderOperation(IWorkbenchPart part, IResource[] resources) {
        this(part, RepositoryProviderOperation.asResourceMappers(resources));
    }

    public RepositoryProviderOperation(IWorkbenchPart part, ResourceMapping[] selectedMappings) {
        super(part);
        this.selectedMappings = selectedMappings;
    }

    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        try {
            try {
                monitor.beginTask(null, 100);
                this.buildScope(monitor);
                Map table = this.getProviderTraversalMapping(Policy.subMonitorFor(monitor, 30));
                this.execute(table, Policy.subMonitorFor(monitor, 30));
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void endOperation() throws CVSException {
        if (this.manager != null) {
            this.manager.dispose();
            this.manager = null;
        }
        super.endOperation();
    }

    public ISynchronizationScope buildScope(IProgressMonitor monitor) throws InterruptedException, CVSException {
        if (this.manager == null) {
            this.manager = this.createScopeManager(consultModelsWhenBuildingScope && this.consultModelsForMappings());
            BuildScopeOperation op = new BuildScopeOperation(this.getPart(), this.manager);
            try {
                op.run(monitor);
            }
            catch (InvocationTargetException e) {
                throw CVSException.wrapException((Exception)e);
            }
        }
        return this.manager.getScope();
    }

    protected SynchronizationScopeManager createScopeManager(boolean consultModels) {
        return new SynchronizationScopeManager(this.getJobName(), this.getSelectedMappings(), this.getResourceMappingContext(), consultModels);
    }

    private void execute(Map providerTraversal, IProgressMonitor monitor) throws CVSException, InterruptedException {
        Set keySet = providerTraversal.keySet();
        monitor.beginTask(null, keySet.size() * 1000);
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            CVSTeamProvider provider = (CVSTeamProvider)iterator.next();
            monitor.setTaskName(this.getTaskName(provider));
            TraversalMapEntry entry = (TraversalMapEntry)providerTraversal.get(provider);
            this.execute(provider, entry, Policy.subMonitorFor(monitor, 1000));
        }
    }

    protected void execute(CVSTeamProvider provider, ICVSTraversal entry, IProgressMonitor monitor) throws CVSException, InterruptedException {
        IResource[] deepResources = entry.getDeepResources();
        IResource[] shallowResources = entry.getShallowResources();
        IResource[] nontraversedFolders = entry.getNontraversedFolders();
        try {
            monitor.beginTask(this.getTaskName(provider), (deepResources.length > 0 ? 100 : 0) + (shallowResources.length > 0 ? 100 : 0) + (nontraversedFolders.length > 0 ? 10 : 0));
            if (deepResources.length == 0 && shallowResources.length == 0 && nontraversedFolders.length == 0) {
                return;
            }
            ISchedulingRule rule = this.getSchedulingRule(provider);
            try {
                Platform.getJobManager().beginRule(rule, monitor);
                if (deepResources.length > 0) {
                    this.execute(provider, deepResources, true, Policy.subMonitorFor(monitor, 100));
                }
                if (shallowResources.length > 0) {
                    this.execute(provider, shallowResources, false, Policy.subMonitorFor(monitor, 100));
                }
                if (nontraversedFolders.length > 0) {
                    this.handleNontraversedFolders(provider, nontraversedFolders, Policy.subMonitorFor(monitor, 10));
                }
            }
            finally {
                Platform.getJobManager().endRule(rule);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void handleNontraversedFolders(CVSTeamProvider provider, IResource[] nontraversedFolders, IProgressMonitor monitor) throws CVSException {
    }

    protected abstract String getTaskName(CVSTeamProvider var1);

    protected ISchedulingRule getSchedulingRule(CVSTeamProvider provider) {
        return provider.getProject();
    }

    private Map getProviderTraversalMapping(IProgressMonitor monitor) throws CoreException {
        HashMap<RepositoryProvider, TraversalMapEntry> result = new HashMap<RepositoryProvider, TraversalMapEntry>();
        ResourceMapping[] mappings = this.getScope().getMappings();
        int j = 0;
        while (j < mappings.length) {
            ResourceMapping mapping = mappings[j];
            IProject[] projects = mapping.getProjects();
            ResourceTraversal[] traversals = this.getScope().getTraversals(mapping);
            int k = 0;
            while (k < projects.length) {
                IProject project = projects[k];
                RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
                if (provider != null) {
                    TraversalMapEntry entry = (TraversalMapEntry)result.get(provider);
                    if (entry == null) {
                        entry = new TraversalMapEntry(provider);
                        result.put(provider, entry);
                    }
                    entry.add(traversals);
                }
                ++k;
            }
            ++j;
        }
        return result;
    }

    protected ResourceMappingContext getResourceMappingContext() {
        return ResourceMappingContext.LOCAL_CONTEXT;
    }

    protected abstract void execute(CVSTeamProvider var1, IResource[] var2, boolean var3, IProgressMonitor var4) throws CVSException, InterruptedException;

    protected Command.LocalOption[] getLocalOptions(boolean recurse) {
        if (!recurse) {
            return new Command.LocalOption[]{Command.DO_NOT_RECURSE};
        }
        return Command.NO_LOCAL_OPTIONS;
    }

    protected ICVSResource[] getCVSArguments(IResource[] resources) {
        ICVSResource[] cvsResources = new ICVSResource[resources.length];
        int i = 0;
        while (i < cvsResources.length) {
            cvsResources[i] = CVSWorkspaceRoot.getCVSResourceFor((IResource)resources[i]);
            ++i;
        }
        return cvsResources;
    }

    protected String[] getStringArguments(IResource[] resources) throws CVSException {
        ArrayList<String> arguments = new ArrayList<String>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IPath cvsPath = resources[i].getFullPath().removeFirstSegments(1);
            if (cvsPath.segmentCount() == 0) {
                arguments.add(".");
            } else {
                arguments.add(cvsPath.toString());
            }
            ++i;
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    protected ICVSRepositoryLocation getRemoteLocation(CVSTeamProvider provider) throws CVSException {
        CVSWorkspaceRoot workspaceRoot = provider.getCVSWorkspaceRoot();
        return workspaceRoot.getRemoteLocation();
    }

    protected ICVSFolder getLocalRoot(CVSTeamProvider provider) throws CVSException {
        CVSWorkspaceRoot workspaceRoot = provider.getCVSWorkspaceRoot();
        return workspaceRoot.getLocalRoot();
    }

    protected void updateWorkspaceSubscriber(CVSTeamProvider provider, ICVSResource[] resources, boolean recurse, IProgressMonitor monitor) {
        CVSWorkspaceSubscriber s = CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
        monitor.beginTask(null, 100 * resources.length);
        int i = 0;
        while (i < resources.length) {
            ICVSResource resource = resources[i];
            if (resource.isFolder()) {
                try {
                    s.updateRemote(provider, (ICVSFolder)resource, recurse, Policy.subMonitorFor(monitor, 100));
                }
                catch (TeamException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                }
            } else {
                monitor.worked(100);
            }
            ++i;
        }
    }

    public boolean isKeepOneProgressServiceEntry() {
        return true;
    }

    protected IAction getGotoAction() {
        return this.getShowConsoleAction();
    }

    protected IResource[] getTraversalRoots() {
        ArrayList<IResource> result = new ArrayList<IResource>();
        ResourceTraversal[] traversals = this.getTraversals();
        int i = 0;
        while (i < traversals.length) {
            ResourceTraversal traversal = traversals[i];
            result.addAll(Arrays.asList(traversal.getResources()));
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public ResourceTraversal[] getTraversals() {
        return this.getScope().getTraversals();
    }

    public boolean consultModelsForMappings() {
        return true;
    }

    public ResourceMapping[] getSelectedMappings() {
        return this.selectedMappings;
    }

    public ISynchronizationScope getScope() {
        return this.manager.getScope();
    }

    public ISynchronizationScopeManager getScopeManager() {
        return this.manager;
    }

    public static interface ICVSTraversal {
        public IResource[] getShallowResources();

        public IResource[] getDeepResources();

        public IResource[] getNontraversedFolders();
    }

    private static class TraversalMapEntry
    implements ICVSTraversal {
        RepositoryProvider provider;
        List files = new ArrayList();
        List zeroFolders = new ArrayList();
        List shallowFolders = new ArrayList();
        List deepFolders = new ArrayList();

        public TraversalMapEntry(RepositoryProvider provider) {
            this.provider = provider;
        }

        public void add(ResourceTraversal[] traversals) {
            int i = 0;
            while (i < traversals.length) {
                ResourceTraversal traversal = traversals[i];
                this.add(traversal);
                ++i;
            }
        }

        public void add(ResourceTraversal traversal) {
            IResource[] resources = traversal.getResources();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource.getProject().equals((Object)this.provider.getProject())) {
                    if (resource.getType() == 1) {
                        this.files.add(resource);
                    } else {
                        switch (traversal.getDepth()) {
                            case 0: {
                                this.zeroFolders.add(resource);
                                break;
                            }
                            case 1: {
                                this.shallowFolders.add(resource);
                                break;
                            }
                            case 2: {
                                this.deepFolders.add(resource);
                                break;
                            }
                            default: {
                                this.deepFolders.add(resource);
                            }
                        }
                    }
                }
                ++i;
            }
        }

        public IResource[] getShallowResources() {
            if (this.shallowFolders.isEmpty() && this.deepFolders.isEmpty() && !this.files.isEmpty()) {
                return this.files.toArray(new IResource[this.files.size()]);
            }
            if (!this.shallowFolders.isEmpty()) {
                if (this.files.isEmpty()) {
                    return this.shallowFolders.toArray(new IResource[this.shallowFolders.size()]);
                }
                ArrayList result = new ArrayList();
                result.addAll(this.shallowFolders);
                result.addAll(this.files);
                return result.toArray(new IResource[result.size()]);
            }
            return new IResource[0];
        }

        public IResource[] getDeepResources() {
            if (this.deepFolders.isEmpty()) {
                return new IResource[0];
            }
            if (!this.shallowFolders.isEmpty()) {
                return this.deepFolders.toArray(new IResource[this.deepFolders.size()]);
            }
            ArrayList result = new ArrayList();
            result.addAll(this.deepFolders);
            result.addAll(this.files);
            return result.toArray(new IResource[result.size()]);
        }

        public IResource[] getNontraversedFolders() {
            return this.zeroFolders.toArray(new IResource[this.zeroFolders.size()]);
        }
    }
}

