/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.xmi;

import java.io.File;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;

public class XMILibraryResourceManager
implements ILibraryResourceManager {
    public String getLogicalPath(MethodElement element) {
        String path;
        block3: {
            try {
                path = MethodLibraryPersister.INSTANCE.getElementVirtualPath(element);
                if (path != null && !path.equals("")) break block3;
                System.out.println("Warning! No Path for Element [" + element.getType().getName() + ": " + element.getName() + "]");
                return "";
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return "";
            }
        }
        return this.fixPath(path);
    }

    public String getBackPath(MethodElement element) {
        String backPath = "";
        String path = this.getLogicalPath(element);
        if (path != null && path.length() > 0) {
            backPath = path.replace(File.separatorChar, '/').replaceAll(".*?/", "\\.\\./");
        }
        return "./" + backPath;
    }

    private String fixPath(String path) {
        if (path == null || path.equals("")) {
            return "";
        }
        if (!path.endsWith(File.separator)) {
            return String.valueOf(path) + File.separator;
        }
        return path;
    }

    public String getLogicalResourcePath(MethodElement element) {
        String path = MethodLibraryPersister.INSTANCE.geResourceVirtualPath(element);
        return this.fixPath(path);
    }

    public String getPhysicalPath(MethodElement element) {
        if (element == null) {
            return null;
        }
        IFileBasedLibraryPersister persister = this.getFileBasedLibraryPersister(element);
        return persister != null ? this.fixPath(persister.getFolderAbsolutePath(element)) : null;
    }

    public String getPhysicalResourcePath(MethodElement element) {
        IFileBasedLibraryPersister persister = this.getFileBasedLibraryPersister(element);
        return persister != null ? this.fixPath(persister.getResourceFolderPath(element)) : null;
    }

    private IFileBasedLibraryPersister getFileBasedLibraryPersister(MethodElement element) {
        ILibraryPersister persister;
        Resource resource = element.eResource();
        if (resource != null && (persister = LibraryServiceUtil.getPersisterFor((Resource)resource)) instanceof IFileBasedLibraryPersister) {
            return (IFileBasedLibraryPersister)persister;
        }
        return null;
    }

    public String getLogicalPluginPath(MethodElement element) {
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)element);
        if (plugin != null) {
            return String.valueOf(plugin.getName()) + File.separator;
        }
        return "";
    }

    public String getPhysicalPluginPath(MethodElement element) {
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)element);
        if (plugin != null) {
            return this.getPhysicalPath((MethodElement)plugin);
        }
        return null;
    }

    public String resolve(MethodElement element, String logicalPath) {
        int i = (logicalPath = logicalPath.replace('/', File.separatorChar)).indexOf(File.separatorChar);
        if (i > 0) {
            String pluginName = logicalPath.substring(0, i);
            String pluginPath = null;
            MethodLibrary lib = UmaUtil.getMethodLibrary((EObject)element);
            List plugins = LibraryUtil.getMethodPlugins((MethodLibrary)lib);
            for (MethodPlugin plugin : plugins) {
                if (!plugin.getName().equals(pluginName)) continue;
                pluginPath = this.getPhysicalPluginPath((MethodElement)plugin);
                break;
            }
            if (pluginPath != null) {
                return String.valueOf(pluginPath) + logicalPath.substring(i + 1);
            }
        }
        return null;
    }
}

