/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.BaseExportService;
import org.eclipse.epf.export.services.ConfigurationExportService;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.export.services.PluginExportData;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginExportService
extends BaseExportService {
    PluginExportData data;

    public PluginExportService(PluginExportData data) {
        this.data = data;
    }

    public void run(IProgressMonitor monitor) {
        monitor.setTaskName(ExportResources.PluginExportService_MSG0);
        Collection<MethodPlugin> plugins = this.data.selectedPlugins;
        if (plugins == null || plugins.size() == 0) {
            return;
        }
        monitor.setTaskName(ExportResources.PluginExportService_MSG1);
        String exportLibPath = new File(this.data.llData.getParentFolder()).getAbsolutePath();
        File exportLibFolder = new File(exportLibPath);
        if (!exportLibFolder.exists()) {
            exportLibFolder.mkdir();
        }
        monitor.setTaskName(ExportResources.PluginExportService_MSG2);
        MethodLibrary currLib = LibraryService.getInstance().getCurrentMethodLibrary();
        String currLibPath = currLib.eResource().getURI().toFileString();
        File currLibFile = new File(currLibPath);
        for (MethodPlugin plugin : plugins) {
            if (plugin == null) continue;
            URI uri = plugin.eResource().getURI();
            String path = uri.toFileString();
            File pluginFolder = new File(path).getParentFile();
            String pluginPath = String.valueOf(plugin.getName()) + File.separator;
            File exportPluginFolder = new File(exportLibFolder, pluginPath);
            PluginExportService.copyDir(pluginFolder, exportPluginFolder);
        }
        monitor.setTaskName(ExportResources.PluginExportService_MSG3);
        this.getSelectedIds(this.data.selectedPlugins, this.data.associatedConfigMap);
        File libFolder = new File(LibraryService.getInstance().getCurrentMethodLibraryLocation());
        LibraryDocument document = this.processLibraryFile(currLibFile, new File(exportLibFolder, "export.xmi"));
        if (document != null) {
            this.copyConfigurationFiles(document, libFolder, exportLibFolder);
        }
        monitor.setTaskName(ExportResources.PluginExportService_MSG4);
    }

    private void copyConfigurationFiles(LibraryDocument document, File libFolder, File exportLibFolder) {
        for (List configs : this.data.associatedConfigMap.values()) {
            if (configs == null || configs.size() == 0) continue;
            for (MethodConfiguration config : configs) {
                String guid = config.getGuid();
                String uri = document.getResourceUri(guid);
                File src = null;
                if (uri == null) {
                    if (config.eResource() == null) continue;
                    URI resUri = config.eResource().getURI();
                    uri = "configurations" + File.separator + resUri.lastSegment();
                    uri = document.decodeUri(uri);
                    src = new File(resUri.toFileString());
                }
                if (uri == null) continue;
                if (src == null) {
                    src = new File(libFolder, uri);
                }
                File target = new File(exportLibFolder, uri);
                FileUtil.copyFile((File)src, (File)target);
            }
        }
    }

    public static void copyDir(File fromDir, File toDir) {
        Copy cp = new Copy();
        cp.setOverwrite(true);
        FileSet set = new FileSet();
        set.setExcludes(ConfigurationExportService.excludes);
        set.setDir(fromDir);
        cp.addFileset(set);
        cp.setTodir(toDir);
        cp.setProject(new Project());
        cp.setPreserveLastModified(true);
        cp.execute();
    }

    private void getSelectedIds(Collection<MethodPlugin> plugins, Map configsMap) {
        MethodLibrary lib;
        this.selectedIds.clear();
        this.selectedPluginNames.clear();
        MethodPlugin plugin2 = null;
        for (MethodPlugin plugin2 : plugins) {
            String guid = plugin2.getGuid();
            this.selectedPluginNames.add(plugin2.getName());
            if (this.selectedIds.contains(guid)) continue;
            this.selectedIds.add(guid);
        }
        if (plugin2 != null && (lib = (MethodLibrary)plugin2.eContainer()) != null) {
            this.selectedIds.add(lib.getGuid());
        }
        for (List configs : configsMap.values()) {
            if (configs == null || configs.size() == 0) continue;
            for (MethodConfiguration config : configs) {
                String guid = config.getGuid();
                if (this.selectedIds.contains(guid)) continue;
                this.selectedIds.add(guid);
                EList refs = config.eCrossReferences();
                for (Object o : refs) {
                    if (o instanceof MethodPlugin || o instanceof MethodPackage) {
                        guid = ((MethodElement)o).getGuid();
                        if (this.selectedIds.contains(guid)) continue;
                        this.selectedIds.add(guid);
                        continue;
                    }
                    System.out.println("Unexpected element type '" + ((MethodElement)o).getType().getName() + "' in configuration '" + config.getName() + "'");
                }
            }
        }
    }
}

