/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import java.io.File;
import org.eclipse.epf.authoring.ui.preferences.LibraryLocationData;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DestinationCommonPage
extends BaseWizardPage
implements Listener {
    protected Composite composite;
    protected Combo exportPathCombo;
    protected Button browseButton;
    protected LibraryLocationData llData;

    public DestinationCommonPage(String pageName, LibraryLocationData llData) {
        super(pageName);
        this.setTitle(ExportResources.DestinationCommonPage_title);
        this.setDescription(ExportResources.DestinationCommonPage_desc);
        this.llData = llData;
    }

    public void createControl(Composite parent) {
        this.composite = DestinationCommonPage.createGridLayoutComposite((Composite)parent, (int)3);
        DestinationCommonPage.createLabel((Composite)this.composite, (String)ExportResources.DestinationCommonPage_label_dir);
        this.exportPathCombo = DestinationCommonPage.createCombobox((Composite)this.composite, (int)1);
        this.browseButton = DestinationCommonPage.createButton((Composite)this.composite, (String)ExportResources.DestinationCommonPage_label_browse);
        DestinationCommonPage.createLabel((Composite)this.composite, (String)"");
        this.initControls();
        this.addListeners();
        this.setControl((Control)this.composite);
        this.createAdditionalControls(this.composite);
        this.setPageComplete(false);
    }

    protected void initControls() {
        this.exportPathCombo.setEnabled(true);
        this.browseButton.setEnabled(true);
    }

    protected void addListeners() {
        this.exportPathCombo.addListener(15, (Listener)this);
        this.exportPathCombo.addListener(24, (Listener)this);
        this.exportPathCombo.addListener(16, (Listener)this);
        this.exportPathCombo.addListener(13, (Listener)this);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DestinationCommonPage.this.openDirectoryDialog();
            }
        });
    }

    protected void createAdditionalControls(Composite composite) {
    }

    public void setVisible(boolean visible) {
        Display display;
        super.setVisible(visible);
        if (visible && (display = this.composite.getDisplay()) != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    DestinationCommonPage.this.exportPathCombo.setFocus();
                }
            });
        }
    }

    public void handleEvent(Event event) {
        Wizard wizard = (Wizard)this.getWizard();
        this.setPageComplete(this.isPageComplete());
        wizard.getContainer().updateButtons();
    }

    protected void saveToDataModel() {
        String libName = this.exportPathCombo.getText();
        if (libName.length() > 0) {
            libName = !libName.endsWith(File.separator) ? libName.substring(libName.lastIndexOf(File.separator) + 1, libName.length()) : "";
        }
        this.llData.setLibName(libName);
        this.llData.setParentFolder(this.exportPathCombo.getText());
    }

    private void openDirectoryDialog() {
        try {
            DirectoryDialog dd = new DirectoryDialog(this.composite.getShell(), 0);
            dd.setFilterPath(this.exportPathCombo.getText());
            String destination = dd.open();
            if (destination != null) {
                this.exportPathCombo.setText(destination);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void initComboItems() {
    }
}

