/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import java.util.List;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.library.IConfigurationClosure;
import org.eclipse.epf.library.configuration.closure.ConfigurationClosure;
import org.eclipse.epf.library.configuration.closure.ElementError;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExportConfigCheckingPage
extends BaseWizardPage {
    public static final String PAGE_NAME = ExportConfigCheckingPage.class.getName();
    private TextViewer textViewer;
    private TextPresentation style;
    private ConfigurationExportData data;
    private IConfigurationClosure closure = null;

    public ExportConfigCheckingPage(ConfigurationExportData data) {
        super(PAGE_NAME);
        this.setTitle(ExportResources.checkConfigPage_title);
        this.setDescription(ExportResources.checkConfigPage_desc);
        this.setImageDescriptor(ExportPlugin.getDefault().getImageDescriptor("full/wizban/exp_lib_conf_wizban.gif"));
        this.data = data;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.textViewer = ExportConfigCheckingPage.createTextViewer((Composite)container, (int)360, (int)160, (int)1);
        Document doc = new Document(" ");
        this.textViewer.setDocument((IDocument)doc);
        this.setControl((Control)container);
        this.setPageComplete(true);
    }

    private void displaySummary() {
        this.style = new TextPresentation();
        Document doc = this.getSummaryText();
        this.textViewer.setDocument((IDocument)doc);
        this.textViewer.changeTextPresentation(this.style, true);
    }

    public void onEnterPage(Object obj) {
        this.displaySummary();
    }

    public Document getSummaryText() {
        StringBuffer textBuf = new StringBuffer();
        if (this.data.selectedConfigs.size() == 0) {
            textBuf.append(ExportResources.ExportConfigCheckingPage_summary_2);
        } else {
            final MethodConfiguration config = (MethodConfiguration)this.data.selectedConfigs.get(0);
            if (this.closure == null || this.closure.getConfiguration() != config) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        ExportConfigCheckingPage.this.closure = (IConfigurationClosure)new ConfigurationClosure(null, config);
                    }
                };
                UserInteractionHelper.runWithProgress((Runnable)runnable, (String)ExportResources.ExportConfigCheckingPage_checking);
            }
        }
        List errors = this.closure.getAllErrors();
        if (errors.size() == 0) {
            textBuf.append(ExportResources.ExportConfigCheckingPage_summary_3);
        } else {
            int eSz = 0;
            int wSz = 0;
            int iSz = 0;
            for (ElementError error : errors) {
                if (error.getSeverity() == 2) {
                    ++eSz;
                    continue;
                }
                if (error.getSeverity() == 1) {
                    ++wSz;
                    continue;
                }
                ++iSz;
            }
            textBuf.append(ExportResources.bind((String)ExportResources.ExportConfigCheckingPage_summary_4, (Object[])new Object[]{Integer.toString(errors.size()), Integer.toString(eSz), Integer.toString(wSz), Integer.toString(iSz)}));
        }
        Document doc = new Document(textBuf.toString());
        return doc;
    }
}

