/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.export.wizards.ExportConfigCheckingPage;
import org.eclipse.epf.export.wizards.ExportConfigurationWizard;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ExportConfigSelectConfigPage
extends BaseWizardPage
implements ISelectionChangedListener,
Listener {
    public static final String PAGE_NAME = ExportConfigSelectConfigPage.class.getName();
    private Table table;
    private TableViewer ctrl_tableViewer;
    private Text ctrl_briefDesc;
    private ConfigurationExportData data;

    public ExportConfigSelectConfigPage(ConfigurationExportData data) {
        super(PAGE_NAME);
        this.setTitle(ExportResources.selectConfigPage_title);
        this.setDescription(ExportResources.selectConfigPage_desc);
        this.setImageDescriptor(ExportPlugin.getDefault().getImageDescriptor("full/wizban/exp_lib_conf_wizban.gif"));
        this.data = data;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        ExportConfigSelectConfigPage.createLabel((Composite)container, (String)ExportResources.selectConfigPage_configsLabel_text);
        this.ctrl_tableViewer = ExportConfigSelectConfigPage.createTableViewer((Composite)container, (int)360, (int)120, (int)1);
        this.table = this.ctrl_tableViewer.getTable();
        ArrayList configList = new ArrayList(LibraryService.getInstance().getCurrentMethodLibrary().getPredefinedConfigurations());
        if (configList.size() > 1) {
            Comparator comparator = PresentationContext.INSTANCE.getComparator();
            Collections.sort(configList, comparator);
        }
        MethodConfiguration[] a = new MethodConfiguration[configList.size()];
        MethodConfiguration[] configs = configList.toArray(a);
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return LibraryUIImages.IMG_METHOD_PLUGIN;
            }

            public String getText(Object element) {
                if (element instanceof MethodConfiguration) {
                    return ((MethodConfiguration)element).getName();
                }
                return element.toString();
            }
        };
        this.ctrl_tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (configs != null) {
            this.ctrl_tableViewer.setInput((Object)configs);
        }
        ExportConfigSelectConfigPage.createLabel((Composite)container, (String)AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        this.ctrl_briefDesc = ExportConfigSelectConfigPage.createMultiLineText((Composite)container, (String)"", (int)360, (int)80, (int)3);
        if (configs != null && configs.length > 0) {
            this.table.select(0);
            this.setDisplayAttributes(configs[0]);
        }
        this.addListeners();
        this.setControl((Control)container);
        this.setPageComplete(true);
    }

    private void addListeners() {
        this.ctrl_tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            Object[] configs = selection.toArray();
            this.setDisplayAttributes((MethodConfiguration)configs[0]);
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    private void setDisplayAttributes(MethodConfiguration config) {
        this.ctrl_briefDesc.setText(config.getBriefDescription());
    }

    protected void saveDataToModel() {
        IStructuredSelection selection = (IStructuredSelection)this.ctrl_tableViewer.getSelection();
        Object[] configs = selection.toArray();
        MethodConfiguration config = (MethodConfiguration)configs[0];
        ArrayList<MethodConfiguration> arrList = new ArrayList<MethodConfiguration>();
        arrList.add(config);
        this.data.selectedConfigs = arrList;
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        ExportConfigCheckingPage page = ((ExportConfigurationWizard)this.getWizard()).configCheckingPage;
        page.onEnterPage(null);
        return page;
    }

    public boolean isPageComplete() {
        IStructuredSelection selection = (IStructuredSelection)this.ctrl_tableViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        return super.isPageComplete();
    }
}

