/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetConfigurationBlock;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetNewWizard;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SimpleWorkingSetSelectionDialog
extends SelectionDialog {
    private final IWorkingSet[] fWorkingSets;
    private final IWorkingSet[] fInitialSelection;
    private final ArrayList fCreatedWorkingSets;
    private CheckboxTableViewer fTableViewer;
    private IWorkingSet[] fCheckedElements;
    private Button fSelectAll;
    private Button fDeselectAll;
    private Button fNewWorkingSet;

    public SimpleWorkingSetSelectionDialog(Shell shell, String[] workingSetIds, IWorkingSet[] initialSelection) {
        super(shell);
        this.setTitle(WorkingSetMessages.SimpleWorkingSetSelectionDialog_SimpleSelectWorkingSetDialog_title);
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fWorkingSets = WorkingSetConfigurationBlock.filter(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets(), workingSetIds);
        this.fInitialSelection = initialSelection;
        this.fCheckedElements = this.fInitialSelection;
        this.fCreatedWorkingSets = new ArrayList();
    }

    protected final Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        this.createMessageArea(composite);
        Composite inner = new Composite(composite, 0);
        inner.setFont(composite.getFont());
        inner.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        Composite tableComposite = new Composite(inner, 0);
        tableComposite.setFont(composite.getFont());
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        tableComposite.setLayout((Layout)layout);
        this.fTableViewer = this.createTableViewer(tableComposite);
        this.createRightButtonBar(inner);
        this.createBottomButtonBar(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public IWorkingSet[] getSelection() {
        return this.fCheckedElements;
    }

    protected CheckboxTableViewer createTableViewer(Composite parent) {
        CheckboxTableViewer result = CheckboxTableViewer.newCheckList((Composite)parent, (int)2050);
        result.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SimpleWorkingSetSelectionDialog.this.checkedStateChanged();
            }
        });
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(20);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        result.getTable().setLayoutData((Object)data);
        result.getTable().setFont(parent.getFont());
        result.addFilter(this.createTableFilter());
        result.setLabelProvider((IBaseLabelProvider)this.createTableLabelProvider());
        result.setSorter(this.createTableSorter());
        result.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object element) {
                return (Object[])element;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        result.setInput((Object)this.fWorkingSets);
        result.setCheckedElements((Object[])this.fInitialSelection);
        return result;
    }

    protected ViewerSorter createTableSorter() {
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IWorkingSet w1 = (IWorkingSet)e1;
                IWorkingSet w2 = (IWorkingSet)e2;
                return Collator.getInstance().compare(w1.getLabel(), w2.getLabel());
            }
        };
    }

    protected LabelProvider createTableLabelProvider() {
        return new WorkingSetLabelProvider();
    }

    protected ViewerFilter createTableFilter() {
        return new Filter();
    }

    protected void createRightButtonBar(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setFont(parent.getFont());
        buttons.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.createButtonsForRightButtonBar(buttons);
    }

    protected void createButtonsForRightButtonBar(Composite bar) {
        this.fSelectAll = new Button(bar, 8);
        this.fSelectAll.setText(WorkingSetMessages.SimpleWorkingSetSelectionDialog_SelectAll_button);
        this.fSelectAll.setFont(bar.getFont());
        this.setButtonLayoutData(this.fSelectAll);
        this.fSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleWorkingSetSelectionDialog.this.selectAll();
            }
        });
        this.fDeselectAll = new Button(bar, 8);
        this.fDeselectAll.setText(WorkingSetMessages.SimpleWorkingSetSelectionDialog_DeselectAll_button);
        this.fDeselectAll.setFont(bar.getFont());
        this.setButtonLayoutData(this.fDeselectAll);
        this.fDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleWorkingSetSelectionDialog.this.deselectAll();
            }
        });
        new Label(bar, 0);
        this.fNewWorkingSet = new Button(bar, 8);
        this.fNewWorkingSet.setText(WorkingSetMessages.SimpleWorkingSetSelectionDialog_New_button);
        this.fNewWorkingSet.setFont(bar.getFont());
        this.setButtonLayoutData(this.fNewWorkingSet);
        this.fNewWorkingSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkingSet workingSet = SimpleWorkingSetSelectionDialog.this.newWorkingSet();
            }
        });
    }

    protected void createBottomButtonBar(Composite parent) {
    }

    protected void checkedStateChanged() {
        List<Object> elements = Arrays.asList(this.fTableViewer.getCheckedElements());
        this.fCheckedElements = elements.toArray(new IWorkingSet[elements.size()]);
    }

    protected void selectAll() {
        this.fTableViewer.setAllChecked(true);
        this.checkedStateChanged();
    }

    protected void deselectAll() {
        this.fTableViewer.setAllChecked(false);
        this.checkedStateChanged();
    }

    protected IWorkingSet newWorkingSet() {
        IWorkingSet workingSet;
        Filter filter;
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetNewWizard wizard = manager.createWorkingSetNewWizard(new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage"});
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0 && (filter = new Filter()).select(null, null, workingSet = wizard.getSelection())) {
            this.addNewWorkingSet(workingSet);
            this.checkedStateChanged();
            manager.addWorkingSet(workingSet);
            this.fCreatedWorkingSets.add(workingSet);
            return workingSet;
        }
        return null;
    }

    protected void addNewWorkingSet(IWorkingSet workingSet) {
        this.fTableViewer.add((Object)workingSet);
        this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)workingSet), true);
        this.fTableViewer.setChecked((Object)workingSet, true);
    }

    protected void cancelPressed() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        int i = 0;
        while (i < this.fCreatedWorkingSets.size()) {
            manager.removeWorkingSet((IWorkingSet)this.fCreatedWorkingSets.get(i));
            ++i;
        }
        super.cancelPressed();
    }

    private class Filter
    extends ViewerFilter {
        private Filter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.isCompatible((IWorkingSet)element);
        }

        private boolean isCompatible(IWorkingSet set) {
            if (set.isAggregateWorkingSet() || !set.isSelfUpdating()) {
                return false;
            }
            if (!set.isVisible()) {
                return false;
            }
            return set.isEditable();
        }
    }

    private static class WorkingSetLabelProvider
    extends LabelProvider {
        private Map fIcons = new Hashtable();

        public void dispose() {
            Iterator iterator = this.fIcons.values().iterator();
            while (iterator.hasNext()) {
                Image icon = (Image)iterator.next();
                icon.dispose();
            }
            super.dispose();
        }

        public Image getImage(Object object) {
            Assert.isTrue((boolean)(object instanceof IWorkingSet));
            IWorkingSet workingSet = (IWorkingSet)object;
            ImageDescriptor imageDescriptor = workingSet.getImageDescriptor();
            if (imageDescriptor == null) {
                return null;
            }
            Image icon = (Image)this.fIcons.get(imageDescriptor);
            if (icon == null) {
                icon = imageDescriptor.createImage();
                this.fIcons.put(imageDescriptor, icon);
            }
            return icon;
        }

        public String getText(Object object) {
            Assert.isTrue((boolean)(object instanceof IWorkingSet));
            IWorkingSet workingSet = (IWorkingSet)object;
            return workingSet.getName();
        }
    }
}

