/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.prefs.PreferenceUtil;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ConfigurationContributionItem
extends ContributionItem {
    private static Combo configCombo;
    private static ComboViewer configComboViewer;
    protected ToolItem item;
    protected CoolItem coolItem;
    protected ILibraryServiceListener libSvcListener;
    protected IStructuredContentProvider contentProvider;
    protected ILabelProvider labelProvider;
    protected ISelectionChangedListener postSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ConfigurationContributionItem.performSelectionChanged();
        }
    };

    public ConfigurationContributionItem(IAction action) {
    }

    public void fill(ToolBar parent, int index) {
        this.item = new ToolItem(parent, 2);
        Control box = this.createControl((Composite)parent);
        this.item.setControl(box);
        this.item.setWidth(240);
    }

    public void fill(CoolBar coolBar, int index) {
        Control box = this.createControl((Composite)coolBar);
        this.coolItem = index >= 0 ? new CoolItem(coolBar, 4, index) : new CoolItem(coolBar, 4);
        this.coolItem.setData((Object)this);
        this.coolItem.setControl(box);
        Point toolBarSize = box.computeSize(-1, -1);
        this.coolItem.setMinimumSize(toolBarSize);
        this.coolItem.setPreferredSize(toolBarSize);
        this.coolItem.setSize(toolBarSize);
    }

    public void fill(Composite parent) {
        this.createControl(parent);
    }

    private Control createControl(Composite parent) {
        configCombo = new Combo(parent, 12);
        configCombo.setVisibleItemCount(10);
        configCombo.setEnabled(true);
        configComboViewer = new ComboViewer(configCombo);
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<String> configsList = new ArrayList<String>();
                configsList.addAll((Collection)Arrays.asList(LibraryServiceUtil.getMethodConfigurations((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary())));
                Collections.sort(configsList, Comparators.DEFAULT_COMPARATOR);
                if (LibraryService.getInstance().getCurrentMethodConfiguration() == null) {
                    configsList.add(0, LibraryUIResources.selectConfigLabel_text);
                }
                return configsList.toArray();
            }
        };
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public String getText(Object object) {
                if (object instanceof String) {
                    return (String)object;
                }
                if (object instanceof MethodConfiguration) {
                    return ((MethodConfiguration)object).getName();
                }
                return object.toString();
            }
        };
        configComboViewer.setContentProvider((IContentProvider)this.contentProvider);
        configComboViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        configComboViewer.setInput((Object)LibraryService.getInstance().getCurrentMethodLibrary());
        String savedConfigName = PreferenceUtil.getSavedLastConfig();
        MethodConfiguration savedConfig = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)savedConfigName);
        if (savedConfig != null) {
            configComboViewer.setSelection((ISelection)new StructuredSelection((Object)savedConfig));
        } else {
            configComboViewer.setSelection((ISelection)new StructuredSelection((Object)LibraryUIResources.selectConfigLabel_text));
        }
        configComboViewer.addPostSelectionChangedListener(this.postSelectionChangedListener);
        configComboViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ConfigurationContributionItem.this.dispose();
            }
        });
        this.libSvcListener = new ILibraryServiceListener(){

            public void configurationSet(MethodConfiguration config) {
                configComboViewer.removePostSelectionChangedListener(ConfigurationContributionItem.this.postSelectionChangedListener);
                try {
                    ConfigurationContributionItem.selectConfiguration(config);
                }
                finally {
                    configComboViewer.addPostSelectionChangedListener(ConfigurationContributionItem.this.postSelectionChangedListener);
                }
            }

            public void libraryClosed(MethodLibrary library) {
                configComboViewer.setInput(null);
            }

            public void libraryCreated(MethodLibrary library) {
                configComboViewer.setInput((Object)library);
                ConfigurationContributionItem.selectConfiguration(null);
            }

            public void libraryOpened(MethodLibrary library) {
                configComboViewer.setInput((Object)library);
                ConfigurationContributionItem.refresh();
                MethodConfiguration config = LibraryService.getInstance().getCurrentMethodConfiguration();
                configComboViewer.setSelection((ISelection)new StructuredSelection(config != null ? config : LibraryUIResources.selectConfigLabel_text), true);
            }

            public void libraryReopened(MethodLibrary library) {
                if (library != configComboViewer.getInput()) {
                    configComboViewer.setInput((Object)library);
                    ConfigurationContributionItem.refresh();
                }
            }

            public void librarySet(MethodLibrary library) {
                if (library != configComboViewer.getInput()) {
                    configComboViewer.setInput((Object)library);
                    if (library == null) {
                        ConfigurationContributionItem.selectConfiguration(null);
                    } else {
                        ConfigurationContributionItem.refresh();
                    }
                }
            }
        };
        LibraryService.getInstance().addListener(this.libSvcListener);
        return configCombo;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            LibraryService.getInstance().addListener(this.libSvcListener);
        } else {
            LibraryService.getInstance().removeListener(this.libSvcListener);
        }
        super.setVisible(visible);
    }

    private static MethodConfiguration getSelectedConfig() {
        IStructuredSelection selection = (IStructuredSelection)configComboViewer.getSelection();
        Object object = selection.getFirstElement();
        if (object instanceof MethodConfiguration) {
            return (MethodConfiguration)object;
        }
        return null;
    }

    private static String getCurrentSelectedConfigName() {
        IStructuredSelection selection = (IStructuredSelection)configComboViewer.getSelection();
        Object object = selection.getFirstElement();
        if (object != null && object instanceof MethodConfiguration) {
            return ((MethodConfiguration)object).getName();
        }
        if (object instanceof String) {
            return (String)object;
        }
        return "";
    }

    private static void performSelectionChanged() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() != null) {
            MethodConfiguration config = ConfigurationContributionItem.getSelectedConfig();
            if (config != LibraryService.getInstance().getCurrentMethodConfiguration()) {
                LibraryService.getInstance().setCurrentMethodConfiguration(config);
            }
            PreferenceUtil.saveSelectedConfigIntoPersistence((String)ConfigurationContributionItem.getCurrentSelectedConfigName());
            ConfigurationContributionItem.refresh();
        }
    }

    public void dispose() {
        if (this.libSvcListener != null) {
            LibraryService.getInstance().removeListener(this.libSvcListener);
        }
        if (configComboViewer != null) {
            configComboViewer.removePostSelectionChangedListener(this.postSelectionChangedListener);
        }
        super.dispose();
    }

    public static void refresh() {
        configComboViewer.refresh();
    }

    private static void selectConfiguration(MethodConfiguration config) {
        if (config != null && config == ConfigurationContributionItem.getSelectedConfig()) {
            return;
        }
        if (config != null) {
            configComboViewer.setSelection((ISelection)new StructuredSelection((Object)config));
        } else {
            ConfigurationContributionItem.refresh();
            configComboViewer.setSelection((ISelection)new StructuredSelection((Object)LibraryUIResources.selectConfigLabel_text), true);
        }
    }

    public void setEnabled(boolean enabled) {
        configCombo.setEnabled(enabled);
    }
}

