/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.actions.ILibraryAction;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.jface.operation.IRunnableWithProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodElementDeleteAction
extends DeleteAction
implements ILibraryAction {
    protected Collection<?> selection = null;
    protected boolean confirm = true;
    private IProgressMonitor progressMonitor;

    public MethodElementDeleteAction() {
    }

    public MethodElementDeleteAction(EditingDomain domain) {
        super(domain);
    }

    public MethodElementDeleteAction(EditingDomain domain, boolean confirm) {
        this(domain);
        this.confirm = confirm;
    }

    public Command createCommand(Collection<?> selection) {
        this.selection = selection;
        DeleteMethodElementCommand cmd = this.createMethodElementDeleteCommand();
        cmd.addCommandListener(new DeleteMethodElementCommand.CommandListener(){

            public void notifyExecuted(EventObject eventObject) {
                DeleteMethodElementCommand cmd = (DeleteMethodElementCommand)eventObject.getSource();
                MethodElementDeleteAction.this.didDelete(cmd.getResult());
            }

            public void notifyFailure(EventObject eventObject) {
                MethodElementDeleteAction.this.deleteFailed();
            }
        });
        return cmd;
    }

    protected void deleteFailed() {
    }

    public DeleteMethodElementCommand createMethodElementDeleteCommand() {
        return new DeleteMethodElementCommand(super.createCommand(this.selection), this.selection, this.confirm){

            protected void loadOppositeFeatures(List oppositeFeatures, Set deletedGUIDs) {
                ILibraryResourceSet resourceSet = (ILibraryResourceSet)LibraryService.getInstance().getCurrentMethodLibrary().eResource().getResourceSet();
                resourceSet.loadOppositeFeatures(oppositeFeatures, deletedGUIDs);
            }
        };
    }

    protected void didDelete(Collection<?> deletedElements) {
    }

    protected String getDeleteConfirmationMessage() {
        return LibraryUIResources.MethodElementDeleteAction_deleteconfirm_text;
    }

    protected boolean confirmDelete() {
        if (!this.confirm) {
            return true;
        }
        if (this.selection == null || this.selection.isEmpty()) {
            return false;
        }
        int i = 0;
        StringBuffer elementStr = new StringBuffer();
        Iterator<?> it = this.selection.iterator();
        while (it.hasNext()) {
            Object obj = TngUtil.unwrap(it.next());
            if (!(obj instanceof MethodElement)) continue;
            if (i > 0) {
                elementStr.append(", ");
            }
            elementStr.append(this.getDisplayString((MethodElement)obj));
            ++i;
        }
        Object[] args = new Object[]{elementStr.toString()};
        String msg = LibraryUIResources.bind((String)LibraryUIResources.confirmDeleteDialog_msg, (Object[])args);
        String title = LibraryUIResources.confirmDeleteDialog_title;
        boolean deleteOk = LibraryUIPlugin.getDefault().getMsgDialog().displayConfirmation(title, msg);
        return deleteOk;
    }

    protected String getDisplayString(MethodElement element) {
        return element.getName();
    }

    @Override
    public void setProgressMonitor(IProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }

    protected IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new NullProgressMonitor();
        }
        return this.progressMonitor;
    }

    public void run() {
        LibraryLockingOperationRunner runner = new LibraryLockingOperationRunner();
        runner.setProgressMonitor(this.getProgressMonitor());
        runner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                MethodElementDeleteAction.this.performDelete();
            }
        });
    }

    protected void performDelete() {
        super.run();
    }
}

