/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.internal.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.library.LibraryManagerFactory;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.internal.wizards.OpenLibraryWizardPageFactory;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.ui.preferences.RecentlyOpenedLibrary;
import org.eclipse.epf.library.ui.wizards.OpenLibraryWizardPage;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OpenLibraryMainPage2
extends BaseWizardPage {
    public static final String PAGE_NAME = OpenLibraryMainPage2.class.getName();
    protected static final String TYPE_ID = "typeId";
    protected Combo nameCombo;
    protected Text uriText;
    protected Button openUnlistedLibraryCheckbox;
    protected boolean openUnlistedLibrary = false;
    protected Button[] radioButtons;
    protected Map<String, RecentlyOpenedLibrary> recentlyOpenedLibraries = new HashMap<String, RecentlyOpenedLibrary>();

    public OpenLibraryMainPage2() {
        super(PAGE_NAME);
        this.setTitle(LibraryUIResources.openLibraryWizard_title);
        this.setDescription(LibraryUIResources.openLibraryMainWizardPage_title_2);
        this.setImageDescriptor(LibraryUIPlugin.getDefault().getImageDescriptor("full/wizban/Open.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(LibraryUIResources.nameLabel_text);
        this.nameCombo = new Combo(composite, 2056);
        this.nameCombo.setLayoutData((Object)new GridData(768));
        List libraryList = OpenLibraryMainPage2.getRecentlyOpenedLibraries();
        for (RecentlyOpenedLibrary library : libraryList) {
            this.recentlyOpenedLibraries.put(library.getName(), library);
        }
        String[] libraryNames = new String[this.recentlyOpenedLibraries.size()];
        this.recentlyOpenedLibraries.keySet().toArray(libraryNames);
        this.nameCombo.setItems(libraryNames);
        Label uriLabel = new Label(composite, 0);
        uriLabel.setText(LibraryUIResources.uriLabel_text);
        this.uriText = new Text(composite, 2048);
        this.uriText.setLayoutData((Object)new GridData(768));
        this.uriText.setEditable(false);
        this.openUnlistedLibraryCheckbox = new Button(composite, 32);
        this.openUnlistedLibraryCheckbox.setText(LibraryUIResources.openUnlistedLibraryCheckbox_text);
        this.openUnlistedLibraryCheckbox.setLayoutData((Object)new GridData(768));
        ((GridData)this.openUnlistedLibraryCheckbox.getLayoutData()).horizontalSpan = 2;
        Label libraryTypeLabel = new Label(composite, 0);
        libraryTypeLabel.setText(LibraryUIResources.libraryTypeLabel_text);
        Composite typeComposite = new Composite(composite, 0);
        typeComposite.setLayout((Layout)new GridLayout(2, false));
        typeComposite.setLayoutData((Object)new GridData(768));
        Map types = LibraryManagerFactory.getInstance().getLibraryTypes();
        this.radioButtons = new Button[types.size()];
        int radioButtonIndex = 0;
        for (String typeId : types.keySet()) {
            String typeName = (String)types.get(typeId);
            Button radioButton = new Button(typeComposite, 16);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    OpenLibraryMainPage2.this.setPageComplete(OpenLibraryMainPage2.this.isPageComplete());
                    OpenLibraryMainPage2.this.getWizard().getContainer().updateButtons();
                }
            });
            radioButton.setText(typeName);
            radioButton.setData(TYPE_ID, (Object)typeId);
            this.radioButtons[radioButtonIndex++] = radioButton;
        }
        if (this.radioButtons.length > 0) {
            this.radioButtons[0].setSelection(true);
        }
        this.addListeners();
        this.setPageComplete(this.isPageComplete());
        this.setControl((Control)composite);
    }

    public IWizardPage getNextPage() {
        OpenLibraryWizardPage wizardPage = OpenLibraryWizardPageFactory.getInstance().getWizardPage(this.getLibraryType());
        if (wizardPage != null) {
            wizardPage.onEnterPage(this.getLibraryName());
        }
        if (!this.openUnlistedLibrary) {
            return null;
        }
        return wizardPage;
    }

    public boolean isPageComplete() {
        return this.getLibraryName().length() > 0 || this.openUnlistedLibrary;
    }

    private void addListeners() {
        this.nameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                OpenLibraryMainPage2.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.openUnlistedLibraryCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OpenLibraryMainPage2.this.openUnlistedLibrary = OpenLibraryMainPage2.this.openUnlistedLibraryCheckbox.getSelection();
                OpenLibraryMainPage2.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public String getLibraryName() {
        return this.nameCombo.getText().trim();
    }

    public String getLibraryURI() {
        RecentlyOpenedLibrary library = this.recentlyOpenedLibraries.get(this.getLibraryName());
        return library.getURI().toString();
    }

    public String getLibraryPath() {
        RecentlyOpenedLibrary library = this.recentlyOpenedLibraries.get(this.getLibraryName());
        return library.getPath();
    }

    public boolean isOpenUnlistedLibrary() {
        return this.openUnlistedLibrary;
    }

    public String getLibraryType() {
        int i = 0;
        while (i < this.radioButtons.length) {
            Button radioButton = this.radioButtons[i];
            if (radioButton.getSelection()) {
                return (String)radioButton.getData(TYPE_ID);
            }
            ++i;
        }
        return (String)this.radioButtons[0].getData(TYPE_ID);
    }

    protected static List getRecentlyOpenedLibraries() {
        List libraryURIs = LibraryUIPreferences.getOpenLibraryURIsList();
        ArrayList<RecentlyOpenedLibrary> libraries = new ArrayList<RecentlyOpenedLibrary>();
        if (libraryURIs.size() > 0) {
            for (String libraryURI : libraryURIs) {
                libraries.add(new RecentlyOpenedLibrary(libraryURI));
            }
        }
        return libraries;
    }
}

