/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.migration.diagram.ad.wizards;

import java.util.Map;
import org.eclipse.epf.migration.diagram.DiagramMigrationPlugin;
import org.eclipse.epf.migration.diagram.MigrationResources;
import org.eclipse.epf.migration.diagram.util.MigrationUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Process;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class MigrationExportWizardPage
extends WizardPage
implements IWizardPage,
Listener {
    public static final String PAGE_NAME = MigrationExportWizardPage.class.getName();
    private static final String[] EMPTY_ARRAY = new String[0];
    private Button capabilityPatternRadioButton;
    private Button deliveryProcessRadioButton;
    private Combo processCombo;
    private Combo activityCombo;
    private Combo templateNameCombo;
    private Combo templateDirCombo;
    private Map capabilityPatterns;
    private Map deliveryProcesses;
    private Map activities;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            MigrationExportWizardPage.this.setPageComplete(MigrationExportWizardPage.this.isPageComplete());
        }
    };

    protected MigrationExportWizardPage() {
        super(PAGE_NAME);
        this.setTitle(MigrationResources.workflow_export_wizard_title);
        this.setDescription(MigrationResources.workflow_export_wizard_text);
        this.setImageDescriptor(DiagramMigrationPlugin.getDefault().getImageDescriptor("full/wizban/ExportXML.gif"));
    }

    public void createControl(Composite parent) {
        final Shell shell = parent.getShell();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group processGroup = new Group(composite, 0);
        processGroup.setLayout((Layout)new GridLayout(1, false));
        processGroup.setLayoutData((Object)new GridData(768));
        processGroup.setText(MigrationResources.workflow_export_wizard_processGroup_text);
        Composite buttonComposite = new Composite((Composite)processGroup, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        this.capabilityPatternRadioButton = new Button(buttonComposite, 16);
        this.capabilityPatternRadioButton.setText(MigrationResources.workflow_export_wizard_capabilityPatternRadioButton_text);
        this.capabilityPatternRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MigrationExportWizardPage.this.updateProcessCombo(MigrationExportWizardPage.this.capabilityPatterns);
                MigrationExportWizardPage.this.updateActivityCombo(MigrationExportWizardPage.this.getProcess());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.deliveryProcessRadioButton = new Button(buttonComposite, 16);
        this.deliveryProcessRadioButton.setText(MigrationResources.workflow_export_wizard_deliveryProcessRadioButton_text);
        this.deliveryProcessRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MigrationExportWizardPage.this.updateProcessCombo(MigrationExportWizardPage.this.deliveryProcesses);
                MigrationExportWizardPage.this.updateActivityCombo(MigrationExportWizardPage.this.getProcess());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Composite processComposite = new Composite((Composite)processGroup, 0);
        processComposite.setLayout((Layout)new GridLayout(2, false));
        processComposite.setLayoutData((Object)new GridData(768));
        Label processNameLabel = new Label(processComposite, 0);
        processNameLabel.setText(MigrationResources.workflow_export_wizard_processNameLabel_text);
        this.processCombo = new Combo(processComposite, 2056);
        this.processCombo.setLayoutData((Object)new GridData(768));
        this.processCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MigrationExportWizardPage.this.updateActivityCombo(MigrationExportWizardPage.this.getProcess());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Label activitiesNameLabel = new Label(processComposite, 0);
        activitiesNameLabel.setText(MigrationResources.workflow_export_wizard_activitiesNameLabel_text);
        this.activityCombo = new Combo(processComposite, 2056);
        this.activityCombo.setLayoutData((Object)new GridData(768));
        this.activityCombo.addModifyListener(this.modifyListener);
        this.capabilityPatterns = MigrationUtil.getCapabilityPatterns();
        this.deliveryProcesses = MigrationUtil.getDeliveryProcesses();
        String savedProcessType = DiagramMigrationPlugin.getDefault().getPreferenceStore().getString("processType");
        if (savedProcessType != null && savedProcessType.equals("DeliveryProcess") && this.deliveryProcesses.size() > 0) {
            this.deliveryProcessRadioButton.setSelection(true);
            this.updateProcessCombo(this.deliveryProcesses);
        } else if (savedProcessType != null && this.capabilityPatterns != null && this.capabilityPatterns.size() > 0) {
            this.capabilityPatternRadioButton.setSelection(true);
            this.updateProcessCombo(this.capabilityPatterns);
        } else if (this.capabilityPatterns != null && this.capabilityPatterns.size() > 0) {
            this.capabilityPatternRadioButton.setSelection(true);
            this.updateProcessCombo(this.capabilityPatterns);
        } else {
            this.deliveryProcessRadioButton.setSelection(true);
            this.updateProcessCombo(this.deliveryProcesses);
        }
        this.updateActivityCombo(this.getProcess());
        Group templateGroup = new Group(composite, 0);
        templateGroup.setLayout((Layout)new GridLayout(1, false));
        templateGroup.setLayoutData((Object)new GridData(768));
        templateGroup.setText(MigrationResources.workflow_export_wizard_templateGroup_text);
        Composite templateComposite = new Composite((Composite)templateGroup, 0);
        templateComposite.setLayout((Layout)new GridLayout(3, false));
        templateComposite.setLayoutData((Object)new GridData(768));
        Label templateNameLabel = new Label(templateComposite, 0);
        templateNameLabel.setText(MigrationResources.workflow_export_wizard_templateNameLabel_text);
        this.templateNameCombo = new Combo(templateComposite, 2048);
        this.templateNameCombo.setLayoutData((Object)new GridData(768));
        String prevName = DiagramMigrationPlugin.getDefault().getPreferenceStore().getString("templateNames");
        if (prevName != null) {
            this.templateNameCombo.add(prevName);
        }
        this.templateNameCombo.addModifyListener(this.modifyListener);
        new Label(templateComposite, 0);
        Label dirLabel = new Label(templateComposite, 0);
        dirLabel.setText(MigrationResources.workflow_export_wizard_dirLabel_text);
        this.templateDirCombo = new Combo(templateComposite, 2048);
        this.templateDirCombo.setLayoutData((Object)new GridData(768));
        String savedDir = DiagramMigrationPlugin.getDefault().getPreferenceStore().getString("targetDirs");
        if (savedDir != null) {
            this.templateDirCombo.add(savedDir);
            this.templateDirCombo.setText(savedDir);
        }
        this.templateDirCombo.addModifyListener(this.modifyListener);
        Button browseButton = new Button(templateComposite, 0);
        browseButton.setText(MigrationResources.workflow_export_wizard_browseButton_text);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    DirectoryDialog dialog = new DirectoryDialog(shell, 0);
                    String selectedDir = dialog.open();
                    if (selectedDir != null) {
                        MigrationExportWizardPage.this.templateDirCombo.add(selectedDir, 0);
                        MigrationExportWizardPage.this.templateDirCombo.setText(selectedDir);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.setControl((Control)composite);
    }

    public void handleEvent(Event event) {
    }

    protected void updateProcessCombo(Map processes) {
        if (processes != null && processes.size() > 0) {
            String[] names = new String[processes.size()];
            processes.keySet().toArray(names);
            this.processCombo.setItems(names);
            String savedProcess = DiagramMigrationPlugin.getDefault().getPreferenceStore().getString("processName");
            if (savedProcess != null && processes.containsKey(savedProcess)) {
                this.processCombo.setText(savedProcess);
            } else {
                this.processCombo.setText(this.processCombo.getItem(0));
            }
        } else {
            this.processCombo.setItems(EMPTY_ARRAY);
        }
    }

    protected void updateActivityCombo(Process process) {
        try {
            this.activities = MigrationUtil.getActivities(process);
            if (this.activities != null && this.activities.size() > 0) {
                String[] names = new String[this.activities.size()];
                this.activities.keySet().toArray(names);
                this.activityCombo.setItems(names);
                this.activityCombo.setText(names[0]);
            } else {
                this.activityCombo.setItems(EMPTY_ARRAY);
            }
        }
        catch (Exception exception) {}
    }

    public Process getProcess() {
        if (this.capabilityPatternRadioButton.getSelection()) {
            String name = this.processCombo.getText();
            return (Process)this.capabilityPatterns.get(name);
        }
        String name = this.processCombo.getText();
        return (Process)this.deliveryProcesses.get(name);
    }

    public String getTemplateName() {
        return this.templateNameCombo.getText();
    }

    public String getTargetDirectory() {
        return this.templateDirCombo.getText();
    }

    public boolean isPageComplete() {
        return this.processCombo.getText().trim().length() > 0 && this.templateNameCombo.getText().trim().length() > 0 && this.templateDirCombo.getText().trim().length() > 0 && this.activityCombo.getText().trim().length() > 0;
    }

    public Activity getActivity() {
        if (this.activityCombo.getSelectionIndex() != -1) {
            String activityName = this.activityCombo.getText();
            Activity activity = (Activity)this.activities.get(activityName);
            return activity;
        }
        return null;
    }
}

